/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.api.visitors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class FormulaToDotVisitor
implements FormulaVisitor<TraversalProcess> {
    private int nextId = 0;
    private final StringBuilder str = new StringBuilder();
    private final Map<Formula, Integer> ids = new HashMap<Formula, Integer>();

    @Override
    public TraversalProcess visitFreeVariable(Formula pF, String pName) {
        this.str.append(this.id(pF) + " [label=\"var:" + pName + "\"];\n");
        return TraversalProcess.CONTINUE;
    }

    @Override
    public TraversalProcess visitBoundVariable(Formula pF, int pDeBruijnIdx) {
        this.str.append(this.id(pF) + " [label=\"idx:" + pDeBruijnIdx + "\"];\n");
        return TraversalProcess.CONTINUE;
    }

    @Override
    public TraversalProcess visitConstant(Formula pF, Object pValue) {
        this.str.append(this.id(pF) + " [label=\"const:" + pValue + "\"];\n");
        return TraversalProcess.CONTINUE;
    }

    @Override
    public TraversalProcess visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
        int id = this.id(pF);
        this.str.append(id + " [label=\"" + (Object)((Object)pFunctionDeclaration.getKind()) + "\"];\n");
        for (Formula var : pArgs) {
            this.str.append(id + " -> " + this.id(var) + ";\n");
        }
        return TraversalProcess.CONTINUE;
    }

    @Override
    public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> pBoundVariables, BooleanFormula pBody) {
        int id = this.id(pF);
        this.str.append(id + "[label=\"" + (Object)((Object)pQuantifier) + "\"];\n");
        for (Formula var : pBoundVariables) {
            this.str.append(id + " -> " + this.id(var) + ";\n");
        }
        this.str.append(id + " -> " + this.id(pBody) + ";\n");
        return TraversalProcess.CONTINUE;
    }

    private int id(Formula f) {
        Integer id = this.ids.get(f);
        if (id == null) {
            id = this.nextId++;
            this.ids.put(f, id);
        }
        return id;
    }

    public String toString() {
        return "digraph FORMULA {\n" + this.str + "}";
    }
}

