/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.visitors.ExpectedFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class UFManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testDeclareAndCallUF() {
        ImmutableList names = ImmutableList.of((Object)"Func", (Object)"|Func|", (Object)"(Func)");
        for (String name : names) {
            NumeralFormula.IntegerFormula f;
            try {
                f = this.fmgr.declareAndCallUF(name, FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeNumber(1L)));
            }
            catch (RuntimeException e) {
                if (name.equals("|Func|")) {
                    throw new AssumptionViolatedException("unsupported UF name", (Throwable)e);
                }
                throw e;
            }
            FunctionDeclaration<?> declaration = this.getDeclaration(f);
            Truth.assertThat((String)declaration.getName()).isEqualTo((Object)name);
            Object f2 = this.mgr.makeApplication(declaration, new Formula[]{this.imgr.makeNumber(1L)});
            Truth.assertThat(f2).isEqualTo((Object)f);
        }
    }

    @Test
    public void testDeclareAndCallUFWithTypedArgs() {
        this.requireBooleanArgument();
        this.createAndCallUF("fooBool1", FormulaType.BooleanType, this.bmgr.makeTrue());
        this.createAndCallUF("fooBool2", FormulaType.BooleanType, this.bmgr.makeTrue(), this.bmgr.makeTrue());
        this.createAndCallUF("fooBool3", FormulaType.IntegerType, this.bmgr.makeTrue(), this.bmgr.makeTrue(), this.bmgr.makeTrue());
        this.createAndCallUF("fooInt1", FormulaType.IntegerType, new Formula[]{this.imgr.makeNumber(2L)});
        this.createAndCallUF("fooInt2", FormulaType.IntegerType, new Formula[]{this.imgr.makeNumber(1L), this.imgr.makeNumber(2L)});
        this.createAndCallUF("fooInt3", FormulaType.BooleanType, new Formula[]{this.imgr.makeNumber(1L), this.imgr.makeNumber(2L), this.imgr.makeNumber(3L)});
        this.createAndCallUF("fooMixed1", FormulaType.IntegerType, new Formula[]{this.bmgr.makeTrue(), this.imgr.makeNumber(2L)});
        this.createAndCallUF("fooMixed2", FormulaType.IntegerType, new Formula[]{this.bmgr.makeTrue(), this.bmgr.makeTrue(), this.imgr.makeNumber(2L)});
        this.createAndCallUF("fooMixed3", FormulaType.BooleanType, new Formula[]{this.bmgr.makeTrue(), this.imgr.makeNumber(2L), this.bmgr.makeTrue()});
    }

    @Test
    public void testDeclareAndCallUFWithRationalArgs() {
        this.requireRationals();
        this.createAndCallUF("fooRat1", FormulaType.RationalType, new Formula[]{this.rmgr.makeNumber(2.5)});
        this.createAndCallUF("fooRat2", FormulaType.IntegerType, new Formula[]{this.rmgr.makeNumber(1.5), this.rmgr.makeNumber(2.5)});
        this.requireBooleanArgument();
        this.createAndCallUF("fooMixed3", FormulaType.BooleanType, new Formula[]{this.bmgr.makeTrue(), this.imgr.makeNumber(2L), this.rmgr.makeNumber(3.33)});
    }

    @Test
    public void testDeclareAndCallUFWithBVArgs() {
        this.requireBitvectors();
        this.createAndCallUF("fooBV1", FormulaType.getBitvectorTypeWithSize(5), this.bvmgr.makeBitvector(3, 3L));
        this.requireBooleanArgument();
        this.createAndCallUF("fooMixedBV1", FormulaType.getBitvectorTypeWithSize(5), new Formula[]{this.bmgr.makeTrue(), this.imgr.makeNumber(2L), this.bvmgr.makeBitvector(3, 3L)});
        this.createAndCallUF("fooMixedBV2", FormulaType.BooleanType, new Formula[]{this.bmgr.makeTrue(), this.imgr.makeNumber(2L), this.bvmgr.makeBitvector(3, 3L)});
    }

    private void requireBooleanArgument() {
        TruthJUnit.assume().withMessage("Solver %s does not support boolean arguments", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
    }

    private void createAndCallUF(String name, FormulaType<? extends Formula> retType, Formula ... args) {
        Formula f = this.fmgr.declareAndCallUF(name, retType, args);
        FunctionDeclaration<?> declaration = this.getDeclaration(f);
        Truth.assertThat((String)declaration.getName()).isEqualTo((Object)name);
        Object f2 = this.mgr.makeApplication(declaration, args);
        Truth.assertThat(f2).isEqualTo((Object)f);
    }

    private FunctionDeclaration<?> getDeclaration(Formula pFormula) {
        return (FunctionDeclaration)this.mgr.visit(pFormula, new ExpectedFormulaVisitor<FunctionDeclaration<?>>(){

            @Override
            public FunctionDeclaration<?> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                return functionDeclaration;
            }
        });
    }
}

