/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.TruthJUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.BooleanFormulaSubject;

@RunWith(value=Parameterized.class)
public class TranslateFormulaTest {
    private final LogManager logger = LogManager.createTestLogManager();
    private SolverContext from;
    private SolverContext to;
    private FormulaManager managerFrom;
    private FormulaManager managerTo;
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers translateFrom;
    @Parameterized.Parameter(value=1)
    public SolverContextFactory.Solvers translateTo;

    @Parameterized.Parameters(name="{index}: {0} --> {1}")
    public static Object[] getSolversProduct() {
        int len = SolverContextFactory.Solvers.values().length;
        SolverContextFactory.Solvers[][] combinations = new SolverContextFactory.Solvers[len * len][2];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                combinations[i * len + j][0] = SolverContextFactory.Solvers.values()[i];
                combinations[i * len + j][1] = SolverContextFactory.Solvers.values()[j];
            }
        }
        return combinations;
    }

    @Before
    public void initSolvers() throws InvalidConfigurationException {
        Configuration empty = Configuration.builder().build();
        SolverContextFactory factory = new SolverContextFactory(empty, this.logger, ShutdownManager.create().getNotifier());
        try {
            this.from = factory.generateContext(this.translateFrom);
            this.to = factory.generateContext(this.translateTo);
        }
        catch (InvalidConfigurationException e) {
            TruthJUnit.assume().withMessage(e.getMessage()).that((Throwable)e).hasCauseThat().isNotInstanceOf(UnsatisfiedLinkError.class);
            throw e;
        }
        this.managerFrom = this.from.getFormulaManager();
        this.managerTo = this.to.getFormulaManager();
    }

    @After
    public void close() {
        if (this.from != null) {
            this.from.close();
        }
        if (this.to != null) {
            this.to.close();
        }
    }

    private void requireParser() {
        TruthJUnit.assume().withMessage("Solver %s does not support parsing formulae", new Object[]{this.translateTo}).that((Comparable)((Object)this.translateTo)).isNotEqualTo((Object)SolverContextFactory.Solvers.CVC4);
    }

    @Test
    public void testDumpingAndParsing() throws SolverException, InterruptedException {
        this.requireParser();
        BooleanFormula input = this.createTestFormula(this.managerFrom);
        String out = this.managerFrom.dumpFormula(input).toString();
        BooleanFormula parsed = this.managerTo.parse(out);
        ((BooleanFormulaSubject)BooleanFormulaSubject.assertUsing(this.to).that((Object)this.createTestFormula(this.managerTo))).isEquivalentTo(parsed);
    }

    @Test
    public void testTranslating() throws SolverException, InterruptedException {
        this.requireParser();
        BooleanFormula input = this.createTestFormula(this.managerFrom);
        BooleanFormula parsed = this.managerTo.translateFrom(input, this.managerFrom);
        ((BooleanFormulaSubject)BooleanFormulaSubject.assertUsing(this.to).that((Object)this.createTestFormula(this.managerTo))).isEquivalentTo(parsed);
    }

    private BooleanFormula createTestFormula(FormulaManager mgr) {
        BooleanFormulaManager bfmgr = mgr.getBooleanFormulaManager();
        IntegerFormulaManager ifmgr = mgr.getIntegerFormulaManager();
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("z");
        BooleanFormula t = bfmgr.and(bfmgr.or(ifmgr.equal(x, y), ifmgr.equal(x, (NumeralFormula.IntegerFormula)ifmgr.makeNumber(2L))), bfmgr.or(ifmgr.equal(y, z), ifmgr.equal(z, (NumeralFormula.IntegerFormula)ifmgr.makeNumber(10L))));
        return t;
    }
}

