/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.TruthJUnit;
import java.util.Random;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.test.Fuzzer;
import org.sosy_lab.java_smt.test.HardIntegerFormulaGenerator;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class TimeoutTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testTacticTimeout() throws InterruptedException {
        TruthJUnit.assume().withMessage("Only Z3 has native tactics").that((Comparable)((Object)this.solverToUse())).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        Fuzzer fuzzer = new Fuzzer(this.mgr, new Random(0L));
        String msg = "ShutdownRequest";
        this.expectedEx.expect(InterruptedException.class);
        this.expectedEx.expectMessage(msg);
        BooleanFormula test = fuzzer.fuzz(20, 3);
        this.shutdownManager.requestShutdown(msg);
        this.mgr.applyTactic(test, Tactic.NNF);
    }

    @Test
    public void testProverTimeout() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("Princess does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeout(() -> this.context.newProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testInterpolationProverTimeout() throws SolverException, InterruptedException {
        this.requireInterpolation();
        TruthJUnit.assume().withMessage("Princess does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeout(() -> this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testOptimizationProverTimeout() throws SolverException, InterruptedException {
        this.requireOptimization();
        this.testBasicProverTimeout(() -> this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    private void testBasicProverTimeout(Supplier<BasicProverEnvironment<?>> proverConstructor) throws SolverException, InterruptedException {
        HardIntegerFormulaGenerator gen = new HardIntegerFormulaGenerator(this.imgr, this.bmgr);
        BooleanFormula instance = gen.generate(20);
        this.expectedEx.expect(InterruptedException.class);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(1L);
                    TimeoutTest.this.shutdownManager.requestShutdown("Shutdown Request");
                }
                catch (InterruptedException pE) {
                    throw new UnsupportedOperationException("Unexpected interrupt");
                }
            }
        };
        try (BasicProverEnvironment<?> pe = proverConstructor.get();){
            pe.push(instance);
            t.start();
            pe.isUnsat();
        }
    }
}

