/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverTacticsTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void nnfTacticDefaultTest1() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula not_a_b = this.bmgr.not(this.bmgr.equivalence(a, b));
        BooleanFormula nnf = this.mgr.applyTactic(not_a_b, Tactic.NNF);
        this.assertThatFormula(nnf).isEquivalentTo(not_a_b);
        NNFChecker checker = new NNFChecker(this.mgr);
        this.bmgr.visit(nnf, checker);
        Truth.assertThat((Boolean)checker.isInNNF()).isTrue();
    }

    @Test
    public void nnfTacticDefaultTest2() throws SolverException, InterruptedException {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        BooleanFormula not_ITE_a_b_c = this.bmgr.not(this.bmgr.ifThenElse(a, b, c));
        BooleanFormula nnf = this.mgr.applyTactic(not_ITE_a_b_c, Tactic.NNF);
        this.assertThatFormula(nnf).isEquivalentTo(not_ITE_a_b_c);
        NNFChecker checker = new NNFChecker(this.mgr);
        checker.visit(nnf);
        Truth.assertThat((Boolean)checker.isInNNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest1() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solver)).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula equiv_a_b = this.bmgr.equivalence(a, b);
        BooleanFormula not_equiv_a_b = this.bmgr.not(equiv_a_b);
        BooleanFormula cnf_equiv_a_b = this.mgr.applyTactic(equiv_a_b, Tactic.TSEITIN_CNF);
        this.assertThatFormula(cnf_equiv_a_b).isEquisatisfiableTo(equiv_a_b);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf_equiv_a_b);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
        BooleanFormula cnf_not_equiv_a_b = this.mgr.applyTactic(not_equiv_a_b, Tactic.TSEITIN_CNF);
        this.assertThatFormula(cnf_not_equiv_a_b).isEquisatisfiableTo(not_equiv_a_b);
        checker = new CNFChecker(this.mgr);
        checker.visit(cnf_not_equiv_a_b);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest2() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solver)).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        BooleanFormula ITE_a_b_c = this.bmgr.ifThenElse(a, b, c);
        BooleanFormula not_ITE_a_b_c = this.bmgr.not(this.bmgr.ifThenElse(a, b, c));
        BooleanFormula cnf_ITE_a_b_c = this.mgr.applyTactic(ITE_a_b_c, Tactic.TSEITIN_CNF);
        this.assertThatFormula(cnf_ITE_a_b_c).isEquisatisfiableTo(ITE_a_b_c);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf_ITE_a_b_c);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
        BooleanFormula cnf_not_ITE_a_b_c = this.mgr.applyTactic(not_ITE_a_b_c, Tactic.TSEITIN_CNF);
        this.assertThatFormula(cnf_not_ITE_a_b_c).isEquisatisfiableTo(not_ITE_a_b_c);
        checker = new CNFChecker(this.mgr);
        checker.visit(cnf_not_ITE_a_b_c);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    @Test
    public void cnfTacticDefaultTest3() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solver)).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        BooleanFormula z = this.bmgr.makeVariable("z");
        BooleanFormula w = this.bmgr.makeVariable("w");
        BooleanFormula u = this.bmgr.makeVariable("u");
        BooleanFormula v = this.bmgr.makeVariable("v");
        ArrayList<BooleanFormula> disjuncts = new ArrayList<BooleanFormula>();
        disjuncts.add(this.bmgr.and(x, y));
        disjuncts.add(this.bmgr.and(z, w));
        disjuncts.add(this.bmgr.and(u, v));
        BooleanFormula f = this.bmgr.or(disjuncts);
        BooleanFormula cnf = this.mgr.applyTactic(f, Tactic.TSEITIN_CNF);
        this.assertThatFormula(cnf).isEquisatisfiableTo(f);
        CNFChecker checker = new CNFChecker(this.mgr);
        checker.visit(cnf);
        Truth.assertThat((Boolean)checker.isInCNF()).isTrue();
    }

    @Test
    public void ufEliminationSimpleTest() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, variable2, variable4);
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.mgr.applyTactic(f, Tactic.ACKERMANNIZATION);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void ufEliminationNestedUfsTest() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf1Decl = this.fmgr.declareUF("uf1", FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula uf1a = this.fmgr.callUF(uf1Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf1b = this.fmgr.callUF(uf1Decl, variable2, variable1);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf2", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, uf1a, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, uf1b, variable4);
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.mgr.applyTactic(f, Tactic.ACKERMANNIZATION);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf1");
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf2");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void ufEliminationNesteQuantifierTest() throws InterruptedException {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, variable2, variable4);
        BooleanFormula f = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)variable1, (Object)variable2, (Object)variable3, (Object)variable4), this.bmgr.equivalence(f1, f2));
        try {
            this.mgr.applyTactic(f, Tactic.ACKERMANNIZATION);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class NNFChecker
    implements BooleanFormulaVisitor<Void> {
        private final BooleanFormulaManager bfmgr;
        boolean wasLastVisitNot = false;
        boolean notOnlyAtAtoms = true;

        protected NNFChecker(FormulaManager pFmgr) {
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        Void visit(BooleanFormula f) {
            return this.bfmgr.visit(f, this);
        }

        public boolean isInNNF() {
            return this.notOnlyAtAtoms;
        }

        @Override
        public Void visitConstant(boolean value) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitBoundVar(BooleanFormula var, int deBruijnIdx) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            this.wasLastVisitNot = false;
            return null;
        }

        @Override
        public Void visitNot(BooleanFormula pOperand) {
            this.wasLastVisitNot = true;
            return this.visit(pOperand);
        }

        @Override
        public Void visitAnd(List<BooleanFormula> pOperands) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                pOperands.forEach(this::visit);
            }
            return null;
        }

        @Override
        public Void visitOr(List<BooleanFormula> pOperands) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                pOperands.forEach(this::visit);
            }
            return null;
        }

        @Override
        public Void visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            return null;
        }

        @Override
        public Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pCondition);
                this.visit(pThenFormula);
                this.visit(pElseFormula);
            }
            return null;
        }

        @Override
        public Void visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifierAST, List<Formula> boundVars, BooleanFormula pBody) {
            if (this.wasLastVisitNot) {
                this.notOnlyAtAtoms = false;
            } else {
                this.visit(pBody);
            }
            return null;
        }
    }

    private static class CNFChecker
    implements BooleanFormulaVisitor<Void> {
        private final BooleanFormulaManager bfmgr;
        boolean startsWithAnd = false;
        boolean containsMoreAnd = false;
        boolean started = false;

        protected CNFChecker(FormulaManager pFmgr) {
            this.bfmgr = pFmgr.getBooleanFormulaManager();
        }

        Void visit(BooleanFormula f) {
            return this.bfmgr.visit(f, this);
        }

        public boolean isInCNF() {
            return this.startsWithAnd && !this.containsMoreAnd || this.started && !this.startsWithAnd;
        }

        @Override
        public Void visitConstant(boolean value) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitBoundVar(BooleanFormula f, int deBruijnIdx) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitNot(BooleanFormula pOperand) {
            this.started = true;
            return this.visit(pOperand);
        }

        @Override
        public Void visitAnd(List<BooleanFormula> pOperands) {
            if (!this.started) {
                this.started = true;
                this.startsWithAnd = true;
            } else {
                this.containsMoreAnd = true;
            }
            pOperands.forEach(this::visit);
            return null;
        }

        @Override
        public Void visitOr(List<BooleanFormula> pOperands) {
            if (this.started) {
                pOperands.forEach(this::visit);
            }
            return null;
        }

        @Override
        public Void visitXor(BooleanFormula operand1, BooleanFormula operand2) {
            this.started = true;
            return null;
        }

        @Override
        public Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.started) {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            if (this.started) {
                this.visit(pOperand1);
                this.visit(pOperand2);
            }
            return null;
        }

        @Override
        public Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            if (this.started) {
                this.visit(pCondition);
                this.visit(pThenFormula);
                this.visit(pElseFormula);
            }
            return null;
        }

        @Override
        public Void visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifierAST, List<Formula> boundVars, BooleanFormula pBody) {
            if (this.started) {
                this.visit(pBody);
            }
            return null;
        }
    }
}

