/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverAllSatTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public String proverEnv;
    private BasicProverEnvironment<?> env;
    private static final String EXPECTED_RESULT = "AllSatTest_unsat";

    @Parameterized.Parameters(name="solver {0} with prover {1}")
    public static Iterable<Object[]> getAllSolvers() {
        ArrayList<Object[]> junitParams = new ArrayList<Object[]>();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            junitParams.add(new Object[]{solver, "normal"});
            junitParams.add(new Object[]{solver, "itp"});
            junitParams.add(new Object[]{solver, "opt"});
        }
        return junitParams;
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setupEnvironment() {
        switch (this.proverEnv) {
            case "normal": {
                this.env = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_ALL_SAT);
                break;
            }
            case "itp": {
                TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
                TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.CVC4);
                this.env = this.context.newProverEnvironmentWithInterpolation(SolverContext.ProverOptions.GENERATE_ALL_SAT);
                break;
            }
            case "opt": {
                this.requireOptimization();
                this.env = this.context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_ALL_SAT);
                break;
            }
            default: {
                throw new AssertionError((Object)"unexpected");
            }
        }
    }

    @After
    public void closeEnvironment() {
        if (this.env != null) {
            this.env.close();
        }
    }

    @Test
    public void allSatTest_unsat() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula n1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula n2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula cond1 = this.imgr.equal(a, n1);
        BooleanFormula cond2 = this.imgr.equal(a, n2);
        BooleanFormula v1 = this.bmgr.makeVariable("b1");
        BooleanFormula v2 = this.bmgr.makeVariable("b2");
        this.env.push(cond1);
        this.env.push(cond2);
        this.env.push(this.bmgr.equivalence(v1, cond1));
        this.env.push(this.bmgr.equivalence(v2, cond2));
        TestAllSatCallback callback = new TestAllSatCallback(){

            @Override
            public void apply(List<BooleanFormula> pModel) {
                Assert.fail((String)("Formula is unsat, but all-sat callback called with model " + pModel));
            }
        };
        Truth.assertThat((String)this.env.allSat(callback, (List<BooleanFormula>)ImmutableList.of((Object)v1, (Object)v2))).isEqualTo((Object)EXPECTED_RESULT);
    }

    @Test
    public void allSatTest_xor() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula n1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula n2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula cond1 = this.imgr.equal(a, n1);
        BooleanFormula cond2 = this.imgr.equal(a, n2);
        BooleanFormula v1 = this.bmgr.makeVariable("b1");
        BooleanFormula v2 = this.bmgr.makeVariable("b2");
        this.env.push(this.bmgr.xor(cond1, cond2));
        this.env.push(this.bmgr.equivalence(v1, cond1));
        this.env.push(this.bmgr.equivalence(v2, cond2));
        TestAllSatCallback callback = new TestAllSatCallback();
        Truth.assertThat((String)this.env.allSat(callback, (List<BooleanFormula>)ImmutableList.of((Object)v1, (Object)v2))).isEqualTo((Object)EXPECTED_RESULT);
        Truth.assertThat((Iterable)callback.models).containsExactly(new Object[]{ImmutableList.of((Object)v1, (Object)this.bmgr.not(v2)), ImmutableList.of((Object)this.bmgr.not(v1), (Object)v2)});
    }

    @Test
    public void allSatTest_nondetValue() throws SolverException, InterruptedException {
        BooleanFormula v1 = this.bmgr.makeVariable("b1");
        BooleanFormula v2 = this.bmgr.makeVariable("b2");
        this.env.push(v1);
        TestAllSatCallback callback = new TestAllSatCallback();
        Truth.assertThat((String)this.env.allSat(callback, (List<BooleanFormula>)ImmutableList.of((Object)v1, (Object)v2))).isEqualTo((Object)EXPECTED_RESULT);
        Truth.assertThat((Iterable)callback.models).isAnyOf((Object)ImmutableList.of((Object)ImmutableList.of((Object)v1)), (Object)ImmutableList.of((Object)ImmutableList.of((Object)v1, (Object)v2), (Object)ImmutableList.of((Object)v1, (Object)this.bmgr.not(v2))), new Object[]{ImmutableList.of((Object)ImmutableList.of((Object)v1, (Object)this.bmgr.not(v2)), (Object)ImmutableList.of((Object)v1, (Object)v2))});
    }

    private static class TestAllSatCallback
    implements BasicProverEnvironment.AllSatCallback<String> {
        private final List<List<BooleanFormula>> models = new ArrayList<List<BooleanFormula>>();

        private TestAllSatCallback() {
        }

        @Override
        public void apply(List<BooleanFormula> pModel) {
            this.models.add((List<BooleanFormula>)ImmutableList.copyOf(pModel));
        }

        @Override
        public String getResult() {
            return SolverAllSatTest.EXPECTED_RESULT;
        }
    }
}

