/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class RationalFormulaManagerTest
extends SolverBasedTest0 {
    private static final double[] SOME_DOUBLES = new double[]{0.0, 0.1, 0.25, 0.5, 1.0, 1.5, 1.9, 2.1, 2.5, -0.1, -0.5, -1.0, -1.5, -1.9, -2.1, -2.5};
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void rationalToIntTest() throws SolverException, InterruptedException {
        this.requireRationals();
        for (double v : SOME_DOUBLES) {
            NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)this.imgr.makeNumber((int)Math.floor(v));
            NumeralFormula.RationalFormula r = (NumeralFormula.RationalFormula)this.rmgr.makeNumber(v);
            Assert.assertEquals(this.mgr.getFormulaType(i), FormulaType.IntegerType);
            Assert.assertEquals(this.mgr.getFormulaType(this.rmgr.floor(r)), FormulaType.IntegerType);
            this.assertThatFormula(this.imgr.equal(i, this.rmgr.floor(r))).isSatisfiable();
        }
    }

    @Test
    public void intToIntTest() throws SolverException, InterruptedException {
        for (double v : SOME_DOUBLES) {
            NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)this.imgr.makeNumber((int)Math.floor(v));
            Assert.assertEquals(this.mgr.getFormulaType(i), FormulaType.IntegerType);
            Assert.assertEquals(this.mgr.getFormulaType(this.imgr.floor(i)), FormulaType.IntegerType);
            this.assertThatFormula(this.imgr.equal(i, this.imgr.floor(i))).isTautological();
        }
    }

    @Test
    public void intToIntWithRmgrTest() throws SolverException, InterruptedException {
        this.requireRationals();
        for (double v : SOME_DOUBLES) {
            NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)this.imgr.makeNumber((int)Math.floor(v));
            Assert.assertEquals(this.mgr.getFormulaType(i), FormulaType.IntegerType);
            Assert.assertEquals(this.mgr.getFormulaType(this.rmgr.floor(i)), FormulaType.IntegerType);
            this.assertThatFormula(this.imgr.equal(i, this.rmgr.floor(i))).isTautological();
        }
    }

    @Test
    public void floorIsLessOrEqualsValueTest() throws SolverException, InterruptedException {
        this.requireRationals();
        this.requireQuantifiers();
        NumeralFormula.RationalFormula v = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("v");
        this.assertThatFormula(this.rmgr.lessOrEquals(this.rmgr.floor(v), v)).isTautological();
    }

    @Test
    public void floorIsGreaterThanValueTest() throws SolverException, InterruptedException {
        this.requireRationals();
        this.requireQuantifiers();
        NumeralFormula.RationalFormula v = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("v");
        this.assertThatFormula(this.rmgr.lessOrEquals(this.rmgr.floor(v), v)).isTautological();
    }

    @Test
    public void forallFloorIsLessOrEqualsValueTest() throws SolverException, InterruptedException {
        this.requireRationals();
        this.requireQuantifiers();
        NumeralFormula.RationalFormula v = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("v");
        this.assertThatFormula(this.qmgr.forall(v, this.rmgr.lessOrEquals(this.rmgr.floor(v), v))).isTautological();
    }

    @Test
    public void forallFloorIsLessThanValueTest() throws SolverException, InterruptedException {
        this.requireRationals();
        this.requireQuantifiers();
        NumeralFormula.RationalFormula v = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("v");
        this.assertThatFormula(this.qmgr.forall(v, this.rmgr.lessThan(this.rmgr.floor(v), v))).isUnsatisfiable();
    }

    @Test
    public void visitFloorTest() {
        this.requireRationals();
        NumeralFormula.IntegerFormula f = this.rmgr.floor(this.rmgr.makeVariable("v"));
        Truth.assertThat(this.mgr.extractVariables(f)).hasSize(1);
        FunctionCollector collector = new FunctionCollector();
        Assert.assertTrue((boolean)this.mgr.visit(f, collector));
        Assert.assertEquals((Object)((Object)FunctionDeclarationKind.FLOOR), (Object)((Object)((FunctionDeclaration)Iterables.getOnlyElement((Iterable)collector.functions)).getKind()));
    }

    @Test(expected=Exception.class)
    public void failOnInvalidString() {
        this.rmgr.makeNumber("a");
        Assert.fail();
    }

    private static final class FunctionCollector
    extends DefaultFormulaVisitor<Boolean> {
        private final Set<FunctionDeclaration<?>> functions = new HashSet();

        private FunctionCollector() {
        }

        @Override
        public Boolean visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pFunctionDeclaration) {
            this.functions.add(pFunctionDeclaration);
            return true;
        }

        @Override
        protected Boolean visitDefault(Formula pF) {
            return true;
        }
    }
}

