/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;
import org.sosy_lab.java_smt.basicimpl.LongArrayBackedList;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5Model;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;

abstract class Mathsat5AbstractProver<T2>
extends AbstractProver<T2> {
    protected final Mathsat5SolverContext context;
    protected final long curEnv;
    private final long curConfig;
    private final long terminationTest;
    protected final Mathsat5FormulaCreator creator;
    protected boolean closed = false;
    private final ShutdownNotifier shutdownNotifier;

    protected Mathsat5AbstractProver(Mathsat5SolverContext pContext, Set<SolverContext.ProverOptions> pOptions, Mathsat5FormulaCreator pCreator, ShutdownNotifier pShutdownNotifier) {
        super(pOptions);
        this.context = pContext;
        this.creator = pCreator;
        this.curConfig = this.buildConfig(pOptions);
        this.curEnv = this.context.createEnvironment(this.curConfig);
        this.terminationTest = this.context.addTerminationTest(this.curEnv);
        this.shutdownNotifier = pShutdownNotifier;
    }

    private long buildConfig(Set<SolverContext.ProverOptions> opts) {
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        boolean generateUnsatCore = opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) || opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);
        config.put("model_generation", opts.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS) ? "true" : "false");
        config.put("unsat_core_generation", generateUnsatCore ? "1" : "0");
        if (generateUnsatCore) {
            config.put("theory.bv.eager", "false");
        }
        this.createConfig(config);
        long cfg = Mathsat5NativeApi.msat_create_config();
        for (Map.Entry entry : config.entrySet()) {
            Mathsat5NativeApi.msat_set_option_checked(cfg, (String)entry.getKey(), (String)entry.getValue());
        }
        return cfg;
    }

    protected abstract void createConfig(Map<String, String> var1);

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !Mathsat5NativeApi.msat_check_sat(this.curEnv);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkForLiterals(pAssumptions);
        return !Mathsat5NativeApi.msat_check_sat_with_assumptions(this.curEnv, Mathsat5FormulaManager.getMsatTerm(pAssumptions));
    }

    private void checkForLiterals(Collection<BooleanFormula> formulas) {
        for (BooleanFormula f : formulas) {
            long t = Mathsat5FormulaManager.getMsatTerm(f);
            if (Mathsat5NativeApi.msat_term_is_boolean_constant(this.curEnv, t) || Mathsat5NativeApi.msat_term_is_not(this.curEnv, t) && Mathsat5NativeApi.msat_term_is_boolean_constant(this.curEnv, Mathsat5NativeApi.msat_term_get_arg(t, 0))) continue;
            throw new UnsupportedOperationException("formula is not a (negated) literal: " + f);
        }
    }

    @Override
    public Mathsat5Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return new Mathsat5Model(this.getMsatModel(), this.creator, this);
    }

    protected long getMsatModel() throws SolverException {
        this.checkGenerateModels();
        return Mathsat5NativeApi.msat_get_model(this.curEnv);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_pop_backtrack_point(this.curEnv);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        long[] terms = Mathsat5NativeApi.msat_get_unsat_core(this.curEnv);
        return this.encapsulate(terms);
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) {
        long[] unsatAssumptions = Mathsat5NativeApi.msat_get_unsat_assumptions(this.curEnv);
        return Optional.of(this.encapsulate(unsatAssumptions));
    }

    private List<BooleanFormula> encapsulate(long[] terms) {
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>(terms.length);
        for (long t : terms) {
            result.add(this.creator.encapsulateBoolean(t));
        }
        return result;
    }

    @Override
    public void close() {
        if (!this.closed) {
            Mathsat5NativeApi.msat_destroy_env(this.curEnv);
            Mathsat5NativeApi.msat_free_termination_test(this.terminationTest);
            Mathsat5NativeApi.msat_destroy_config(this.curConfig);
            this.closed = true;
        }
    }

    @Override
    public <T> T allSat(BasicProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateAllSat();
        long[] imp = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            imp[i++] = Mathsat5FormulaManager.getMsatTerm(impF);
        }
        MathsatAllSatCallback<T> uCallback = new MathsatAllSatCallback<T>(callback);
        this.push();
        int numModels = Mathsat5NativeApi.msat_all_sat(this.curEnv, imp, uCallback);
        this.pop();
        if (numModels == -1) {
            throw new SolverException("Error occurred during Mathsat allsat: " + Mathsat5NativeApi.msat_last_error_message(this.curEnv));
        }
        if (numModels == -2) {
            throw new UnsupportedOperationException("allSat for trivially tautological formula");
        }
        return callback.getResult();
    }

    class MathsatAllSatCallback<T>
    implements Mathsat5NativeApi.AllSatModelCallback {
        private final BasicProverEnvironment.AllSatCallback<T> clientCallback;

        MathsatAllSatCallback(BasicProverEnvironment.AllSatCallback<T> pClientCallback) {
            this.clientCallback = pClientCallback;
        }

        @Override
        public void callback(long[] model) throws InterruptedException {
            Mathsat5AbstractProver.this.shutdownNotifier.shutdownIfNecessary();
            this.clientCallback.apply((List<BooleanFormula>)new LongArrayBackedList<BooleanFormula>(model){

                @Override
                protected BooleanFormula convert(long pE) {
                    return Mathsat5AbstractProver.this.creator.encapsulateBoolean(pE);
                }
            });
        }
    }
}

