/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.nyu.acsys.CVC4.Expr;
import edu.nyu.acsys.CVC4.Kind;
import edu.nyu.acsys.CVC4.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4NumeralFormulaManager;

public class CVC4IntegerFormulaManager
extends CVC4NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>
implements IntegerFormulaManager {
    CVC4IntegerFormulaManager(CVC4FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
    }

    @Override
    protected Type getNumeralType() {
        return (Type)this.getFormulaCreator().getIntegerType();
    }

    @Override
    protected Expr makeNumberImpl(double pNumber) {
        return this.makeNumberImpl((long)pNumber);
    }

    @Override
    protected Expr makeNumberImpl(BigDecimal pNumber) {
        return (Expr)this.decimalAsInteger(pNumber);
    }

    @Override
    public Expr divide(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.INTS_DIVISION, pParam1, pParam2);
    }

    @Override
    protected Expr modularCongruence(Expr pNumber1, Expr pNumber2, long pModulo) {
        return this.modularCongruence(pNumber1, pNumber2, BigInteger.valueOf(pModulo));
    }

    @Override
    protected Expr modularCongruence(Expr pNumber1, Expr pNumber2, BigInteger pModulo) {
        if (BigInteger.ZERO.compareTo(pModulo) < 0) {
            Expr n = this.makeNumberImpl(pModulo);
            Expr x = this.subtract(pNumber1, pNumber2);
            return this.exprManager.mkExpr(Kind.EQUAL, x, this.exprManager.mkExpr(Kind.MULT, n, this.exprManager.mkExpr(Kind.INTS_DIVISION, x, n)));
        }
        return this.exprManager.mkConst(true);
    }

    @Override
    protected Expr makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Expr makeNumberImpl(String pI) {
        if (!INTEGER_NUMBER.matcher(pI).matches()) {
            throw new NumberFormatException("number is not an integer value: " + pI);
        }
        return super.makeNumberImpl(pI);
    }

    @Override
    protected Expr makeVariableImpl(String pI) {
        return (Expr)this.formulaCreator.makeVariable((Type)this.getFormulaCreator().getIntegerType(), pI);
    }
}

