/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.collect.ImmutableList;
import edu.nyu.acsys.CVC4.Expr;
import edu.nyu.acsys.CVC4.ExprManager;
import edu.nyu.acsys.CVC4.FloatingPoint;
import edu.nyu.acsys.CVC4.FloatingPointConvertSort;
import edu.nyu.acsys.CVC4.FloatingPointSize;
import edu.nyu.acsys.CVC4.FloatingPointToFPFloatingPoint;
import edu.nyu.acsys.CVC4.FloatingPointToFPSignedBitVector;
import edu.nyu.acsys.CVC4.FloatingPointToFPUnsignedBitVector;
import edu.nyu.acsys.CVC4.FloatingPointToSBV;
import edu.nyu.acsys.CVC4.Kind;
import edu.nyu.acsys.CVC4.Rational;
import edu.nyu.acsys.CVC4.RoundingMode;
import edu.nyu.acsys.CVC4.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Expr, Type, ExprManager, Expr> {
    private final ExprManager exprManager;
    private final Expr roundingMode;

    protected CVC4FloatingPointFormulaManager(CVC4FormulaCreator pCreator, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        super(pCreator);
        this.exprManager = (ExprManager)pCreator.getEnv();
        this.roundingMode = this.getRoundingModeImpl(pFloatingPointRoundingMode);
    }

    private static FloatingPointSize getFPSize(FormulaType.FloatingPointType pType) {
        long pExponentSize = pType.getExponentSize();
        long pMantissaSize = pType.getMantissaSize();
        return new FloatingPointSize(pExponentSize, pMantissaSize + 1L);
    }

    @Override
    protected Expr getDefaultRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected Expr getRoundingModeImpl(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        switch (pFloatingPointRoundingMode) {
            case NEAREST_TIES_TO_EVEN: {
                return this.exprManager.mkConst(RoundingMode.roundNearestTiesToEven);
            }
            case NEAREST_TIES_AWAY: {
                return this.exprManager.mkConst(RoundingMode.roundNearestTiesToAway);
            }
            case TOWARD_POSITIVE: {
                return this.exprManager.mkConst(RoundingMode.roundTowardPositive);
            }
            case TOWARD_NEGATIVE: {
                return this.exprManager.mkConst(RoundingMode.roundTowardNegative);
            }
            case TOWARD_ZERO: {
                return this.exprManager.mkConst(RoundingMode.roundTowardZero);
            }
        }
        throw new AssertionError((Object)"Unexpected branch");
    }

    @Override
    protected Expr makeNumberImpl(double pN, FormulaType.FloatingPointType pType, Expr pRoundingMode) {
        return this.makeNumberImpl(Double.toString(pN), pType, pRoundingMode);
    }

    @Override
    protected Expr makeNumberAndRound(String pN, FormulaType.FloatingPointType pType, Expr pRoundingMode) {
        try {
            if (CVC4FloatingPointFormulaManager.isNegativeZero(Double.valueOf(pN))) {
                return this.negate(this.exprManager.mkConst(new FloatingPoint(CVC4FloatingPointFormulaManager.getFPSize(pType), pRoundingMode.getConstRoundingMode(), Rational.fromDecimal((String)pN))));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Rational rat = this.toRational(pN);
        BigInteger upperBound = CVC4FloatingPointFormulaManager.getBiggestNumberBeforeInf(pType.getMantissaSize(), pType.getExponentSize());
        if (rat.greater(Rational.fromDecimal((String)upperBound.negate().toString())) && rat.less(Rational.fromDecimal((String)upperBound.toString()))) {
            return this.exprManager.mkConst(new FloatingPoint(CVC4FloatingPointFormulaManager.getFPSize(pType), pRoundingMode.getConstRoundingMode(), rat));
        }
        if (rat.greater(Rational.fromDecimal((String)"0"))) {
            return this.makePlusInfinityImpl(pType);
        }
        return this.makeMinusInfinityImpl(pType);
    }

    private static BigInteger getBiggestNumberBeforeInf(int mantissa, int exponent) {
        int boundExponent = BigInteger.valueOf(2L).pow(exponent - 1).intValueExact();
        BigInteger upperBoundExponent = BigInteger.valueOf(2L).pow(boundExponent);
        int mantissaExponent = BigInteger.valueOf(2L).pow(exponent - 1).intValueExact() - 2 - mantissa;
        if (mantissaExponent >= 0) {
            upperBoundExponent = upperBoundExponent.subtract(BigInteger.valueOf(2L).pow(mantissaExponent));
        }
        return upperBoundExponent;
    }

    private Rational toRational(String pN) throws NumberFormatException {
        try {
            return Rational.fromDecimal((String)new BigDecimal(pN).toPlainString());
        }
        catch (NumberFormatException e1) {
            try {
                org.sosy_lab.common.rationals.Rational unused = org.sosy_lab.common.rationals.Rational.ofString((String)pN);
                return new Rational(pN);
            }
            catch (NumberFormatException e2) {
                throw new NumberFormatException("invalid numeral: " + pN);
            }
        }
    }

    @Override
    protected Expr makeVariableImpl(String varName, FormulaType.FloatingPointType pType) {
        return (Expr)this.formulaCreator.makeVariable((Type)this.formulaCreator.getFloatingPointType(pType), varName);
    }

    @Override
    protected Expr makePlusInfinityImpl(FormulaType.FloatingPointType pType) {
        return this.exprManager.mkConst(FloatingPoint.makeInf((FloatingPointSize)CVC4FloatingPointFormulaManager.getFPSize(pType), (boolean)false));
    }

    @Override
    protected Expr makeMinusInfinityImpl(FormulaType.FloatingPointType pType) {
        return this.exprManager.mkConst(FloatingPoint.makeInf((FloatingPointSize)CVC4FloatingPointFormulaManager.getFPSize(pType), (boolean)true));
    }

    @Override
    protected Expr makeNaNImpl(FormulaType.FloatingPointType pType) {
        return this.exprManager.mkConst(FloatingPoint.makeNaN((FloatingPointSize)CVC4FloatingPointFormulaManager.getFPSize(pType)));
    }

    @Override
    protected Expr castToImpl(Expr pNumber, FormulaType<?> pTargetType, Expr pRoundingMode) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            FloatingPointConvertSort fpConvertSort = new FloatingPointConvertSort(CVC4FloatingPointFormulaManager.getFPSize(targetType));
            Expr op = this.exprManager.mkConst(new FloatingPointToFPFloatingPoint(fpConvertSort));
            return this.exprManager.mkExpr(op, pRoundingMode, pNumber);
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            Expr op = this.exprManager.mkConst(new FloatingPointToSBV((long)targetType.getSize()));
            return this.exprManager.mkExpr(op, pRoundingMode, pNumber);
        }
        if (pTargetType.isRationalType()) {
            return this.exprManager.mkExpr(Kind.FLOATINGPOINT_TO_REAL, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    protected Expr castFromImpl(Expr pNumber, boolean pSigned, FormulaType.FloatingPointType pTargetType, Expr pRoundingMode) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, (FormulaType<?>)pTargetType, pRoundingMode);
        }
        if (formulaType.isBitvectorType()) {
            long pExponentSize = pTargetType.getExponentSize();
            long pMantissaSize = pTargetType.getMantissaSize();
            FloatingPointSize fpSize = new FloatingPointSize(pExponentSize, pMantissaSize + 1L);
            FloatingPointConvertSort fpConvert = new FloatingPointConvertSort(fpSize);
            Expr op = pSigned ? this.exprManager.mkConst(new FloatingPointToFPSignedBitVector(fpConvert)) : this.exprManager.mkConst(new FloatingPointToFPUnsignedBitVector(fpConvert));
            return this.exprManager.mkExpr(op, pRoundingMode, pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    private Expr genericCast(Expr pNumber, FormulaType<?> pTargetType) {
        Type type = pNumber.getType();
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        Expr castFuncDecl = (Expr)this.getFormulaCreator().declareUFImpl("__cast_" + argType + "_to_" + pTargetType, (Type)this.toSolverType(pTargetType), (List<Type>)ImmutableList.of((Object)type));
        return this.exprManager.mkExpr(Kind.APPLY_UF, castFuncDecl, pNumber);
    }

    @Override
    protected Expr negate(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_NEG, pParam1);
    }

    @Override
    protected Expr add(Expr pParam1, Expr pParam2, Expr pRoundingMode) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_PLUS, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Expr subtract(Expr pParam1, Expr pParam2, Expr pRoundingMode) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_SUB, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Expr divide(Expr pParam1, Expr pParam2, Expr pRoundingMode) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_DIV, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Expr multiply(Expr pParam1, Expr pParam2, Expr pRoundingMode) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_MULT, pRoundingMode, pParam1, pParam2);
    }

    @Override
    protected Expr assignment(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Expr equalWithFPSemantics(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_EQ, pParam1, pParam2);
    }

    @Override
    protected Expr greaterThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_GT, pParam1, pParam2);
    }

    @Override
    protected Expr greaterOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_GEQ, pParam1, pParam2);
    }

    @Override
    protected Expr lessThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_LT, pParam1, pParam2);
    }

    @Override
    protected Expr lessOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_LEQ, pParam1, pParam2);
    }

    @Override
    protected Expr isNaN(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISNAN, pParam1);
    }

    @Override
    protected Expr isInfinity(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISINF, pParam1);
    }

    @Override
    protected Expr isZero(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISZ, pParam1);
    }

    @Override
    protected Expr isSubnormal(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISSN, pParam1);
    }

    @Override
    protected Expr isNormal(Expr pParam) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISN, pParam);
    }

    @Override
    protected Expr isNegative(Expr pParam) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_ISNEG, pParam);
    }

    @Override
    protected Expr fromIeeeBitvectorImpl(Expr pNumber, FormulaType.FloatingPointType pTargetType) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_FP, pNumber);
    }

    @Override
    protected Expr toIeeeBitvectorImpl(Expr pNumber) {
        throw new UnsupportedOperationException("FP to IEEE-BV is not supported");
    }

    @Override
    protected Expr round(Expr pFormula, FloatingPointRoundingMode pRoundingMode) {
        return this.exprManager.mkExpr(Kind.FLOATINGPOINT_RTI, this.getRoundingModeImpl(pRoundingMode), pFormula);
    }
}

