/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;

public abstract class AbstractUFManager<TFormulaInfo, TFunctionDecl, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFunctionDecl>
implements UFManager {
    protected AbstractUFManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFunctionDecl> pCreator) {
        super(pCreator);
    }

    @Override
    public final <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgTypes) {
        List argTypes = Lists.transform(pArgTypes, this::toSolverType);
        return FunctionDeclarationImpl.of(pName, FunctionDeclarationKind.UF, pArgTypes, pReturnType, this.formulaCreator.declareUFImpl(pName, this.toSolverType(pReturnType), argTypes));
    }

    @Override
    public <T extends Formula> FunctionDeclaration<T> declareUF(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUF(pName, pReturnType, Arrays.asList(pArgs));
    }

    @Override
    public <T extends Formula> T callUF(FunctionDeclaration<T> funcType, Formula ... args) {
        return this.formulaCreator.callFunction(funcType, Arrays.asList(args));
    }

    @Override
    public final <T extends Formula> T callUF(FunctionDeclaration<T> pFunc, List<? extends Formula> pArgs) {
        return this.formulaCreator.callFunction(pFunc, pArgs);
    }

    @Override
    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        AbstractFormulaManager.checkVariableName(name);
        List argTypes = Lists.transform(pArgs, this.getFormulaCreator()::getFormulaType);
        FunctionDeclaration<T> func = this.declareUF(name, pReturnType, argTypes);
        return this.callUF(func, pArgs);
    }

    @Override
    public <T extends Formula> T declareAndCallUF(String name, FormulaType<T> pReturnType, Formula ... pArgs) {
        AbstractFormulaManager.checkVariableName(name);
        return this.declareAndCallUF(name, pReturnType, Arrays.asList(pArgs));
    }
}

