/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements NumeralFormulaManager<ParamFormulaType, ResultFormulaType> {
    private final NonLinearArithmetic nonLinearArithmetic;
    private final TFuncDecl multUfDecl;
    private final TFuncDecl divUfDecl;
    private final TFuncDecl modUfDecl;

    protected AbstractNumeralFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator, NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator);
        this.nonLinearArithmetic = (NonLinearArithmetic)((Object)Preconditions.checkNotNull((Object)((Object)pNonLinearArithmetic)));
        this.multUfDecl = this.createBinaryFunction("*");
        this.divUfDecl = this.createBinaryFunction("/");
        this.modUfDecl = this.createBinaryFunction("%");
    }

    private TFuncDecl createBinaryFunction(String name) {
        Object formulaType = this.toSolverType(this.getFormulaType());
        return this.formulaCreator.declareUFImpl(this.getFormulaType() + "_" + name + "_", formulaType, ImmutableList.of(formulaType, formulaType));
    }

    private TFormulaInfo makeUf(TFuncDecl decl, TFormulaInfo t1, TFormulaInfo t2) {
        return this.formulaCreator.callFunctionImpl(decl, ImmutableList.of(t1, t2));
    }

    protected ResultFormulaType wrap(TFormulaInfo pTerm) {
        return (ResultFormulaType)((NumeralFormula)this.getFormulaCreator().encapsulate(this.getFormulaType(), pTerm));
    }

    protected abstract boolean isNumeral(TFormulaInfo var1);

    @Override
    public ResultFormulaType makeNumber(long i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(long var1);

    @Override
    public ResultFormulaType makeNumber(BigInteger i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(BigInteger var1);

    @Override
    public ResultFormulaType makeNumber(String i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(String var1);

    @Override
    public ResultFormulaType makeNumber(Rational pRational) {
        return this.wrap(this.makeNumberImpl(pRational));
    }

    protected TFormulaInfo makeNumberImpl(Rational pRational) {
        return this.makeNumberImpl(pRational.toString());
    }

    @Override
    public ResultFormulaType makeNumber(double pNumber) {
        return this.wrap(this.makeNumberImpl(pNumber));
    }

    protected abstract TFormulaInfo makeNumberImpl(double var1);

    @Override
    public ResultFormulaType makeNumber(BigDecimal pNumber) {
        return this.wrap(this.makeNumberImpl(pNumber));
    }

    protected abstract TFormulaInfo makeNumberImpl(BigDecimal var1);

    protected final TFormulaInfo decimalAsInteger(BigDecimal val) {
        if (val.scale() <= 0) {
            return this.makeNumberImpl(AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(val));
        }
        BigDecimal n = val.movePointRight(val.scale());
        BigInteger numerator = AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(n);
        BigDecimal d = BigDecimal.ONE.scaleByPowerOfTen(val.scale());
        BigInteger denominator = AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(d);
        assert (denominator.signum() > 0);
        return this.divide(this.makeNumberImpl(numerator), this.makeNumberImpl(denominator));
    }

    private static BigInteger convertBigDecimalToBigInteger(BigDecimal d) throws NumberFormatException {
        try {
            return d.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("Cannot represent BigDecimal " + d + " as BigInteger");
            nfe.initCause(e);
            throw nfe;
        }
    }

    @Override
    public ResultFormulaType makeVariable(String pVar) {
        AbstractFormulaManager.checkVariableName(pVar);
        return this.wrap(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public ResultFormulaType negate(ParamFormulaType pNumber) {
        Object param1 = this.extractInfo((Formula)pNumber);
        return this.wrap(this.negate((TFormulaInfo)param1));
    }

    @Override
    protected abstract TFormulaInfo negate(TFormulaInfo var1);

    @Override
    public ResultFormulaType add(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.add((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected abstract TFormulaInfo add(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public ResultFormulaType sum(List<ParamFormulaType> operands) {
        return this.wrap(this.sumImpl(Lists.transform(operands, this::extractInfo)));
    }

    protected TFormulaInfo sumImpl(List<TFormulaInfo> operands) {
        TFormulaInfo result = this.makeNumberImpl(0L);
        for (TFormulaInfo operand : operands) {
            result = this.add(result, operand);
        }
        return result;
    }

    @Override
    public ResultFormulaType subtract(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.subtract((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected abstract TFormulaInfo subtract(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public ResultFormulaType divide(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object result;
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_ALWAYS && (this.getFormulaType().equals(FormulaType.IntegerType) || !this.isNumeral(param2))) {
            result = this.makeUf(this.divUfDecl, param1, param2);
        } else {
            try {
                result = this.divide((TFormulaInfo)param1, (TFormulaInfo)param2);
            }
            catch (UnsupportedOperationException e) {
                if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_FALLBACK) {
                    result = this.makeUf(this.divUfDecl, param1, param2);
                }
                assert (this.nonLinearArithmetic == NonLinearArithmetic.USE);
                throw e;
            }
        }
        return this.wrap(result);
    }

    @Override
    protected TFormulaInfo divide(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        throw new UnsupportedOperationException();
    }

    public ResultFormulaType modulo(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object result;
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_ALWAYS) {
            result = this.makeUf(this.modUfDecl, param1, param2);
        } else {
            try {
                result = this.modulo((TFormulaInfo)param1, (TFormulaInfo)param2);
            }
            catch (UnsupportedOperationException e) {
                if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_FALLBACK) {
                    result = this.makeUf(this.modUfDecl, param1, param2);
                }
                assert (this.nonLinearArithmetic == NonLinearArithmetic.USE);
                throw e;
            }
        }
        return this.wrap(result);
    }

    protected TFormulaInfo modulo(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        throw new UnsupportedOperationException();
    }

    public BooleanFormula modularCongruence(ParamFormulaType pNumber1, ParamFormulaType pNumber2, long pModulo) {
        Preconditions.checkArgument((pModulo > 0L ? 1 : 0) != 0, (Object)"modular congruence needs a positive modulo.");
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.modularCongruence((TFormulaInfo)param1, (TFormulaInfo)param2, pModulo));
    }

    public BooleanFormula modularCongruence(ParamFormulaType pNumber1, ParamFormulaType pNumber2, BigInteger pModulo) {
        Preconditions.checkArgument((pModulo.signum() > 0 ? 1 : 0) != 0, (Object)"modular congruence needs a positive modulo.");
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.modularCongruence((TFormulaInfo)param1, (TFormulaInfo)param2, pModulo));
    }

    protected TFormulaInfo modularCongruence(TFormulaInfo a, TFormulaInfo b, BigInteger m) {
        throw new UnsupportedOperationException();
    }

    protected TFormulaInfo modularCongruence(TFormulaInfo a, TFormulaInfo b, long m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultFormulaType multiply(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object result;
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_ALWAYS && !this.isNumeral(param1) && !this.isNumeral(param2)) {
            result = this.makeUf(this.multUfDecl, param1, param2);
        } else {
            try {
                result = this.multiply((TFormulaInfo)param1, (TFormulaInfo)param2);
            }
            catch (UnsupportedOperationException e) {
                if (this.nonLinearArithmetic == NonLinearArithmetic.APPROXIMATE_FALLBACK) {
                    result = this.makeUf(this.multUfDecl, param1, param2);
                }
                assert (this.nonLinearArithmetic == NonLinearArithmetic.USE);
                throw e;
            }
        }
        return this.wrap(result);
    }

    @Override
    protected TFormulaInfo multiply(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanFormula equal(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.equal((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo equal(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula distinct(List<ParamFormulaType> pNumbers) {
        return this.wrapBool(this.distinctImpl(Lists.transform(pNumbers, this::extractInfo)));
    }

    protected abstract TFormulaInfo distinctImpl(List<TFormulaInfo> var1);

    @Override
    public BooleanFormula greaterThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.greaterThan((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.greaterOrEquals((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.lessThan((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.lessOrEquals((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public NumeralFormula.IntegerFormula floor(ParamFormulaType number) {
        if (this.getFormulaCreator().getFormulaType(number) == FormulaType.IntegerType) {
            return (NumeralFormula.IntegerFormula)number;
        }
        return this.getFormulaCreator().encapsulate(FormulaType.IntegerType, this.floor((TFormulaInfo)this.extractInfo((Formula)number)));
    }

    protected TFormulaInfo floor(TFormulaInfo number) {
        throw new AssertionError((Object)("method should only be called for RationalFormulae, but type is " + this.getFormulaCreator().getFormulaType(number)));
    }

    public static enum NonLinearArithmetic {
        USE,
        APPROXIMATE_FALLBACK,
        APPROXIMATE_ALWAYS;

    }
}

