/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverException;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ProverEnvironmentSubject
extends Subject {
    private final BasicProverEnvironment<?> stackUnderTest;

    private ProverEnvironmentSubject(FailureMetadata pMetadata, BasicProverEnvironment<?> pStack) {
        super(pMetadata, pStack);
        this.stackUnderTest = (BasicProverEnvironment)Preconditions.checkNotNull(pStack);
    }

    public static Subject.Factory<ProverEnvironmentSubject, BasicProverEnvironment<?>> proverEnvironments() {
        return (metadata, formula) -> new ProverEnvironmentSubject(metadata, (BasicProverEnvironment<?>)formula);
    }

    public static final ProverEnvironmentSubject assertThat(BasicProverEnvironment<?> prover) {
        return (ProverEnvironmentSubject)Truth.assert_().about(ProverEnvironmentSubject.proverEnvironments()).that(prover);
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (this.stackUnderTest.isUnsat()) {
            return;
        }
        try (Model model = this.stackUnderTest.getModel();){
            this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"unsatisfiable"), new Fact[]{Fact.fact((String)"but was", this.stackUnderTest), Fact.fact((String)"which is", (Object)"satisfiable"), Fact.fact((String)"which has model", (Object)model)});
        }
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (!this.stackUnderTest.isUnsat()) {
            return;
        }
        if (this.stackUnderTest instanceof ProverEnvironment) {
            try {
                List<BooleanFormula> unsatCore = this.stackUnderTest.getUnsatCore();
                if (!unsatCore.isEmpty()) {
                    this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[]{Fact.fact((String)"but was", this.stackUnderTest), Fact.fact((String)"which is", (Object)"unsatisfiable"), Fact.fact((String)"with unsat core", (Object)Joiner.on((char)'\n').join(unsatCore))});
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.failWithActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[0]);
    }
}

