/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import java.util.Random;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;

class Fuzzer {
    private final BooleanFormulaManager bfmgr;
    private final UniqueIdGenerator idGenerator;
    private BooleanFormula[] vars = new BooleanFormula[0];
    private final Random r;
    private static final String varNameTemplate = "VAR_";

    Fuzzer(FormulaManager pFmgr, Random pRandom) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.idGenerator = new UniqueIdGenerator();
        this.r = pRandom;
    }

    public BooleanFormula fuzz(int formulaSize, int maxNoVars) {
        this.vars = new BooleanFormula[maxNoVars];
        this.populateVars();
        return this.recFuzz(formulaSize);
    }

    public BooleanFormula fuzz(int formulaSize, BooleanFormula ... pVars) {
        this.vars = pVars;
        return this.recFuzz(formulaSize);
    }

    private BooleanFormula recFuzz(int formulaSize) {
        if (formulaSize == 1) {
            return this.getVar();
        }
        if (formulaSize == 2) {
            return this.bfmgr.not(this.getVar());
        }
        int pivot = --formulaSize / 2;
        switch (this.r.nextInt(3)) {
            case 0: {
                return this.bfmgr.or(this.recFuzz(pivot), this.recFuzz(formulaSize - pivot));
            }
            case 1: {
                return this.bfmgr.and(this.recFuzz(pivot), this.recFuzz(formulaSize - pivot));
            }
            case 2: {
                return this.bfmgr.not(this.recFuzz(formulaSize));
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private BooleanFormula getVar() {
        return this.vars[this.r.nextInt(this.vars.length)];
    }

    private void populateVars() {
        for (int i = 0; i < this.vars.length; ++i) {
            this.vars[i] = this.getNewVar();
        }
    }

    private BooleanFormula getNewVar() {
        return this.bfmgr.makeVariable(varNameTemplate + this.idGenerator.getFreshId());
    }
}

