/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.collect.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;

abstract class SmtInterpolNumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Term, Sort, SmtInterpolEnvironment, ParamFormulaType, ResultFormulaType, FunctionSymbol> {
    private static final ImmutableSet<String> NUMERIC_FUNCTIONS = ImmutableSet.of((Object)"+", (Object)"-", (Object)"*", (Object)"/", (Object)"div", (Object)"mod", (Object[])new String[0]);
    protected final SmtInterpolEnvironment env;

    SmtInterpolNumeralFormulaManager(SmtInterpolFormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.env = (SmtInterpolEnvironment)pCreator.getEnv();
    }

    @Override
    protected final boolean isNumeral(Term t) {
        boolean is = false;
        if (t instanceof ConstantTerm) {
            Object value = ((ConstantTerm)t).getValue();
            if (value instanceof Number || value instanceof Rational) {
                is = true;
            }
        } else if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            if ("-".equals(at.getFunction().getName()) && at.getParameters().length == 1 && this.isNumeral(at.getParameters()[0])) {
                is = true;
            } else if ("/".equals(at.getFunction().getName()) && at.getParameters().length == 2 && this.isNumeral(at.getParameters()[0]) && this.isNumeral(at.getParameters()[1])) {
                is = true;
            }
        }
        return is;
    }

    boolean consistsOfNumerals(Term val) {
        HashSet<Term> finished = new HashSet<Term>();
        ArrayDeque<Term> waitlist = new ArrayDeque<Term>();
        waitlist.add(val);
        while (!waitlist.isEmpty()) {
            Term t = (Term)waitlist.pop();
            if (!finished.add(t) || this.isNumeral(t)) continue;
            if (t instanceof ApplicationTerm) {
                ApplicationTerm app = (ApplicationTerm)t;
                FunctionSymbol func = app.getFunction();
                Term[] params = app.getParameters();
                if (params.length == 0) {
                    return false;
                }
                if (NUMERIC_FUNCTIONS.contains((Object)func.getName())) {
                    for (Term param : params) {
                        waitlist.add(param);
                    }
                    continue;
                }
                if ("ite".equals(func.getName())) {
                    waitlist.add(params[1]);
                    waitlist.add(params[2]);
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public Term negate(Term pNumber) {
        return this.env.term("*", this.env.numeral("-1"), pNumber);
    }

    @Override
    public Term add(Term pNumber1, Term pNumber2) {
        return this.env.term("+", pNumber1, pNumber2);
    }

    @Override
    public Term subtract(Term pNumber1, Term pNumber2) {
        return this.env.term("-", pNumber1, pNumber2);
    }

    @Override
    public Term multiply(Term pNumber1, Term pNumber2) {
        if (this.consistsOfNumerals(pNumber1) || this.consistsOfNumerals(pNumber2)) {
            return this.env.term("*", pNumber1, pNumber2);
        }
        return super.multiply(pNumber1, pNumber2);
    }

    @Override
    public Term equal(Term pNumber1, Term pNumber2) {
        return this.env.term("=", pNumber1, pNumber2);
    }

    @Override
    public Term distinctImpl(List<Term> pNumbers) {
        return this.env.term("distinct", pNumbers.toArray(new Term[0]));
    }

    @Override
    public Term greaterThan(Term pNumber1, Term pNumber2) {
        return this.env.term(">", pNumber1, pNumber2);
    }

    @Override
    public Term greaterOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term(">=", pNumber1, pNumber2);
    }

    @Override
    public Term lessThan(Term pNumber1, Term pNumber2) {
        return this.env.term("<", pNumber1, pNumber2);
    }

    @Override
    public Term lessOrEquals(Term pNumber1, Term pNumber2) {
        return this.env.term("<=", pNumber1, pNumber2);
    }
}

