/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class MinimizeTemp {
    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormulaManager bfmgr = context.getFormulaManager().getBooleanFormulaManager();
            IntegerFormulaManager ifmgr = context.getFormulaManager().getIntegerFormulaManager();
            BooleanFormula rule = MinimizeTemp.computeRule(bfmgr, ifmgr, prover);
            logger.log(Level.INFO, new Object[]{rule});
        }
    }

    private static BooleanFormula computeRule(BooleanFormulaManager bfmgr, IntegerFormulaManager ifmgr, OptimizationProverEnvironment prover) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula acThermostat = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("acThermostat");
        NumeralFormula.IntegerFormula num25 = (NumeralFormula.IntegerFormula)ifmgr.makeNumber(25L);
        NumeralFormula.IntegerFormula temp = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("temp");
        NumeralFormula.IntegerFormula num20 = (NumeralFormula.IntegerFormula)ifmgr.makeNumber(20L);
        BooleanFormula ac = bfmgr.makeVariable("ac");
        prover.addConstraint(ifmgr.greaterThan(acThermostat, num25));
        int handle = prover.minimize(acThermostat);
        OptimizationProverEnvironment.OptStatus status = prover.check();
        assert (status == OptimizationProverEnvironment.OptStatus.OPT);
        Model.ValueAssignment va = (Model.ValueAssignment)Iterables.tryFind((Iterable)prover.getModel(), v -> v.getKey().equals(acThermostat)).get();
        NumeralFormula.IntegerFormula minValue = (NumeralFormula.IntegerFormula)va.getValueAsFormula();
        minValue = (NumeralFormula.IntegerFormula)ifmgr.subtract(minValue, (NumeralFormula.IntegerFormula)ifmgr.makeNumber(BigInteger.ONE));
        BooleanFormula rule = bfmgr.implication(ifmgr.greaterThan(temp, num20), bfmgr.and(ac, ifmgr.equal(acThermostat, minValue)));
        return rule;
    }
}

