package org.sosy_lab.java_smt.example;

import ap.SimpleAPI;
import ap.SimpleAPI.PartialModel;
import ap.basetypes.IdealInt;
import ap.parser.IBoolLit;
import ap.parser.IIntLit;
import ap.theories.ModuloArithmetic$;
import scala.Enumeration.Value;
import scala.Option;

public class PrincessConstBVBug {

  public static void main(String[] args) {
    // create default environment, Java is ugly
    SimpleAPI api =
        SimpleAPI.apply(
            SimpleAPI.apply$default$1(),
            SimpleAPI.apply$default$2(),
            SimpleAPI.apply$default$3(),
            SimpleAPI.apply$default$4(),
            SimpleAPI.apply$default$5(),
            SimpleAPI.apply$default$6(),
            SimpleAPI.apply$default$7(),
            SimpleAPI.apply$default$8(),
            SimpleAPI.apply$default$9(),
            SimpleAPI.apply$default$10());

    // empty solver should trivially be SAT.
    Value sat = api.checkSat(true);
    assert sat.equals(SimpleAPI.ProverStatus$.MODULE$.Sat());
    PartialModel model = api.partialModel();

    // lets compute some primitive evaluations

    // booleans work fine
    Option<Object> value1 = model.eval(new IBoolLit(true));
    System.out.println("Evalutation for TRUE: " + value1);

    // numeral work fine
    Option<IdealInt> value2 = model.eval(new IIntLit(IdealInt.apply(3)));
    System.out.println("Evalutation for numeral 3: " + value2);

    // bitvectors fail
    Option<IdealInt> value3 = model.eval(ModuloArithmetic$.MODULE$.bv(4, IdealInt.apply(3)));
    System.out.println("Evalutation for BV 0011: " + value3);
  }
}
