/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import edu.stanford.CVC4.ArrayType;
import edu.stanford.CVC4.BitVectorType;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.FloatingPoint;
import edu.stanford.CVC4.FloatingPointSize;
import edu.stanford.CVC4.FloatingPointType;
import edu.stanford.CVC4.FunctionType;
import edu.stanford.CVC4.Integer;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import edu.stanford.CVC4.vectorType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4Formula;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaManager;

public class CVC4FormulaCreator
extends FormulaCreator<Expr, Type, ExprManager, Expr> {
    private static final Pattern FLOATING_POINT_PATTERN = Pattern.compile("^\\(fp #b(?<sign>\\d) #b(?<exp>\\d+) #b(?<mant>\\d+)$");
    private final Map<String, Expr> variablesCache = new HashMap<String, Expr>();
    private final Map<String, Expr> functionsCache = new HashMap<String, Expr>();
    private final ExprManager exprManager;
    private static final ImmutableMap<Kind, FunctionDeclarationKind> KIND_MAPPING = ImmutableMap.builder().put((Object)Kind.EQUAL, (Object)FunctionDeclarationKind.EQ).put((Object)Kind.DISTINCT, (Object)FunctionDeclarationKind.DISTINCT).put((Object)Kind.NOT, (Object)FunctionDeclarationKind.NOT).put((Object)Kind.AND, (Object)FunctionDeclarationKind.AND).put((Object)Kind.IMPLIES, (Object)FunctionDeclarationKind.IMPLIES).put((Object)Kind.OR, (Object)FunctionDeclarationKind.OR).put((Object)Kind.XOR, (Object)FunctionDeclarationKind.XOR).put((Object)Kind.ITE, (Object)FunctionDeclarationKind.ITE).put((Object)Kind.APPLY_UF, (Object)FunctionDeclarationKind.UF).put((Object)Kind.PLUS, (Object)FunctionDeclarationKind.ADD).put((Object)Kind.MULT, (Object)FunctionDeclarationKind.MUL).put((Object)Kind.MINUS, (Object)FunctionDeclarationKind.SUB).put((Object)Kind.INTS_DIVISION, (Object)FunctionDeclarationKind.DIV).put((Object)Kind.INTS_MODULUS, (Object)FunctionDeclarationKind.MODULO).put((Object)Kind.DIVISION, (Object)FunctionDeclarationKind.DIV).put((Object)Kind.LT, (Object)FunctionDeclarationKind.LT).put((Object)Kind.LEQ, (Object)FunctionDeclarationKind.LTE).put((Object)Kind.GT, (Object)FunctionDeclarationKind.GT).put((Object)Kind.GEQ, (Object)FunctionDeclarationKind.GTE).put((Object)Kind.BITVECTOR_PLUS, (Object)FunctionDeclarationKind.BV_ADD).put((Object)Kind.BITVECTOR_SUB, (Object)FunctionDeclarationKind.BV_SUB).put((Object)Kind.BITVECTOR_MULT, (Object)FunctionDeclarationKind.BV_MUL).put((Object)Kind.BITVECTOR_AND, (Object)FunctionDeclarationKind.BV_AND).put((Object)Kind.BITVECTOR_OR, (Object)FunctionDeclarationKind.BV_OR).put((Object)Kind.BITVECTOR_XOR, (Object)FunctionDeclarationKind.BV_XOR).put((Object)Kind.BITVECTOR_SLT, (Object)FunctionDeclarationKind.BV_SLT).put((Object)Kind.BITVECTOR_ULT, (Object)FunctionDeclarationKind.BV_ULT).put((Object)Kind.BITVECTOR_SLE, (Object)FunctionDeclarationKind.BV_SLE).put((Object)Kind.BITVECTOR_ULE, (Object)FunctionDeclarationKind.BV_ULE).put((Object)Kind.BITVECTOR_SGT, (Object)FunctionDeclarationKind.BV_SGT).put((Object)Kind.BITVECTOR_UGT, (Object)FunctionDeclarationKind.BV_UGT).put((Object)Kind.BITVECTOR_SGE, (Object)FunctionDeclarationKind.BV_SGE).put((Object)Kind.BITVECTOR_UGE, (Object)FunctionDeclarationKind.BV_UGE).put((Object)Kind.BITVECTOR_SDIV, (Object)FunctionDeclarationKind.BV_SDIV).put((Object)Kind.BITVECTOR_UDIV, (Object)FunctionDeclarationKind.BV_UDIV).put((Object)Kind.BITVECTOR_SREM, (Object)FunctionDeclarationKind.BV_SREM).put((Object)Kind.BITVECTOR_SHL, (Object)FunctionDeclarationKind.BV_SHL).put((Object)Kind.BITVECTOR_ASHR, (Object)FunctionDeclarationKind.BV_ASHR).put((Object)Kind.BITVECTOR_LSHR, (Object)FunctionDeclarationKind.BV_LSHR).put((Object)Kind.BITVECTOR_UREM, (Object)FunctionDeclarationKind.BV_UREM).put((Object)Kind.BITVECTOR_NOT, (Object)FunctionDeclarationKind.BV_NOT).put((Object)Kind.BITVECTOR_NEG, (Object)FunctionDeclarationKind.BV_NEG).put((Object)Kind.BITVECTOR_EXTRACT, (Object)FunctionDeclarationKind.BV_EXTRACT).put((Object)Kind.BITVECTOR_CONCAT, (Object)FunctionDeclarationKind.BV_CONCAT).put((Object)Kind.BITVECTOR_SIGN_EXTEND, (Object)FunctionDeclarationKind.BV_SIGN_EXTENSION).put((Object)Kind.BITVECTOR_ZERO_EXTEND, (Object)FunctionDeclarationKind.BV_ZERO_EXTENSION).put((Object)Kind.TO_INTEGER, (Object)FunctionDeclarationKind.FLOOR).put((Object)Kind.FLOATINGPOINT_TO_SBV, (Object)FunctionDeclarationKind.FP_CASTTO_SBV).put((Object)Kind.FLOATINGPOINT_TO_UBV, (Object)FunctionDeclarationKind.FP_CASTTO_UBV).put((Object)Kind.FLOATINGPOINT_TO_FP_FLOATINGPOINT, (Object)FunctionDeclarationKind.FP_CASTTO_FP).put((Object)Kind.FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR, (Object)FunctionDeclarationKind.BV_SCASTTO_FP).put((Object)Kind.FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR, (Object)FunctionDeclarationKind.BV_UCASTTO_FP).put((Object)Kind.FLOATINGPOINT_ISNAN, (Object)FunctionDeclarationKind.FP_IS_NAN).put((Object)Kind.FLOATINGPOINT_ISNEG, (Object)FunctionDeclarationKind.FP_IS_NEGATIVE).put((Object)Kind.FLOATINGPOINT_ISINF, (Object)FunctionDeclarationKind.FP_IS_INF).put((Object)Kind.FLOATINGPOINT_ISN, (Object)FunctionDeclarationKind.FP_IS_NORMAL).put((Object)Kind.FLOATINGPOINT_ISSN, (Object)FunctionDeclarationKind.FP_IS_SUBNORMAL).put((Object)Kind.FLOATINGPOINT_ISZ, (Object)FunctionDeclarationKind.FP_IS_ZERO).put((Object)Kind.FLOATINGPOINT_EQ, (Object)FunctionDeclarationKind.FP_EQ).put((Object)Kind.FLOATINGPOINT_ABS, (Object)FunctionDeclarationKind.FP_ABS).put((Object)Kind.FLOATINGPOINT_MAX, (Object)FunctionDeclarationKind.FP_MAX).put((Object)Kind.FLOATINGPOINT_MIN, (Object)FunctionDeclarationKind.FP_MIN).put((Object)Kind.FLOATINGPOINT_SQRT, (Object)FunctionDeclarationKind.FP_SQRT).put((Object)Kind.FLOATINGPOINT_NEG, (Object)FunctionDeclarationKind.FP_NEG).put((Object)Kind.FLOATINGPOINT_PLUS, (Object)FunctionDeclarationKind.FP_ADD).put((Object)Kind.FLOATINGPOINT_SUB, (Object)FunctionDeclarationKind.FP_SUB).put((Object)Kind.FLOATINGPOINT_MULT, (Object)FunctionDeclarationKind.FP_MUL).put((Object)Kind.FLOATINGPOINT_DIV, (Object)FunctionDeclarationKind.FP_DIV).put((Object)Kind.FLOATINGPOINT_LT, (Object)FunctionDeclarationKind.FP_LT).put((Object)Kind.FLOATINGPOINT_LEQ, (Object)FunctionDeclarationKind.FP_LE).put((Object)Kind.FLOATINGPOINT_GT, (Object)FunctionDeclarationKind.FP_GT).put((Object)Kind.FLOATINGPOINT_GEQ, (Object)FunctionDeclarationKind.FP_GE).put((Object)Kind.FLOATINGPOINT_RTI, (Object)FunctionDeclarationKind.FP_ROUND_TO_INTEGRAL).put((Object)Kind.FLOATINGPOINT_TO_FP_IEEE_BITVECTOR, (Object)FunctionDeclarationKind.FP_AS_IEEEBV).put((Object)Kind.STRING_CONCAT, (Object)FunctionDeclarationKind.STR_CONCAT).put((Object)Kind.STRING_PREFIX, (Object)FunctionDeclarationKind.STR_PREFIX).put((Object)Kind.STRING_SUFFIX, (Object)FunctionDeclarationKind.STR_SUFFIX).put((Object)Kind.STRING_STRCTN, (Object)FunctionDeclarationKind.STR_CONTAINS).put((Object)Kind.STRING_SUBSTR, (Object)FunctionDeclarationKind.STR_SUBSTRING).put((Object)Kind.STRING_STRREPL, (Object)FunctionDeclarationKind.STR_REPLACE).put((Object)Kind.STRING_STRREPLALL, (Object)FunctionDeclarationKind.STR_REPLACE_ALL).put((Object)Kind.STRING_CHARAT, (Object)FunctionDeclarationKind.STR_CHAR_AT).put((Object)Kind.STRING_LENGTH, (Object)FunctionDeclarationKind.STR_LENGTH).put((Object)Kind.STRING_STRIDOF, (Object)FunctionDeclarationKind.STR_INDEX_OF).put((Object)Kind.STRING_TO_REGEXP, (Object)FunctionDeclarationKind.STR_TO_RE).put((Object)Kind.STRING_IN_REGEXP, (Object)FunctionDeclarationKind.STR_IN_RE).put((Object)Kind.STRING_STOI, (Object)FunctionDeclarationKind.STR_TO_INT).put((Object)Kind.STRING_ITOS, (Object)FunctionDeclarationKind.INT_TO_STR).put((Object)Kind.STRING_LT, (Object)FunctionDeclarationKind.STR_LT).put((Object)Kind.STRING_LEQ, (Object)FunctionDeclarationKind.STR_LE).put((Object)Kind.REGEXP_PLUS, (Object)FunctionDeclarationKind.RE_PLUS).put((Object)Kind.REGEXP_STAR, (Object)FunctionDeclarationKind.RE_STAR).put((Object)Kind.REGEXP_OPT, (Object)FunctionDeclarationKind.RE_OPTIONAL).put((Object)Kind.REGEXP_CONCAT, (Object)FunctionDeclarationKind.RE_CONCAT).put((Object)Kind.REGEXP_UNION, (Object)FunctionDeclarationKind.RE_UNION).put((Object)Kind.REGEXP_RANGE, (Object)FunctionDeclarationKind.RE_RANGE).put((Object)Kind.REGEXP_INTER, (Object)FunctionDeclarationKind.RE_INTERSECT).put((Object)Kind.REGEXP_COMPLEMENT, (Object)FunctionDeclarationKind.RE_COMPLEMENT).put((Object)Kind.REGEXP_DIFF, (Object)FunctionDeclarationKind.RE_DIFFERENCE).buildOrThrow();

    protected CVC4FormulaCreator(ExprManager pExprManager) {
        super(pExprManager, pExprManager.booleanType(), pExprManager.integerType(), pExprManager.realType(), pExprManager.stringType(), pExprManager.regExpType());
        this.exprManager = pExprManager;
    }

    @Override
    public Expr makeVariable(Type type, String name) {
        Expr exp = this.variablesCache.computeIfAbsent(name, n -> this.exprManager.mkVar(name, type));
        Preconditions.checkArgument((boolean)type.equals(exp.getType()), (String)"symbol name already in use for different type %s", (Object)exp.getType());
        return exp;
    }

    public Expr makeBoundCopy(Expr var) {
        Type type = var.getType();
        String name = CVC4FormulaCreator.getName(var);
        Expr boundCopy = this.exprManager.mkBoundVar(name, type);
        return boundCopy;
    }

    @Override
    public Type getBitvectorType(int pBitwidth) {
        return this.exprManager.mkBitVectorType((long)pBitwidth);
    }

    @Override
    public Type getFloatingPointType(FormulaType.FloatingPointType pType) {
        return this.exprManager.mkFloatingPointType((long)pType.getExponentSize(), (long)(pType.getMantissaSize() + 1));
    }

    @Override
    public Type getArrayType(Type pIndexType, Type pElementType) {
        return this.exprManager.mkArrayType(pIndexType, pElementType);
    }

    @Override
    public Expr extractInfo(Formula pT) {
        return CVC4FormulaManager.getCVC4Expr(pT);
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TR> getArrayFormulaElementType(ArrayFormula<TD, TR> pArray) {
        return ((CVC4Formula.CVC4ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TD extends Formula, TR extends Formula> FormulaType<TD> getArrayFormulaIndexType(ArrayFormula<TD, TR> pArray) {
        return ((CVC4Formula.CVC4ArrayFormula)pArray).getIndexType();
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        Type t = this.extractInfo(pFormula).getType();
        if (pFormula instanceof BitvectorFormula) {
            Preconditions.checkArgument((boolean)t.isBitVector(), (String)"BitvectorFormula with actual type %s: %s", (Object)t, pFormula);
            return this.getFormulaType(this.extractInfo(pFormula));
        }
        if (pFormula instanceof FloatingPointFormula) {
            Preconditions.checkArgument((boolean)t.isFloatingPoint(), (String)"FloatingPointFormula with actual type %s: %s", (Object)t, pFormula);
            FloatingPointType fpType = new FloatingPointType(t);
            return FormulaType.getFloatingPointType((int)fpType.getExponentSize(), (int)fpType.getSignificandSize() - 1);
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(Expr pFormula) {
        return this.getFormulaTypeFromTermType(pFormula.getType());
    }

    private FormulaType<?> getFormulaTypeFromTermType(Type t) {
        if (t.isBoolean()) {
            return FormulaType.BooleanType;
        }
        if (t.isInteger()) {
            return FormulaType.IntegerType;
        }
        if (t.isBitVector()) {
            return FormulaType.getBitvectorTypeWithSize((int)new BitVectorType(t).getSize());
        }
        if (t.isFloatingPoint()) {
            FloatingPointType fpType = new FloatingPointType(t);
            return FormulaType.getFloatingPointType((int)fpType.getExponentSize(), (int)fpType.getSignificandSize() - 1);
        }
        if (t.isRoundingMode()) {
            return FormulaType.FloatingPointRoundingModeType;
        }
        if (t.isReal()) {
            return FormulaType.RationalType;
        }
        if (t.isArray()) {
            ArrayType arrayType = new ArrayType(t);
            FormulaType<?> indexType = this.getFormulaTypeFromTermType(arrayType.getIndexType());
            FormulaType<?> elementType = this.getFormulaTypeFromTermType(arrayType.getConstituentType());
            return FormulaType.getArrayType(indexType, elementType);
        }
        if (t.isString()) {
            return FormulaType.StringType;
        }
        if (t.isRegExp()) {
            return FormulaType.RegexType;
        }
        throw new AssertionError((Object)String.format("Unhandled type '%s' with base type '%s'.", t, t.getBaseType()));
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Expr pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Trying to encapsulate formula %s of type %s as %s", pTerm, this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new CVC4Formula.CVC4BooleanFormula(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new CVC4Formula.CVC4IntegerFormula(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new CVC4Formula.CVC4RationalFormula(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new CVC4Formula.CVC4ArrayFormula(pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        if (pType.isBitvectorType()) {
            return (T)new CVC4Formula.CVC4BitvectorFormula(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new CVC4Formula.CVC4FloatingPointFormula(pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)new CVC4Formula.CVC4FloatingPointRoundingModeFormula(pTerm);
        }
        if (pType.isStringType()) {
            return (T)new CVC4Formula.CVC4StringFormula(pTerm);
        }
        if (pType.isRegexType()) {
            return (T)new CVC4Formula.CVC4RegexFormula(pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in CVC4");
    }

    private Formula encapsulate(Expr pTerm) {
        return this.encapsulate(this.getFormulaType(pTerm), pTerm);
    }

    @Override
    public BooleanFormula encapsulateBoolean(Expr pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType()) : String.format("%s is not boolean, but %s (%s)", pTerm, pTerm.getType(), this.getFormulaType(pTerm));
        return new CVC4Formula.CVC4BooleanFormula(pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Expr pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType()) : String.format("%s is no BV, but %s (%s)", pTerm, pTerm.getType(), this.getFormulaType(pTerm));
        return new CVC4Formula.CVC4BitvectorFormula(pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Expr pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType()) : String.format("%s is no FP, but %s (%s)", pTerm, pTerm.getType(), this.getFormulaType(pTerm));
        return new CVC4Formula.CVC4FloatingPointFormula(pTerm);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(Expr pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType))) : String.format("%s is no array, but %s (%s)", pTerm, pTerm.getType(), this.getFormulaType(pTerm));
        return new CVC4Formula.CVC4ArrayFormula<TI, TE>(pTerm, pIndexType, pElementType);
    }

    @Override
    protected StringFormula encapsulateString(Expr pTerm) {
        assert (this.getFormulaType(pTerm).isStringType()) : String.format("%s is no String, but %s (%s)", pTerm, pTerm.getType(), this.getFormulaType(pTerm));
        return new CVC4Formula.CVC4StringFormula(pTerm);
    }

    @Override
    protected RegexFormula encapsulateRegex(Expr pTerm) {
        assert (this.getFormulaType(pTerm).isRegexType());
        return new CVC4Formula.CVC4RegexFormula(pTerm);
    }

    private static String getName(Expr e) {
        Preconditions.checkState((!e.isNull() ? 1 : 0) != 0);
        if (!e.isConst() && !e.isVariable()) {
            e = e.getOperator();
        }
        return CVC4FormulaCreator.dequote(e.toString());
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Expr f) {
        Preconditions.checkState((!f.isNull() ? 1 : 0) != 0);
        Type type = f.getType();
        if (f.isConst()) {
            if (type.isBoolean()) {
                return visitor.visitConstant(formula, f.getConstBoolean());
            }
            if (type.isInteger() || type.isReal()) {
                return visitor.visitConstant(formula, f.getConstRational());
            }
            if (type.isBitVector()) {
                return visitor.visitConstant(formula, f.getConstBitVector().getValue());
            }
            if (type.isFloatingPoint()) {
                return visitor.visitConstant(formula, f.getConstFloatingPoint());
            }
            if (type.isRoundingMode()) {
                return visitor.visitConstant(formula, f.getConstRoundingMode());
            }
            if (type.isString()) {
                return visitor.visitConstant(formula, f.getConstString());
            }
            throw new UnsupportedOperationException("Unhandled constant " + f + " with type " + type);
        }
        if (f.getKind() == Kind.BOUND_VARIABLE) {
            Expr originalVar = this.variablesCache.get(formula.toString());
            return visitor.visitBoundVariable(this.encapsulate(originalVar), 0);
        }
        if (f.getKind() == Kind.FORALL || f.getKind() == Kind.EXISTS) {
            assert (f.getNumChildren() == 2L);
            Expr body = f.getChildren().get(1);
            ArrayList<Formula> freeVars = new ArrayList<Formula>();
            for (Expr boundVar : f.getChild(0L)) {
                String name = CVC4FormulaCreator.getName(boundVar);
                Expr freeVar = (Expr)Preconditions.checkNotNull((Object)this.variablesCache.get(name));
                body = body.substitute(boundVar, freeVar);
                freeVars.add(this.encapsulate(freeVar));
            }
            BooleanFormula fBody = this.encapsulateBoolean(body);
            QuantifiedFormulaManager.Quantifier quant = f.getKind() == Kind.EXISTS ? QuantifiedFormulaManager.Quantifier.EXISTS : QuantifiedFormulaManager.Quantifier.FORALL;
            return visitor.visitQuantifier((BooleanFormula)formula, quant, freeVars, fBody);
        }
        if (f.isVariable()) {
            assert (f.getKind() != Kind.BOUND_VARIABLE);
            return visitor.visitFreeVariable(formula, CVC4FormulaCreator.getName(f));
        }
        ImmutableList args = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)f, this::encapsulate));
        ArrayList argsTypes = new ArrayList();
        Expr operator = this.normalize(f.getOperator());
        if (operator.getType().isFunction()) {
            vectorType argTypes = new FunctionType(operator.getType()).getArgTypes();
            int i = 0;
            while ((long)i < argTypes.size()) {
                argsTypes.add(this.getFormulaTypeFromTermType(argTypes.get(i)));
                ++i;
            }
        } else {
            for (Expr arg : f) {
                argsTypes.add(this.getFormulaType(arg));
            }
        }
        Preconditions.checkState((args.size() == argsTypes.size() ? 1 : 0) != 0);
        return visitor.visitFunction(formula, (List<Formula>)args, FunctionDeclarationImpl.of(CVC4FormulaCreator.getName(f), this.getDeclarationKind(f), argsTypes, this.getFormulaType(f), operator));
    }

    private Expr normalize(Expr operator) {
        Expr function = this.functionsCache.get(CVC4FormulaCreator.getName(operator));
        if (function != null) {
            Preconditions.checkState((boolean)function.getId().equals(operator.getId()), (String)"operator '%s' with ID %s differs from existing function '%s' with ID '%s'.", (Object)operator, (Object)operator.getId(), (Object)function, (Object)function.getId());
            return function;
        }
        return operator;
    }

    private FunctionDeclarationKind getDeclarationKind(Expr f) {
        Kind kind = f.getKind();
        if (kind == Kind.EQUAL && Iterables.all((Iterable)f, child -> child.getType().isBoolean())) {
            return FunctionDeclarationKind.IFF;
        }
        return (FunctionDeclarationKind)((Object)KIND_MAPPING.getOrDefault((Object)kind, (Object)FunctionDeclarationKind.OTHER));
    }

    @Override
    protected Expr getBooleanVarDeclarationImpl(Expr pTFormulaInfo) {
        Kind kind = pTFormulaInfo.getKind();
        assert (kind == Kind.APPLY_UF || kind == Kind.VARIABLE) : pTFormulaInfo.getKind();
        if (kind == Kind.APPLY_UF) {
            return pTFormulaInfo.getOperator();
        }
        return pTFormulaInfo;
    }

    @Override
    public Expr callFunctionImpl(Expr pDeclaration, List<Expr> pArgs) {
        if (pArgs.isEmpty()) {
            return this.exprManager.mkExpr(pDeclaration);
        }
        vectorExpr args = new vectorExpr();
        for (Expr expr : pArgs) {
            args.add(expr);
        }
        return this.exprManager.mkExpr(pDeclaration, args);
    }

    @Override
    public Expr declareUFImpl(String pName, Type pReturnType, List<Type> pArgTypes) {
        Expr exp = this.functionsCache.get(pName);
        if (exp == null) {
            vectorType args = new vectorType();
            for (Type t : pArgTypes) {
                args.add(t);
            }
            exp = this.exprManager.mkVar(pName, (Type)this.exprManager.mkFunctionType(args, pReturnType));
            this.functionsCache.put(pName, exp);
        }
        return exp;
    }

    @Override
    public Object convertValue(Expr expForType, Expr value) {
        Type type = expForType.getType();
        Type valueType = value.getType();
        if (value.getKind() == Kind.BOUND_VARIABLE) {
            return value.toString();
        }
        if (valueType.isBoolean()) {
            return value.getConstBoolean();
        }
        if (valueType.isInteger() && type.isInteger()) {
            return new BigInteger(value.getConstRational().toString());
        }
        if (valueType.isReal() && type.isReal()) {
            edu.stanford.CVC4.Rational rat = value.getConstRational();
            return Rational.of((BigInteger)new BigInteger(rat.getNumerator().toString()), (BigInteger)new BigInteger(rat.getDenominator().toString()));
        }
        if (valueType.isBitVector()) {
            Integer bv = value.getConstBitVector().getValue();
            if (bv.fitsSignedLong()) {
                return BigInteger.valueOf(bv.getUnsignedLong());
            }
            return value.toString();
        }
        if (valueType.isFloatingPoint()) {
            return this.parseFloatingPoint(value);
        }
        if (valueType.isString()) {
            return value.getConstString().toString();
        }
        return value.toString();
    }

    private Object parseFloatingPoint(Expr fpExpr) {
        Matcher matcher = FLOATING_POINT_PATTERN.matcher(fpExpr.toString());
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown floating-point format: " + fpExpr);
        }
        FloatingPoint fp = fpExpr.getConstFloatingPoint();
        FloatingPointSize fpType = fp.getT();
        long expWidth = fpType.exponentWidth();
        long mantWidth = fpType.significandWidth() - 1L;
        assert (matcher.group("sign").length() == 1);
        assert ((long)matcher.group("exp").length() == expWidth);
        assert ((long)matcher.group("mant").length() == mantWidth);
        String str = matcher.group("sign") + matcher.group("exp") + matcher.group("mant");
        if (expWidth == 11L && mantWidth == 52L) {
            return Double.longBitsToDouble(UnsignedLong.valueOf((String)str, (int)2).longValue());
        }
        if (expWidth == 8L && mantWidth == 23L) {
            return Float.valueOf(Float.intBitsToFloat(UnsignedInteger.valueOf((String)str, (int)2).intValue()));
        }
        return fpExpr.toString();
    }
}

