/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;

public class FormulaClassifier {
    private final FormulaManager mgr;
    private final SolverContext context;
    private final Classifier v = new Classifier();
    private int levelLinearArithmetic = 0;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException, IOException {
        if (args.length == 0) {
            FormulaClassifier.help();
        }
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.MATHSAT5;
        Path path = null;
        for (String arg : args) {
            if (arg.startsWith("-solver=")) {
                solver = SolverContextFactory.Solvers.valueOf(arg.substring(8));
                continue;
            }
            if (path == null) {
                path = Path.of(arg, new String[0]);
                continue;
            }
            FormulaClassifier.help();
        }
        if (path == null) {
            FormulaClassifier.help();
        }
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
            ArrayList<BooleanFormula> formulas = new ArrayList<BooleanFormula>();
            ArrayList<String> definitions = new ArrayList<String>();
            for (String line : Files.readAllLines(path)) {
                if (Iterables.any((Iterable)ImmutableList.of((Object)";", (Object)"(push ", (Object)"(pop ", (Object)"(reset", (Object)"(set-logic"), line::startsWith)) continue;
                if (line.startsWith("(assert ")) {
                    BooleanFormula bf = context.getFormulaManager().parse(Joiner.on((String)"").join(definitions) + line);
                    formulas.add(bf);
                    continue;
                }
                definitions.add(line);
            }
            FormulaClassifier fc = new FormulaClassifier(context);
            formulas.forEach(fc::visit);
            System.out.println(fc + ", checked formulas: " + formulas.size());
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private static void help() {
        throw new AssertionError((Object)"run $> TOOL [-solver=SOLVER] PATH");
    }

    public FormulaClassifier(SolverContext pContext) {
        this.context = pContext;
        this.mgr = this.context.getFormulaManager();
    }

    public void visit(BooleanFormula f) {
        AtomCollector atomCollector = new AtomCollector();
        this.mgr.getBooleanFormulaManager().visitRecursively(f, atomCollector);
        if (atomCollector.hasQuantifiers) {
            this.v.hasQuantifiers = true;
        }
        for (BooleanFormula part : atomCollector.atoms) {
            int levelLA = this.mgr.visit(part, this.v);
            this.levelLinearArithmetic = Math.max(levelLA, this.levelLinearArithmetic);
        }
    }

    public String toString() {
        StringBuilder logic = new StringBuilder();
        if (!this.v.hasQuantifiers) {
            logic.append("QF_");
        }
        if (this.v.hasArrays) {
            logic.append("A");
        }
        if (this.v.hasUFs) {
            logic.append("UF");
        }
        if (this.v.hasBVs) {
            logic.append("BV");
        }
        if (this.v.nonLinearArithmetic || this.v.linearArithmetic) {
            if (this.v.hasInts && this.v.hasReals) {
                if (this.v.nonLinearArithmetic) {
                    logic.append("N");
                } else if (this.v.linearArithmetic) {
                    logic.append("L");
                }
                logic.append("IRA");
            } else if (this.v.hasInts) {
                if (this.v.nonLinearArithmetic) {
                    logic.append("N");
                } else if (this.v.linearArithmetic) {
                    logic.append("L");
                }
                logic.append("IA");
            } else if (this.v.hasReals) {
                if (this.v.nonLinearArithmetic) {
                    logic.append("N");
                } else if (this.v.linearArithmetic) {
                    logic.append("L");
                }
                logic.append("RA");
            }
        }
        if (this.v.hasFloats) {
            logic.append("FP");
        }
        return logic.toString();
    }

    private class Classifier
    implements FormulaVisitor<Integer> {
        boolean hasUFs = false;
        boolean hasQuantifiers = false;
        boolean hasFloats = false;
        boolean hasInts = false;
        boolean hasReals = false;
        boolean hasBVs = false;
        boolean hasArrays = false;
        boolean linearArithmetic = false;
        boolean nonLinearArithmetic = false;

        private Classifier() {
        }

        void checkType(Formula f) {
            FormulaType<Formula> type = FormulaClassifier.this.mgr.getFormulaType(f);
            if (type.isIntegerType()) {
                this.hasInts = true;
            }
            if (type.isRationalType()) {
                this.hasReals = true;
            }
            if (type.isFloatingPointType()) {
                this.hasFloats = true;
            }
            if (type.isBitvectorType()) {
                this.hasBVs = true;
            }
            if (type.isArrayType()) {
                this.hasArrays = true;
            }
        }

        @Override
        public Integer visitFreeVariable(Formula pF, String pName) {
            this.checkType(pF);
            return 1;
        }

        @Override
        public Integer visitBoundVariable(Formula pF, int pDeBruijnIdx) {
            this.checkType(pF);
            return 1;
        }

        @Override
        public Integer visitConstant(Formula pF, Object pValue) {
            this.checkType(pF);
            return 0;
        }

        @Override
        public Integer visitFunction(Formula pF, List<Formula> args, FunctionDeclaration<?> pFunctionDeclaration) {
            if (pFunctionDeclaration.getKind() == FunctionDeclarationKind.UF) {
                this.hasUFs = true;
            }
            this.checkType(pF);
            int numNonConstantArgs = 0;
            int allArgLevel = 0;
            for (Formula arg : args) {
                int argLevel = FormulaClassifier.this.mgr.visit(arg, this);
                if (argLevel >= 1) {
                    ++numNonConstantArgs;
                }
                allArgLevel = Math.max(allArgLevel, argLevel);
            }
            switch (pFunctionDeclaration.getKind()) {
                case MUL: 
                case BV_MUL: 
                case DIV: 
                case BV_UDIV: 
                case BV_SDIV: 
                case MODULO: 
                case BV_UREM: 
                case BV_SREM: {
                    if (numNonConstantArgs < 2) break;
                    this.nonLinearArithmetic = true;
                    return allArgLevel + 1;
                }
            }
            if (pFunctionDeclaration.getType().isBooleanType()) {
                if (EnumSet.of(FunctionDeclarationKind.LT, FunctionDeclarationKind.LTE, FunctionDeclarationKind.GT, FunctionDeclarationKind.GTE).contains((Object)pFunctionDeclaration.getKind())) {
                    for (Formula arg : args) {
                        FormulaType<Formula> type = FormulaClassifier.this.mgr.getFormulaType(arg);
                        if (!type.isIntegerType() && !type.isRationalType()) continue;
                        this.linearArithmetic = true;
                    }
                }
                return 0;
            }
            if (pFunctionDeclaration.getKind() != FunctionDeclarationKind.UF) {
                this.linearArithmetic = true;
            }
            return allArgLevel;
        }

        @Override
        public Integer visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> pBoundVariables, BooleanFormula pBody) {
            this.hasQuantifiers = true;
            this.checkType(pF);
            return FormulaClassifier.this.mgr.visit(pBody, this);
        }
    }

    private static class AtomCollector
    extends DefaultBooleanFormulaVisitor<TraversalProcess> {
        private final Collection<BooleanFormula> atoms = new LinkedHashSet<BooleanFormula>();
        boolean hasQuantifiers = false;

        private AtomCollector() {
        }

        @Override
        protected TraversalProcess visitDefault() {
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> funcDecl) {
            this.atoms.add(atom);
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, BooleanFormula quantifiedAST, List<Formula> boundVars, BooleanFormula body) {
            this.hasQuantifiers = true;
            return this.visitDefault();
        }
    }
}

