/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.StringFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractStringFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements StringFormulaManager {
    protected AbstractStringFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pCreator) {
        super(pCreator);
    }

    private StringFormula wrapString(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateString(formulaInfo);
    }

    private RegexFormula wrapRegex(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateRegex(formulaInfo);
    }

    @Override
    public StringFormula makeString(String value) {
        return this.wrapString(this.makeStringImpl(value));
    }

    protected abstract TFormulaInfo makeStringImpl(String var1);

    @Override
    public StringFormula makeVariable(String pVar) {
        AbstractFormulaManager.checkVariableName(pVar);
        return this.wrapString(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public BooleanFormula equal(StringFormula str1, StringFormula str2) {
        return this.wrapBool(this.equal(this.extractInfo(str1), this.extractInfo(str2)));
    }

    protected abstract TFormulaInfo equal(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterThan(StringFormula str1, StringFormula str2) {
        return this.wrapBool(this.greaterThan(this.extractInfo(str1), this.extractInfo(str2)));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterOrEquals(StringFormula str1, StringFormula str2) {
        return this.wrapBool(this.greaterOrEquals(this.extractInfo(str1), this.extractInfo(str2)));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessThan(StringFormula str1, StringFormula str2) {
        return this.wrapBool(this.lessThan(this.extractInfo(str1), this.extractInfo(str2)));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessOrEquals(StringFormula str1, StringFormula str2) {
        return this.wrapBool(this.lessOrEquals(this.extractInfo(str1), this.extractInfo(str2)));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public NumeralFormula.IntegerFormula length(StringFormula str) {
        return this.getFormulaCreator().encapsulate(FormulaType.IntegerType, this.length(this.extractInfo(str)));
    }

    protected abstract TFormulaInfo length(TFormulaInfo var1);

    @Override
    public StringFormula concat(List<StringFormula> parts) {
        switch (parts.size()) {
            case 0: {
                return this.makeString("");
            }
            case 1: {
                return (StringFormula)Iterables.getOnlyElement(parts);
            }
        }
        return this.wrapString(this.concatImpl(Lists.transform(parts, this::extractInfo)));
    }

    protected abstract TFormulaInfo concatImpl(List<TFormulaInfo> var1);

    @Override
    public BooleanFormula prefix(StringFormula prefix, StringFormula str) {
        return this.wrapBool(this.prefix(this.extractInfo(prefix), this.extractInfo(str)));
    }

    protected abstract TFormulaInfo prefix(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula suffix(StringFormula suffix, StringFormula str) {
        return this.wrapBool(this.suffix(this.extractInfo(suffix), this.extractInfo(str)));
    }

    protected abstract TFormulaInfo suffix(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula in(StringFormula str, RegexFormula regex) {
        return this.wrapBool(this.in(this.extractInfo(str), this.extractInfo(regex)));
    }

    protected abstract TFormulaInfo in(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula contains(StringFormula str, StringFormula part) {
        return this.wrapBool(this.contains(this.extractInfo(str), this.extractInfo(part)));
    }

    protected abstract TFormulaInfo contains(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public NumeralFormula.IntegerFormula indexOf(StringFormula str, StringFormula part, NumeralFormula.IntegerFormula startIndex) {
        return this.getFormulaCreator().encapsulate(FormulaType.IntegerType, this.indexOf(this.extractInfo(str), this.extractInfo(part), this.extractInfo(startIndex)));
    }

    protected abstract TFormulaInfo indexOf(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public StringFormula charAt(StringFormula str, NumeralFormula.IntegerFormula index) {
        return this.wrapString(this.charAt(this.extractInfo(str), this.extractInfo(index)));
    }

    protected abstract TFormulaInfo charAt(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public StringFormula substring(StringFormula str, NumeralFormula.IntegerFormula index, NumeralFormula.IntegerFormula length) {
        return this.wrapString(this.substring(this.extractInfo(str), this.extractInfo(index), this.extractInfo(length)));
    }

    protected abstract TFormulaInfo substring(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public StringFormula replace(StringFormula fullStr, StringFormula target, StringFormula replacement) {
        return this.wrapString(this.replace(this.extractInfo(fullStr), this.extractInfo(target), this.extractInfo(replacement)));
    }

    protected abstract TFormulaInfo replace(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public StringFormula replaceAll(StringFormula fullStr, StringFormula target, StringFormula replacement) {
        return this.wrapString(this.replaceAll(this.extractInfo(fullStr), this.extractInfo(target), this.extractInfo(replacement)));
    }

    protected abstract TFormulaInfo replaceAll(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public RegexFormula makeRegex(String value) {
        return this.wrapRegex(this.makeRegexImpl(value));
    }

    protected abstract TFormulaInfo makeRegexImpl(String var1);

    @Override
    public RegexFormula none() {
        return this.wrapRegex(this.noneImpl());
    }

    protected abstract TFormulaInfo noneImpl();

    @Override
    public RegexFormula all() {
        return this.wrapRegex(this.allImpl());
    }

    protected abstract TFormulaInfo allImpl();

    @Override
    public RegexFormula allChar() {
        return this.wrapRegex(this.allCharImpl());
    }

    protected abstract TFormulaInfo allCharImpl();

    @Override
    public RegexFormula range(StringFormula start, StringFormula end) {
        return this.wrapRegex(this.range(this.extractInfo(start), this.extractInfo(end)));
    }

    protected abstract TFormulaInfo range(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public RegexFormula concatRegex(List<RegexFormula> parts) {
        switch (parts.size()) {
            case 0: {
                return this.none();
            }
            case 1: {
                return (RegexFormula)Iterables.getOnlyElement(parts);
            }
        }
        return this.wrapRegex(this.concatRegexImpl(Lists.transform(parts, this::extractInfo)));
    }

    protected abstract TFormulaInfo concatRegexImpl(List<TFormulaInfo> var1);

    @Override
    public RegexFormula union(RegexFormula regex1, RegexFormula regex2) {
        return this.wrapRegex(this.union(this.extractInfo(regex1), this.extractInfo(regex2)));
    }

    protected abstract TFormulaInfo union(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public RegexFormula intersection(RegexFormula regex1, RegexFormula regex2) {
        return this.wrapRegex(this.union(this.extractInfo(regex1), this.extractInfo(regex2)));
    }

    protected abstract TFormulaInfo intersection(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public RegexFormula closure(RegexFormula regex) {
        return this.wrapRegex(this.closure(this.extractInfo(regex)));
    }

    protected abstract TFormulaInfo closure(TFormulaInfo var1);

    @Override
    public RegexFormula complement(RegexFormula regex) {
        return this.wrapRegex(this.complement(this.extractInfo(regex)));
    }

    protected abstract TFormulaInfo complement(TFormulaInfo var1);

    @Override
    public RegexFormula difference(RegexFormula regex1, RegexFormula regex2) {
        return this.wrapRegex(this.difference(this.extractInfo(regex1), this.extractInfo(regex2)));
    }

    protected TFormulaInfo difference(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        return this.union(pParam1, this.complement(pParam2));
    }

    @Override
    public RegexFormula cross(RegexFormula regex) {
        return this.concat(regex, this.closure(regex));
    }

    @Override
    public RegexFormula optional(RegexFormula regex) {
        return this.union(regex, this.makeRegex(""));
    }

    @Override
    public RegexFormula times(RegexFormula regex, int repetitions) {
        return this.concatRegex(Collections.nCopies(repetitions, regex));
    }

    @Override
    public NumeralFormula.IntegerFormula toIntegerFormula(StringFormula str) {
        return this.getFormulaCreator().encapsulate(FormulaType.IntegerType, this.toIntegerFormula(this.extractInfo(str)));
    }

    protected abstract TFormulaInfo toIntegerFormula(TFormulaInfo var1);

    @Override
    public StringFormula toStringFormula(NumeralFormula.IntegerFormula number) {
        return this.wrapString(this.toStringFormula(this.extractInfo(number)));
    }

    protected abstract TFormulaInfo toStringFormula(TFormulaInfo var1);
}

