/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_lbool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3Model;
import org.sosy_lab.java_smt.solvers.z3.Z3SolverException;

abstract class Z3AbstractProver<T>
extends AbstractProverWithAllSat<T> {
    protected final Z3FormulaCreator creator;
    protected final long z3context;
    private final Z3FormulaManager mgr;
    protected final long z3solver;
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    private final @Nullable Map<String, BooleanFormula> storedConstraints;
    private final @Nullable PathCounterTemplate logfile;
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;

    Z3AbstractProver(Z3FormulaCreator pCreator, Z3FormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions, ImmutableMap<String, Object> pSolverOptions, @Nullable PathCounterTemplate pLogfile, ShutdownNotifier pShutdownNotifier) {
        super(pOptions, pMgr.getBooleanFormulaManager(), pShutdownNotifier);
        this.creator = pCreator;
        this.z3context = (Long)this.creator.getEnv();
        this.z3solver = Native.mkSolver((long)this.z3context);
        this.interruptListener = reason -> Native.solverInterrupt((long)this.z3context, (long)this.z3solver);
        this.shutdownNotifier.register(this.interruptListener);
        this.storedConstraints = pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) ? new HashMap() : null;
        this.logfile = pLogfile;
        this.mgr = pMgr;
        Native.solverIncRef((long)this.z3context, (long)this.z3solver);
        long z3params = Native.mkParams((long)this.z3context);
        Native.paramsIncRef((long)this.z3context, (long)z3params);
        for (Map.Entry entry : pSolverOptions.entrySet()) {
            this.addParameter(z3params, (String)entry.getKey(), entry.getValue());
        }
        Native.solverSetParams((long)this.z3context, (long)this.z3solver, (long)z3params);
        Native.paramsDecRef((long)this.z3context, (long)z3params);
    }

    void addParameter(long z3params, String key, Object value) {
        long keySymbol = Native.mkStringSymbol((long)this.z3context, (String)key);
        if (value instanceof Boolean) {
            Native.paramsSetBool((long)this.z3context, (long)z3params, (long)keySymbol, (boolean)((Boolean)value));
        } else if (value instanceof Integer) {
            Native.paramsSetUint((long)this.z3context, (long)z3params, (long)keySymbol, (int)((Integer)value));
        } else if (value instanceof Double) {
            Native.paramsSetDouble((long)this.z3context, (long)z3params, (long)keySymbol, (double)((Double)value));
        } else if (value instanceof String) {
            long valueSymbol = Native.mkStringSymbol((long)this.z3context, (String)((String)value));
            Native.paramsSetSymbol((long)this.z3context, (long)z3params, (long)keySymbol, (long)valueSymbol);
        } else {
            throw new IllegalArgumentException(String.format("unexpected type '%s' with value '%s' for parameter '%s'", value.getClass(), value, key));
        }
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.logSolverStack();
        try {
            result = Native.solverCheck((long)this.z3context, (long)this.z3solver);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    private void logSolverStack() throws Z3SolverException {
        if (this.logfile != null) {
            try {
                Path filename = this.logfile.getFreshPath();
                MoreFiles.createParentDirectories((Path)filename, (FileAttribute[])new FileAttribute[0]);
                Files.writeString(filename, (CharSequence)(Native.solverToString((long)this.z3context, (long)this.z3solver) + "(check-sat)\n"), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new Z3SolverException("Cannot write Z3 log file: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> assumptions) throws Z3SolverException, InterruptedException {
        int result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        try {
            result = Native.solverCheckAssumptions((long)this.z3context, (long)this.z3solver, (int)assumptions.size(), (long[])assumptions.stream().mapToLong(this.creator::extractInfo).toArray());
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
        this.undefinedStatusToException(result);
        return result == Z3_lbool.Z3_L_FALSE.toInt();
    }

    protected final void undefinedStatusToException(int solverStatus) throws Z3SolverException, InterruptedException {
        if (solverStatus == Z3_lbool.Z3_L_UNDEF.toInt()) {
            this.creator.shutdownNotifier.shutdownIfNecessary();
            throw new Z3SolverException("Solver returned 'unknown' status, reason: " + Native.solverGetReasonUnknown((long)this.z3context, (long)this.z3solver));
        }
    }

    @Override
    public Z3Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getModelWithoutChecks();
    }

    @Override
    protected Z3Model getModelWithoutChecks() {
        return Z3Model.create(this.z3context, this.getZ3Model(), this.creator);
    }

    protected long getZ3Model() {
        return Native.solverGetModel((long)this.z3context, (long)this.z3solver);
    }

    @CanIgnoreReturnValue
    protected long addConstraint0(BooleanFormula f) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = this.creator.extractInfo(f);
        Native.incRef((long)this.z3context, (long)e);
        try {
            if (this.storedConstraints != null) {
                String varName = String.format("Z3_UNSAT_CORE_%d", this.trackId.getFreshId());
                BooleanFormula t = ((AbstractBooleanFormulaManager)this.mgr.getBooleanFormulaManager()).makeVariable(varName);
                Native.solverAssertAndTrack((long)this.z3context, (long)this.z3solver, (long)e, (long)this.creator.extractInfo(t));
                this.storedConstraints.put(varName, f);
                Native.decRef((long)this.z3context, (long)e);
            } else {
                this.assertContraint(e);
            }
        }
        catch (Z3Exception exception) {
            throw this.creator.handleZ3Exception(exception);
        }
        Native.decRef((long)this.z3context, (long)e);
        return e;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Native.solverPush((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 1 ? 1 : 0) != 0);
        Native.solverPop((long)this.z3context, (long)this.z3solver, (int)1);
    }

    @Override
    public int size() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            Native.incRef((long)this.z3context, (long)ast);
            String varName = Native.astToString((long)this.z3context, (long)ast);
            Native.decRef((long)this.z3context, (long)ast);
            constraints.add(this.storedConstraints.get(varName));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return constraints;
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        this.checkGenerateUnsatCoresOverAssumptions();
        if (!this.isUnsatWithAssumptions(assumptions)) {
            return Optional.empty();
        }
        ArrayList<BooleanFormula> core = new ArrayList<BooleanFormula>();
        long unsatCore = Native.solverGetUnsatCore((long)this.z3context, (long)this.z3solver);
        Native.astVectorIncRef((long)this.z3context, (long)unsatCore);
        for (int i = 0; i < Native.astVectorSize((long)this.z3context, (long)unsatCore); ++i) {
            long ast = Native.astVectorGet((long)this.z3context, (long)unsatCore, (int)i);
            core.add(this.creator.encapsulateBoolean(ast));
        }
        Native.astVectorDecRef((long)this.z3context, (long)unsatCore);
        return Optional.of(core);
    }

    @Override
    public ImmutableMap<String, String> getStatistics() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        long stats = Native.solverGetStatistics((long)this.z3context, (long)this.z3solver);
        for (int i = 0; i < Native.statsSize((long)this.z3context, (long)stats); ++i) {
            String key = Native.statsGetKey((long)this.z3context, (long)stats, (int)i);
            if (Native.statsIsUint((long)this.z3context, (long)stats, (int)i)) {
                builder.put((Object)key, (Object)Integer.toString(Native.statsGetUintValue((long)this.z3context, (long)stats, (int)i)));
                continue;
            }
            if (Native.statsIsDouble((long)this.z3context, (long)stats, (int)i)) {
                builder.put((Object)key, (Object)Double.toString(Native.statsGetDoubleValue((long)this.z3context, (long)stats, (int)i)));
                continue;
            }
            throw new IllegalStateException(String.format("Unknown data entry value for key %s at position %d in statistics '%s'", key, i, Native.statsToString((long)this.z3context, (long)stats)));
        }
        return builder.buildOrThrow();
    }

    @Override
    public void close() {
        if (!this.closed) {
            Preconditions.checkArgument((Native.solverGetNumScopes((long)this.z3context, (long)this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
            Native.solverReset((long)this.z3context, (long)this.z3solver);
            Native.solverDecRef((long)this.z3context, (long)this.z3solver);
            this.shutdownNotifier.unregister(this.interruptListener);
            this.closed = true;
        }
    }

    public String toString() {
        if (this.closed) {
            return "Closed Z3Solver";
        }
        return Native.solverToString((long)this.z3context, (long)this.z3solver);
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        try {
            return super.allSat(callback, important);
        }
        catch (Z3Exception e) {
            throw this.creator.handleZ3Exception(e);
        }
    }

    protected void assertContraint(long negatedModel) {
        Native.solverAssert((long)this.z3context, (long)this.z3solver, (long)negatedModel);
    }
}

