/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorQuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorTheoremProver;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorUFManager;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;
import org.sosy_lab.java_smt.solvers.boolector.BtorOption;

public final class BoolectorSolverContext
extends AbstractSolverContext {
    private final BoolectorFormulaManager manager;
    private final BoolectorFormulaCreator creator;
    private final ShutdownNotifier shutdownNotifier;
    private boolean closed = false;
    private final AtomicBoolean isAnyStackAlive = new AtomicBoolean(false);

    BoolectorSolverContext(BoolectorFormulaManager pManager, BoolectorFormulaCreator pCreator, ShutdownNotifier pShutdownNotifier) {
        super(pManager);
        this.manager = pManager;
        this.creator = pCreator;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public static BoolectorSolverContext create(Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed, Consumer<String> pLoader) throws InvalidConfigurationException {
        pLoader.accept("boolector");
        long btor = BtorJNI.boolector_new();
        BoolectorSolverContext.setOptions(config, solverLogfile, randomSeed, btor);
        BoolectorFormulaCreator creator = new BoolectorFormulaCreator(btor);
        BoolectorUFManager functionTheory = new BoolectorUFManager(creator);
        BoolectorBooleanFormulaManager booleanTheory = new BoolectorBooleanFormulaManager(creator);
        BoolectorBitvectorFormulaManager bitvectorTheory = new BoolectorBitvectorFormulaManager(creator, booleanTheory);
        BoolectorQuantifiedFormulaManager quantifierTheory = new BoolectorQuantifiedFormulaManager(creator);
        BoolectorArrayFormulaManager arrayTheory = new BoolectorArrayFormulaManager(creator);
        BoolectorFormulaManager manager = new BoolectorFormulaManager(creator, functionTheory, booleanTheory, bitvectorTheory, quantifierTheory, arrayTheory);
        return new BoolectorSolverContext(manager, creator, pShutdownNotifier);
    }

    @Override
    public String getVersion() {
        return "Boolector " + BtorJNI.boolector_version((Long)this.creator.getEnv());
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.BOOLECTOR;
    }

    @Override
    public ImmutableMap<String, String> getStatistics() {
        long env = (Long)this.creator.getEnv();
        BtorJNI.boolector_set_opt(env, BtorOption.BTOR_OPT_VERBOSITY.getValue(), 3L);
        String stats = BtorJNI.boolector_print_stats_helper(env);
        BtorJNI.boolector_set_opt(env, BtorOption.BTOR_OPT_VERBOSITY.getValue(), 0L);
        return ImmutableMap.of((Object)"statistics", (Object)stats);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            BtorJNI.boolector_delete((Long)this.creator.getEnv());
        }
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> pOptions) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"solver context is already closed");
        return new BoolectorTheoremProver(this.manager, this.creator, (Long)this.creator.getEnv(), this.shutdownNotifier, pOptions, this.isAnyStackAlive);
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("Boolector does not support interpolation");
    }

    @Override
    protected OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("Boolector does not support optimization");
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return true;
    }

    private static void setOptions(Configuration config, PathCounterTemplate solverLogfile, long randomSeed, long btor) throws InvalidConfigurationException {
        BoolectorSettings settings = new BoolectorSettings(config);
        Preconditions.checkNotNull((Object)((Object)settings.satSolver));
        BtorJNI.boolector_set_sat_solver(btor, settings.satSolver.name().toLowerCase());
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_MODEL_GEN.getValue(), 2L);
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_AUTO_CLEANUP.getValue(), 1L);
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_INCREMENTAL.getValue(), 1L);
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_SEED.getValue(), randomSeed);
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_OUTPUT_FORMAT.getValue(), 2L);
        BtorJNI.boolector_set_opt(btor, BtorOption.BTOR_OPT_REWRITE_LEVEL.getValue(), 0L);
        BoolectorSolverContext.setFurtherOptions(btor, settings.furtherOptions);
        if (solverLogfile != null) {
            String filename = solverLogfile.getFreshPath().toAbsolutePath().toString();
            BtorJNI.boolector_set_trapi(btor, filename);
        }
    }

    private static void setFurtherOptions(long btor, String pFurtherOptions) throws InvalidConfigurationException {
        ImmutableMap furtherOptionsMap;
        Splitter.MapSplitter optionSplitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator(Splitter.on((char)'=').limit(2).trimResults());
        try {
            furtherOptionsMap = ImmutableMap.copyOf((Map)optionSplitter.split((CharSequence)pFurtherOptions));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("Invalid Boolector option in \"" + pFurtherOptions + "\": " + e.getMessage(), (Throwable)e);
        }
        for (Map.Entry option : furtherOptionsMap.entrySet()) {
            try {
                BtorOption btorOption = BtorOption.valueOf((String)option.getKey());
                long optionValue = Long.parseLong((String)option.getValue());
                BtorJNI.boolector_set_opt(btor, btorOption.getValue(), optionValue);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Options(prefix="solver.boolector")
    private static class BoolectorSettings {
        @Option(secure=true, description="The SAT solver used by Boolector.")
        private SatSolver satSolver = SatSolver.CADICAL;
        @Option(secure=true, description="Further options for Boolector in addition to the default options. Format:  \"Optionname=value\" with \u2019,\u2019 to seperate options. Optionname and value can be found in BtorOption or Boolector C Api.Example: \"BTOR_OPT_MODEL_GEN=2,BTOR_OPT_INCREMENTAL=1\".")
        private String furtherOptions = "";

        BoolectorSettings(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }
    }

    static enum SatSolver {
        LINGELING,
        PICOSAT,
        MINISAT,
        CMS,
        CADICAL;

    }
}

