/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RegexFormula;
import org.sosy_lab.java_smt.api.StringFormula;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.basicimpl.AbstractFormula;
import org.sosy_lab.java_smt.basicimpl.FormulaTransformationVisitorImpl;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.basicimpl.RecursiveFormulaVisitorImpl;

public abstract class FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> {
    private final TType boolType;
    private final @Nullable TType integerType;
    private final @Nullable TType rationalType;
    private final @Nullable TType stringType;
    private final @Nullable TType regexType;
    protected final TEnv environment;

    protected FormulaCreator(TEnv env, TType boolType, @Nullable TType pIntegerType, @Nullable TType pRationalType, @Nullable TType stringType, @Nullable TType regexType) {
        this.environment = env;
        this.boolType = boolType;
        this.integerType = pIntegerType;
        this.rationalType = pRationalType;
        this.stringType = stringType;
        this.regexType = regexType;
    }

    public final TEnv getEnv() {
        return this.environment;
    }

    public final TType getBoolType() {
        return this.boolType;
    }

    public final TType getIntegerType() {
        if (this.integerType == null) {
            throw new UnsupportedOperationException("Integer theory is not supported by this solver.");
        }
        return this.integerType;
    }

    public final TType getRationalType() {
        if (this.rationalType == null) {
            throw new UnsupportedOperationException("Rational theory is not supported by this solver.");
        }
        return this.rationalType;
    }

    public abstract TType getBitvectorType(int var1);

    public abstract TType getFloatingPointType(FormulaType.FloatingPointType var1);

    public abstract TType getArrayType(TType var1, TType var2);

    public final TType getStringType() {
        if (this.stringType == null) {
            throw new UnsupportedOperationException("String theory is not supported by this solver.");
        }
        return this.stringType;
    }

    public final TType getRegexType() {
        if (this.regexType == null) {
            throw new UnsupportedOperationException("String theory is not supported by this solver.");
        }
        return this.regexType;
    }

    public abstract TFormulaInfo makeVariable(TType var1, String var2);

    public BooleanFormula encapsulateBoolean(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        return new AbstractFormula.BooleanFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected BitvectorFormula encapsulateBitvector(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        return new AbstractFormula.BitvectorFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected FloatingPointFormula encapsulateFloatingPoint(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType());
        return new AbstractFormula.FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(TFormulaInfo pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType))) : "Expected: " + this.getFormulaType(pTerm) + " but found: " + FormulaType.getArrayType(pIndexType, pElementType);
        return new AbstractFormula.ArrayFormulaImpl<TI, TE, TFormulaInfo>(pTerm, pIndexType, pElementType);
    }

    protected StringFormula encapsulateString(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isStringType());
        return new AbstractFormula.StringFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected RegexFormula encapsulateRegex(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isRegexType());
        return new AbstractFormula.RegexFormulaImpl<TFormulaInfo>(pTerm);
    }

    public Formula encapsulateWithTypeOf(TFormulaInfo pTerm) {
        return this.encapsulate(this.getFormulaType(pTerm), pTerm);
    }

    public <T extends Formula> T encapsulate(FormulaType<T> pType, TFormulaInfo pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm))) : String.format("Trying to encapsulate formula %s of type %s as %s", pTerm, this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new AbstractFormula.BooleanFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new AbstractFormula.IntegerFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new AbstractFormula.RationalFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isStringType()) {
            return (T)new AbstractFormula.StringFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isRegexType()) {
            return (T)new AbstractFormula.RegexFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)new AbstractFormula.BitvectorFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new AbstractFormula.FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)new AbstractFormula.FloatingPointRoundingModeFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)pType;
            return (T)this.encapsulateArray(pTerm, arrayType.getIndexType(), arrayType.getElementType());
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in the Solver!");
    }

    protected TFormulaInfo extractInfo(Formula pT) {
        if (pT instanceof AbstractFormula) {
            return ((AbstractFormula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((AbstractFormula.ArrayFormulaImpl)pArray).getElementType();
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((AbstractFormula.ArrayFormulaImpl)pArray).getIndexType();
    }

    protected <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        FormulaType<Formula> t;
        Preconditions.checkNotNull(formula);
        if (formula instanceof BooleanFormula) {
            t = FormulaType.BooleanType;
        } else if (formula instanceof NumeralFormula.IntegerFormula) {
            t = FormulaType.IntegerType;
        } else if (formula instanceof NumeralFormula.RationalFormula) {
            t = FormulaType.RationalType;
        } else if (formula instanceof StringFormula) {
            t = FormulaType.StringType;
        } else if (formula instanceof RegexFormula) {
            t = FormulaType.RegexType;
        } else if (formula instanceof FloatingPointRoundingModeFormula) {
            t = FormulaType.FloatingPointRoundingModeType;
        } else {
            if (formula instanceof ArrayFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for arrays need to overwrite FormulaCreator.getFormulaType()");
            }
            if (formula instanceof BitvectorFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for bitvectors need to overwrite FormulaCreator.getFormulaType()");
            }
            throw new IllegalArgumentException("Formula with unexpected type " + formula.getClass());
        }
        return t;
    }

    public abstract FormulaType<?> getFormulaType(TFormulaInfo var1);

    @CanIgnoreReturnValue
    public <R> R visit(Formula input, FormulaVisitor<R> visitor) {
        return this.visit(visitor, input, this.extractInfo(input));
    }

    public abstract <R> R visit(FormulaVisitor<R> var1, Formula var2, TFormulaInfo var3);

    protected List<TFormulaInfo> extractInfo(List<? extends Formula> input) {
        return Lists.transform(input, this::extractInfo);
    }

    public void visitRecursively(FormulaVisitor<TraversalProcess> pFormulaVisitor, Formula pF) {
        this.visitRecursively(pFormulaVisitor, pF, t -> true);
    }

    public void visitRecursively(FormulaVisitor<TraversalProcess> pFormulaVisitor, Formula pF, Predicate<Formula> shouldProcess) {
        RecursiveFormulaVisitorImpl recVisitor = new RecursiveFormulaVisitorImpl(pFormulaVisitor);
        recVisitor.addToQueue(pF);
        while (!recVisitor.isQueueEmpty()) {
            TraversalProcess process;
            Formula tt = recVisitor.pop();
            if (!shouldProcess.test(tt) || (process = this.visit(tt, recVisitor)) != TraversalProcess.ABORT) continue;
            return;
        }
    }

    public <T extends Formula> T transformRecursively(FormulaVisitor<? extends Formula> pFormulaVisitor, T pF) {
        return this.transformRecursively(pFormulaVisitor, pF, t -> true);
    }

    public <T extends Formula> T transformRecursively(FormulaVisitor<? extends Formula> pFormulaVisitor, T pF, Predicate<Object> shouldProcess) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashMap<Formula, Formula> pCache = new HashMap<Formula, Formula>();
        FormulaTransformationVisitorImpl recVisitor = new FormulaTransformationVisitorImpl(pFormulaVisitor, toProcess, pCache);
        toProcess.push(pF);
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.peek();
            if (pCache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            if (shouldProcess.test(tt)) {
                this.visit(tt, recVisitor);
                continue;
            }
            pCache.put(tt, tt);
        }
        Formula out = (Formula)pCache.get(pF);
        return (T)out;
    }

    public Map<String, TFormulaInfo> extractVariablesAndUFs(TFormulaInfo pFormula, boolean extractUFs) {
        LinkedHashMap found = new LinkedHashMap();
        this.extractVariablesAndUFs(this.encapsulateWithTypeOf(pFormula), extractUFs, (String name, Formula f) -> found.put(name, this.extractInfo((Formula)f)));
        return found;
    }

    public void extractVariablesAndUFs(TFormulaInfo pFormula, boolean extractUFs, BiConsumer<String, TFormulaInfo> pConsumer) {
        this.extractVariablesAndUFs(this.encapsulateWithTypeOf(pFormula), extractUFs, (String name, Formula f) -> pConsumer.accept((String)name, this.extractInfo((Formula)f)));
    }

    public void extractVariablesAndUFs(Formula pFormula, boolean extractUF, BiConsumer<String, Formula> pConsumer) {
        this.visitRecursively(new VariableAndUFExtractor(extractUF, pConsumer, (Set<Formula>)ImmutableSet.of(), new LinkedHashSet<Formula>()), pFormula);
    }

    public final <T extends Formula> T callFunction(FunctionDeclaration<T> declaration, List<? extends Formula> args) {
        Preconditions.checkArgument((args.size() >= declaration.getArgumentTypes().size() ? 1 : 0) != 0, (String)"function application '%s' requires %s arguments, but received %s arguments", declaration, (Object)declaration.getArgumentTypes().size(), (Object)args.size());
        for (int i = 0; i < args.size(); ++i) {
            int index = Math.min(i, declaration.getArgumentTypes().size() - 1);
            Preconditions.checkArgument((boolean)this.isCompatible(this.getFormulaType((TFormulaInfo)args.get(i)), (FormulaType)declaration.getArgumentTypes().get(index)), (String)"function application '%s' requires argument types %s, but received argument types %s", declaration, declaration.getArgumentTypes(), (Object)Lists.transform(args, this::getFormulaType));
        }
        return this.encapsulate(declaration.getType(), this.callFunctionImpl(((FunctionDeclarationImpl)declaration).getSolverDeclaration(), this.extractInfo(args)));
    }

    protected boolean isCompatible(FormulaType<?> usedType, FormulaType<?> declaredType) {
        if (usedType.isIntegerType() && declaredType.isRationalType()) {
            return true;
        }
        return usedType.equals(declaredType);
    }

    public abstract TFormulaInfo callFunctionImpl(TFuncDecl var1, List<TFormulaInfo> var2);

    public abstract TFuncDecl declareUFImpl(String var1, TType var2, List<TType> var3);

    public TFuncDecl getBooleanVarDeclaration(BooleanFormula var) {
        return this.getBooleanVarDeclarationImpl(this.extractInfo(var));
    }

    protected abstract TFuncDecl getBooleanVarDeclarationImpl(TFormulaInfo var1);

    public Object convertValue(TFormulaInfo pF) {
        throw new UnsupportedOperationException("This SMT solver needs a second term to determine a correct type. Please use the other method 'convertValue(formula, formula)'.");
    }

    public Object convertValue(TFormulaInfo pAdditionalF, TFormulaInfo pF) {
        return this.convertValue(pF);
    }

    private class VariableAndUFExtractor
    extends DefaultFormulaVisitor<TraversalProcess> {
        private final boolean extractUF;
        private final BiConsumer<String, Formula> consumer;
        private final Set<Formula> boundVariablesInContext;
        private final Set<Formula> alreadyVisited;

        VariableAndUFExtractor(boolean pExtractUF, BiConsumer<String, Formula> pConsumer, Set<Formula> pBoundVariablesInContext, Set<Formula> pAlreadyVisited) {
            this.extractUF = pExtractUF;
            this.consumer = pConsumer;
            this.boundVariablesInContext = pBoundVariablesInContext;
            this.alreadyVisited = pAlreadyVisited;
        }

        @Override
        protected TraversalProcess visitDefault(Formula f) {
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            if (!this.boundVariablesInContext.contains(f) && functionDeclaration.getKind() == FunctionDeclarationKind.UF && this.extractUF && this.alreadyVisited.add(f)) {
                this.consumer.accept(functionDeclaration.getName(), f);
            }
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitFreeVariable(Formula f, String name) {
            if (!this.boundVariablesInContext.contains(f) && this.alreadyVisited.add(f)) {
                this.consumer.accept(name, f);
            }
            return TraversalProcess.CONTINUE;
        }

        @Override
        public TraversalProcess visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier q, List<Formula> boundVariables, BooleanFormula body) {
            FormulaCreator.this.visitRecursively(new VariableAndUFExtractor(this.extractUF, this.consumer, (Set<Formula>)Sets.union(this.boundVariablesInContext, (Set)ImmutableSet.copyOf(boundVariables)), this.alreadyVisited), body);
            return TraversalProcess.SKIP;
        }
    }
}

