/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import edu.stanford.CVC4.CVC4String;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Type;
import edu.stanford.CVC4.vectorExpr;
import java.util.List;
import org.sosy_lab.java_smt.basicimpl.AbstractStringFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

class CVC4StringFormulaManager
extends AbstractStringFormulaManager<Expr, Type, ExprManager, Expr> {
    private final ExprManager exprManager;

    CVC4StringFormulaManager(CVC4FormulaCreator pCreator) {
        super(pCreator);
        this.exprManager = (ExprManager)pCreator.getEnv();
    }

    @Override
    protected Expr makeStringImpl(String pValue) {
        return this.exprManager.mkConst(new CVC4String(pValue, true));
    }

    @Override
    protected Expr makeVariableImpl(String varName) {
        Type type = (Type)this.getFormulaCreator().getStringType();
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Expr equal(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Expr greaterThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.STRING_LT, pParam2, pParam1);
    }

    @Override
    protected Expr greaterOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.STRING_LEQ, pParam2, pParam1);
    }

    @Override
    protected Expr lessThan(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.STRING_LT, pParam1, pParam2);
    }

    @Override
    protected Expr lessOrEquals(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.STRING_LEQ, pParam1, pParam2);
    }

    @Override
    protected Expr length(Expr pParam) {
        return this.exprManager.mkExpr(Kind.STRING_LENGTH, pParam);
    }

    @Override
    protected Expr concatImpl(List<Expr> parts) {
        Preconditions.checkArgument((parts.size() > 1 ? 1 : 0) != 0);
        vectorExpr vector = new vectorExpr();
        parts.forEach(arg_0 -> ((vectorExpr)vector).add(arg_0));
        return this.exprManager.mkExpr(Kind.STRING_CONCAT, vector);
    }

    @Override
    protected Expr prefix(Expr prefix, Expr str) {
        return this.exprManager.mkExpr(Kind.STRING_PREFIX, prefix, str);
    }

    @Override
    protected Expr suffix(Expr suffix, Expr str) {
        return this.exprManager.mkExpr(Kind.STRING_SUFFIX, suffix, str);
    }

    @Override
    protected Expr in(Expr str, Expr regex) {
        return this.exprManager.mkExpr(Kind.STRING_IN_REGEXP, str, regex);
    }

    @Override
    protected Expr contains(Expr str, Expr part) {
        return this.exprManager.mkExpr(Kind.STRING_STRCTN, str, part);
    }

    @Override
    protected Expr indexOf(Expr str, Expr part, Expr startIndex) {
        return this.exprManager.mkExpr(Kind.STRING_STRIDOF, str, part, startIndex);
    }

    @Override
    protected Expr charAt(Expr str, Expr index) {
        return this.exprManager.mkExpr(Kind.STRING_CHARAT, str, index);
    }

    @Override
    protected Expr substring(Expr str, Expr index, Expr length) {
        return this.exprManager.mkExpr(Kind.STRING_SUBSTR, str, index, length);
    }

    @Override
    protected Expr replace(Expr fullStr, Expr target, Expr replacement) {
        return this.exprManager.mkExpr(Kind.STRING_STRREPL, fullStr, target, replacement);
    }

    @Override
    protected Expr replaceAll(Expr fullStr, Expr target, Expr replacement) {
        return this.exprManager.mkExpr(Kind.STRING_STRREPLALL, fullStr, target, replacement);
    }

    @Override
    protected Expr makeRegexImpl(String value) {
        Expr str = this.makeStringImpl(value);
        return this.exprManager.mkExpr(Kind.STRING_TO_REGEXP, str);
    }

    @Override
    protected Expr noneImpl() {
        return this.exprManager.mkExpr(Kind.REGEXP_EMPTY, new vectorExpr());
    }

    @Override
    protected Expr allImpl() {
        return this.exprManager.mkExpr(Kind.REGEXP_COMPLEMENT, this.noneImpl());
    }

    @Override
    protected Expr range(Expr start, Expr end) {
        return this.exprManager.mkExpr(Kind.REGEXP_RANGE, start, end);
    }

    @Override
    protected Expr concatRegexImpl(List<Expr> parts) {
        Preconditions.checkArgument((parts.size() > 1 ? 1 : 0) != 0);
        vectorExpr vector = new vectorExpr();
        parts.forEach(arg_0 -> ((vectorExpr)vector).add(arg_0));
        return this.exprManager.mkExpr(Kind.REGEXP_CONCAT, vector);
    }

    @Override
    protected Expr union(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.REGEXP_UNION, pParam1, pParam2);
    }

    @Override
    protected Expr intersection(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.REGEXP_INTER, pParam1, pParam2);
    }

    @Override
    protected Expr closure(Expr pParam) {
        return this.exprManager.mkExpr(Kind.REGEXP_STAR, pParam);
    }

    @Override
    protected Expr complement(Expr pParam) {
        return this.exprManager.mkExpr(Kind.REGEXP_COMPLEMENT, pParam);
    }

    @Override
    protected Expr difference(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.REGEXP_DIFF, pParam1, pParam2);
    }

    @Override
    protected Expr toIntegerFormula(Expr pParam) {
        return this.exprManager.mkExpr(Kind.STRING_STOI, pParam);
    }

    @Override
    protected Expr toStringFormula(Expr pParam) {
        return this.exprManager.mkExpr(Kind.STRING_ITOS, pParam);
    }
}

