/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.stanford.CVC4.CVC4JNI;
import edu.stanford.CVC4.Configuration;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.SExpr;
import edu.stanford.CVC4.SmtEngine;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4QuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4SLFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4StringFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4TheoremProver;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4UFManager;

public final class CVC4SolverContext
extends AbstractSolverContext {
    private CVC4FormulaCreator creator;
    private final ShutdownNotifier shutdownNotifier;
    private final int randomSeed;

    private CVC4SolverContext(CVC4FormulaCreator creator, CVC4FormulaManager manager, ShutdownNotifier pShutdownNotifier, int pRandomSeed) {
        super(manager);
        this.creator = creator;
        this.shutdownNotifier = pShutdownNotifier;
        this.randomSeed = pRandomSeed;
    }

    public static SolverContext create(LogManager pLogger, ShutdownNotifier pShutdownNotifier, int randomSeed, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic, FloatingPointRoundingMode pFloatingPointRoundingMode, Consumer<String> pLoader) {
        CVC4FloatingPointFormulaManager fpTheory;
        pLoader.accept("cvc4jni");
        ExprManager exprManager = new ExprManager();
        CVC4FormulaCreator creator = new CVC4FormulaCreator(exprManager);
        SmtEngine smtEngine = new SmtEngine(exprManager);
        smtEngine.setOption("output-language", new SExpr("smt2"));
        smtEngine.setOption("random-seed", new SExpr(randomSeed));
        smtEngine.setOption("strings-exp", new SExpr(true));
        CVC4UFManager functionTheory = new CVC4UFManager(creator);
        CVC4BooleanFormulaManager booleanTheory = new CVC4BooleanFormulaManager(creator);
        CVC4IntegerFormulaManager integerTheory = new CVC4IntegerFormulaManager(creator, pNonLinearArithmetic);
        CVC4RationalFormulaManager rationalTheory = new CVC4RationalFormulaManager(creator, pNonLinearArithmetic);
        CVC4BitvectorFormulaManager bitvectorTheory = new CVC4BitvectorFormulaManager(creator, booleanTheory);
        if (Configuration.isBuiltWithSymFPU()) {
            fpTheory = new CVC4FloatingPointFormulaManager(creator, pFloatingPointRoundingMode);
        } else {
            fpTheory = null;
            pLogger.log(Level.INFO, new Object[]{"CVC4 was built without support for FloatingPoint theory"});
        }
        CVC4QuantifiedFormulaManager qfTheory = new CVC4QuantifiedFormulaManager(creator);
        CVC4ArrayFormulaManager arrayTheory = new CVC4ArrayFormulaManager(creator);
        CVC4SLFormulaManager slTheory = new CVC4SLFormulaManager(creator);
        CVC4StringFormulaManager strTheory = new CVC4StringFormulaManager(creator);
        CVC4FormulaManager manager = new CVC4FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, fpTheory, qfTheory, arrayTheory, slTheory, strTheory);
        return new CVC4SolverContext(creator, manager, pShutdownNotifier, randomSeed);
    }

    @Override
    public String getVersion() {
        return "CVC4 " + CVC4JNI.Configuration_getVersionString();
    }

    @Override
    public void close() {
        if (this.creator != null) {
            ((ExprManager)this.creator.getEnv()).delete();
            this.creator = null;
        }
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.CVC4;
    }

    @Override
    public ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> pOptions) {
        return new CVC4TheoremProver(this.creator, this.shutdownNotifier, this.randomSeed, pOptions, this.getFormulaManager().getBooleanFormulaManager());
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("CVC4 does not support interpolation");
    }

    @Override
    protected OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> pSet) {
        throw new UnsupportedOperationException("CVC4 does not support optimization");
    }
}

