/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorAbstractProver;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

class BoolectorModel
extends AbstractModel.CachingAbstractModel<Long, Long, Long> {
    private static final ImmutableSet<String> SMT_KEYWORDS = ImmutableSet.of((Object)"let", (Object)"forall", (Object)"exists", (Object)"match", (Object)"Bool", (Object)"continued-execution", (Object[])new String[]{"error", "immediate-exit", "incomplete", "logic", "memout", "sat", "success", "theory", "unknown", "unsupported", "unsat", "_", "as", "BINARY", "DECIMAL", "exists", "HEXADECIMAL", "forall", "let", "match", "NUMERAL", "par", "STRING", "assert", "check-sat", "check-sat-assuming", "declare-const", "declare-datatype", "declare-datatypes", "declare-fun", "declare-sort", "define-fun", "define-fun-rec", "define-sort", "echo", "exit", "get-assertions", "get-assignment", "get-info", "get-model", "get-option", "get-proof", "get-unsat-assumptions", "get-unsat-core", "get-value", "pop", "push", "reset", "reset-assertions", "set-info", "set-logic", "set-option"});
    private final long btor;
    private final BoolectorAbstractProver<?> prover;
    private final BoolectorFormulaCreator bfCreator;
    private boolean closed = false;
    private final ImmutableList<Long> assertedTerms;

    BoolectorModel(long btor, BoolectorFormulaCreator creator, BoolectorAbstractProver<?> pProver, Collection<Long> assertedTerms) {
        super(creator);
        this.bfCreator = creator;
        this.btor = btor;
        this.prover = pProver;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        ImmutableSet.Builder variablesBuilder = ImmutableSet.builder();
        UnmodifiableIterator unmodifiableIterator = this.assertedTerms.iterator();
        while (unmodifiableIterator.hasNext()) {
            long term = (Long)unmodifiableIterator.next();
            String termString = BtorJNI.boolector_help_dump_node_smt2(this.btor, term);
            ArrayList<String> escapedList = new ArrayList<String>();
            Pattern pattern = Pattern.compile("(\\|.+?\\|(?<!\\\\\\|))");
            Matcher matcher = pattern.matcher(termString);
            while (matcher.find()) {
                escapedList.add(matcher.group());
            }
            String inputReplaced = termString;
            for (String escaped : escapedList) {
                inputReplaced = inputReplaced.replace(escaped, "");
            }
            inputReplaced = inputReplaced.replace("(", " ").replace(")", " ");
            Iterable maybeVars = Splitter.onPattern((String)"\\s+").split((CharSequence)inputReplaced);
            for (String var : maybeVars) {
                String varReplaced = var.replaceFirst("^(BTOR_\\d+@)", "");
                if (SMT_KEYWORDS.contains((Object)varReplaced) || !this.bfCreator.formulaCacheContains(varReplaced)) continue;
                variablesBuilder.add((Object)varReplaced);
            }
            for (String var : escapedList) {
                String varSubs = var.substring(1, var.length() - 1).replaceFirst("^(BTOR_\\d+@)", "");
                if (!this.bfCreator.formulaCacheContains(varSubs)) continue;
                variablesBuilder.add((Object)varSubs);
            }
        }
        return this.toList1((Set<String>)variablesBuilder.build());
    }

    private ImmutableList<Model.ValueAssignment> toList1(Set<String> variables) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        ImmutableList.Builder assignmentBuilder = ImmutableList.builder();
        for (String name : variables) {
            long entry = this.bfCreator.getFormulaFromCache(name).orElseThrow();
            if (BtorJNI.boolector_is_array(this.btor, entry)) {
                assignmentBuilder.add((Object)this.getArrayAssignment(entry, name));
                continue;
            }
            if (BtorJNI.boolector_is_const(this.btor, entry)) {
                assignmentBuilder.add((Object)this.getConstAssignment(entry, name));
                continue;
            }
            if (BtorJNI.boolector_is_uf(this.btor, entry)) {
                assignmentBuilder.addAll(this.getUFAssignments(entry, name));
                continue;
            }
            assignmentBuilder.add((Object)this.getConstAssignment(entry, name));
        }
        return assignmentBuilder.build();
    }

    private Model.ValueAssignment getConstAssignment(long key, String name) {
        ArrayList argumentInterpretation = new ArrayList();
        Object value = this.creator.convertValue(key, this.evalImpl(key));
        Long valueNode = BtorJNI.boolector_get_value(this.btor, key);
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(valueNode), this.creator.encapsulateBoolean(BtorJNI.boolector_eq(this.btor, key, valueNode)), name, value, argumentInterpretation);
    }

    private ImmutableList<Model.ValueAssignment> getUFAssignments(long key, String name) {
        ImmutableList.Builder assignments = ImmutableList.builder();
        Long fun = BtorJNI.boolector_get_value(this.btor, key);
        String[][] ufAssignments = BtorJNI.boolector_uf_assignment_helper(this.btor, key);
        for (int i = 0; i < ufAssignments[0].length; ++i) {
            ImmutableList.Builder argBuilder = ImmutableList.builder();
            String arguments = ufAssignments[0][i];
            Object value = this.bfCreator.transformStringToBigInt(ufAssignments[1][i]);
            for (String arg : Splitter.onPattern((String)"\\s+").splitToList((CharSequence)arguments)) {
                argBuilder.add(this.bfCreator.transformStringToBigInt(arg));
            }
            Long equality = BtorJNI.boolector_eq(this.btor, key, fun);
            assignments.add((Object)new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(fun), this.creator.encapsulateBoolean(equality), name, value, (Collection<?>)argBuilder.build()));
        }
        return assignments.build();
    }

    private Model.ValueAssignment getArrayAssignment(long key, String name) {
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        for (String stringArrayEntry : BtorJNI.boolector_array_assignment_helper(this.btor, key)[0]) {
            argumentInterpretation.add(this.bfCreator.transformStringToBigInt(stringArrayEntry));
        }
        Object value = this.creator.convertValue(key, this.evalImpl(key));
        Long valueNode = BtorJNI.boolector_get_value(this.btor, key);
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(valueNode), this.creator.encapsulateBoolean(BtorJNI.boolector_eq(this.btor, key, valueNode)), name, value, argumentInterpretation);
    }

    @Override
    protected Long evalImpl(Long pFormula) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return pFormula;
    }
}

