/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import java.math.BigInteger;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

class BoolectorBitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Long, Long, Long, Long> {
    private final long btor;

    BoolectorBitvectorFormulaManager(BoolectorFormulaCreator creator, BoolectorBooleanFormulaManager pBmgr) {
        super(creator, pBmgr);
        this.btor = (Long)creator.getEnv();
    }

    @Override
    public Long makeBitvectorImpl(int pLength, BigInteger pI) {
        pI = this.transformValueToRange(pLength, pI);
        long sort = BtorJNI.boolector_bitvec_sort(this.btor, pLength);
        return BtorJNI.boolector_constd(this.btor, sort, pI.toString());
    }

    @Override
    protected Long makeBitvectorImpl(int length, Long value) {
        throw new UnsupportedOperationException("Boolector does not support INT theory");
    }

    @Override
    public Long toIntegerFormulaImpl(Long pI, boolean pSigned) {
        throw new UnsupportedOperationException("BV to INT conversion is not supported.");
    }

    @Override
    public Long negate(Long bitVec) {
        return BtorJNI.boolector_neg(this.btor, bitVec);
    }

    @Override
    public Long add(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_add(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long subtract(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_sub(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long divide(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_sdiv(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_udiv(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long modulo(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_smod(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_urem(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long multiply(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_mul(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long equal(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_eq(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long greaterThan(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_sgt(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_ugt(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long greaterOrEquals(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_sgte(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_ugte(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long lessThan(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_slt(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_ult(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long lessOrEquals(Long bitVec1, Long bitVec2, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_slte(this.btor, bitVec1, bitVec2);
        }
        return BtorJNI.boolector_ulte(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long not(Long bitVec) {
        return BtorJNI.boolector_not(this.btor, bitVec);
    }

    @Override
    public Long and(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_and(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long or(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_or(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long xor(Long bitVec1, Long bitVec2) {
        return BtorJNI.boolector_xor(this.btor, bitVec1, bitVec2);
    }

    @Override
    public Long makeVariableImpl(int pLength, String pVar) {
        long sort = BtorJNI.boolector_bitvec_sort(this.btor, pLength);
        return (Long)this.getFormulaCreator().makeVariable(sort, pVar);
    }

    @Override
    public Long shiftRight(Long bitVec, Long toShift, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_sra(this.btor, bitVec, toShift);
        }
        return BtorJNI.boolector_srl(this.btor, bitVec, toShift);
    }

    @Override
    public Long shiftLeft(Long bitVec, Long toShift) {
        return BtorJNI.boolector_sll(this.btor, bitVec, toShift);
    }

    @Override
    public Long concat(Long bitVec, Long bitVecAppend) {
        return BtorJNI.boolector_concat(this.btor, bitVec, bitVecAppend);
    }

    @Override
    public Long extract(Long pNode, int pMsb, int pLsb, boolean pSigned) {
        return BtorJNI.boolector_slice(this.btor, pNode, pMsb, pLsb);
    }

    @Override
    public Long extend(Long bitVec, int extensionBits, boolean signed) {
        if (signed) {
            return BtorJNI.boolector_sext(this.btor, bitVec, extensionBits);
        }
        return BtorJNI.boolector_uext(this.btor, bitVec, extensionBits);
    }
}

