/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;

class HardIntegerFormulaGenerator {
    private final IntegerFormulaManager ifmgr;
    private final BooleanFormulaManager bfmgr;
    private static final String CHOICE_PREFIX = "b@";
    private static final String COUNTER_PREFIX = "i@";

    HardIntegerFormulaGenerator(IntegerFormulaManager pIfmgr, BooleanFormulaManager pBfmgr) {
        this.ifmgr = pIfmgr;
        this.bfmgr = pBfmgr;
    }

    BooleanFormula generate(int n) {
        Preconditions.checkArgument((n >= 2 ? 1 : 0) != 0);
        ArrayList<BooleanFormula> clauses = new ArrayList<BooleanFormula>();
        clauses.add(this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("i@0"), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(0L)));
        int lastIdx = 0;
        int expected = 0;
        for (int i = 1; i < 2 * n; i += 2) {
            BooleanFormula selector = this.bfmgr.makeVariable(CHOICE_PREFIX + i);
            clauses.add(this.bfmgr.or(this.mkConstraint(i, 3, selector), this.mkConstraint(i, 2, this.bfmgr.not(selector))));
            clauses.add(this.bfmgr.or(this.mkConstraint(i + 1, 3, this.bfmgr.not(selector)), this.mkConstraint(i + 1, 2, selector)));
            lastIdx = i + 1;
            expected += 5;
        }
        clauses.add(this.ifmgr.greaterThan((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable(COUNTER_PREFIX + lastIdx), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(expected)));
        return this.bfmgr.and(clauses);
    }

    private BooleanFormula mkConstraint(int newIdx, int increment, BooleanFormula selector) {
        return this.bfmgr.and(selector, this.ifmgr.equal((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable(COUNTER_PREFIX + newIdx), (NumeralFormula.IntegerFormula)this.ifmgr.add((NumeralFormula.IntegerFormula)this.ifmgr.makeVariable(COUNTER_PREFIX + (newIdx - 1)), (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(increment))));
    }
}

