/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSolverContext;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackInterpolatingProver;
import org.sosy_lab.java_smt.basicimpl.reusableStack.ReusableStackTheoremProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.LogProxyForwarder;
import org.sosy_lab.java_smt.solvers.smtinterpol.LoggingSmtInterpolInterpolatingProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolIntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolInterpolatingProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolRationalFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolTheoremProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolUFManager;

public final class SmtInterpolSolverContext
extends AbstractSolverContext {
    private final SmtInterpolSettings settings;
    private final ShutdownNotifier shutdownNotifier;
    private final SmtInterpolFormulaManager manager;

    private SmtInterpolSolverContext(SmtInterpolFormulaManager pManager, ShutdownNotifier pShutdownNotifier, SmtInterpolSettings pSettings) {
        super(pManager);
        this.settings = pSettings;
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.manager = pManager;
    }

    public static SmtInterpolSolverContext create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate smtLogfile, long randomSeed, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) throws InvalidConfigurationException {
        SmtInterpolSettings settings = new SmtInterpolSettings(config, randomSeed, smtLogfile);
        Script script = SmtInterpolSolverContext.getSmtInterpolScript(pShutdownNotifier, smtLogfile, settings, logger);
        SmtInterpolFormulaCreator creator = new SmtInterpolFormulaCreator(script);
        SmtInterpolUFManager functionTheory = new SmtInterpolUFManager(creator);
        SmtInterpolBooleanFormulaManager booleanTheory = new SmtInterpolBooleanFormulaManager(creator);
        SmtInterpolIntegerFormulaManager integerTheory = new SmtInterpolIntegerFormulaManager(creator, pNonLinearArithmetic);
        SmtInterpolRationalFormulaManager rationalTheory = new SmtInterpolRationalFormulaManager(creator, pNonLinearArithmetic);
        SmtInterpolArrayFormulaManager arrayTheory = new SmtInterpolArrayFormulaManager(creator);
        SmtInterpolFormulaManager manager = new SmtInterpolFormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, arrayTheory, logger);
        return new SmtInterpolSolverContext(manager, pShutdownNotifier, settings);
    }

    private static Script getSmtInterpolScript(ShutdownNotifier pShutdownNotifier, @javax.annotation.Nullable PathCounterTemplate smtLogfile, SmtInterpolSettings settings, LogManager logger) throws InvalidConfigurationException {
        LogProxyForwarder smtInterpolLogProxy = new LogProxyForwarder(logger.withComponentName("SMTInterpol"));
        SMTInterpol smtInterpol = new SMTInterpol((LogProxy)smtInterpolLogProxy, () -> ((ShutdownNotifier)pShutdownNotifier).shouldShutdown());
        Script script = SmtInterpolSolverContext.wrapInLoggingScriptIfNeeded(smtInterpol, smtLogfile);
        for (Map.Entry entry : settings.optionsMap.entrySet()) {
            try {
                script.setOption((String)entry.getKey(), entry.getValue());
            }
            catch (SMTLIBException | UnsupportedOperationException e) {
                throw new InvalidConfigurationException("Invalid option \"" + (String)entry.getKey() + "=" + entry.getValue() + "\" for SMTInterpol.", e);
            }
        }
        script.setLogic(Logics.AUFNIRA);
        return script;
    }

    private static Script wrapInLoggingScriptIfNeeded(SMTInterpol smtInterpol, @Nullable PathCounterTemplate smtLogfileTemplate) throws InvalidConfigurationException {
        if (smtLogfileTemplate == null) {
            return smtInterpol;
        }
        Path smtLogfile = smtLogfileTemplate.getFreshPath();
        String filename = smtLogfile.toAbsolutePath().toString();
        try {
            return new LoggingScript((Script)smtInterpol, filename, true, true);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not open log file for SMTInterpol queries.", (Throwable)e);
        }
    }

    private Script createNewScript(Set<SolverContext.ProverOptions> pOptions) {
        LinkedHashMap<String, Object> newOptions = new LinkedHashMap<String, Object>((Map<String, Object>)this.settings.optionsMap);
        newOptions.put(":produce-unsat-cores", pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) || pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS));
        newOptions.put(":produce-models", pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS));
        SMTInterpol smtInterpol = new SMTInterpol(this.getSmtInterpol(), newOptions, OptionMap.CopyMode.RESET_TO_DEFAULT);
        try {
            return SmtInterpolSolverContext.wrapInLoggingScriptIfNeeded(smtInterpol, this.settings.smtLogfile);
        }
        catch (InvalidConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    private SMTInterpol getSmtInterpol() {
        Script script = (Script)this.manager.getEnvironment();
        if (script instanceof SMTInterpol) {
            return (SMTInterpol)script;
        }
        if (script instanceof WrapperScript) {
            return (SMTInterpol)((WrapperScript)Preconditions.checkNotNull((Object)((WrapperScript)script))).findBacking(SMTInterpol.class);
        }
        throw new AssertionError((Object)("unexpected class for SMTInterpol: " + script.getClass()));
    }

    @Override
    protected ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        Script newScript = this.createNewScript(options);
        return new ReusableStackTheoremProver(new SmtInterpolTheoremProver(this.manager, newScript, options, this.shutdownNotifier));
    }

    @Override
    protected InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> options) {
        Script newScript = this.createNewScript(options);
        SmtInterpolInterpolatingProver prover = this.settings.smtLogfile == null ? new SmtInterpolInterpolatingProver(this.manager, newScript, options, this.shutdownNotifier) : new LoggingSmtInterpolInterpolatingProver(this.manager, newScript, options, this.shutdownNotifier, (Map<String, Object>)this.settings.optionsMap, this.settings.smtLogfile.getFreshPath());
        return new ReusableStackInterpolatingProver<String>(prover);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> options) {
        throw new UnsupportedOperationException("SMTInterpol does not support optimization");
    }

    @Override
    public String getVersion() {
        QuotedObject program = (QuotedObject)((Script)this.manager.getEnvironment()).getInfo(":name");
        QuotedObject version = (QuotedObject)((Script)this.manager.getEnvironment()).getInfo(":version");
        return program.getValue() + " " + version.getValue();
    }

    @Override
    public SolverContextFactory.Solvers getSolverName() {
        return SolverContextFactory.Solvers.SMTINTERPOL;
    }

    @Override
    public void close() {
    }

    @Override
    protected boolean supportsAssumptionSolving() {
        return false;
    }

    @Options(prefix="solver.smtinterpol")
    private static class SmtInterpolSettings {
        @Option(secure=true, description="Double check generated results like interpolants and models whether they are correct")
        private boolean checkResults = false;
        @Option(secure=true, description="Further options that will be set to true for SMTInterpol in addition to the default options. Format is 'option1,option2,option3'")
        private List<String> furtherOptions = ImmutableList.of();
        private final @Nullable PathCounterTemplate smtLogfile;
        private final ImmutableMap<String, Object> optionsMap;

        private SmtInterpolSettings(Configuration config, long pRandomSeed, @Nullable PathCounterTemplate pSmtLogfile) throws InvalidConfigurationException {
            config.inject((Object)this);
            this.smtLogfile = pSmtLogfile;
            ImmutableMap.Builder opt = ImmutableMap.builder();
            opt.put((Object)":global-declarations", (Object)true);
            opt.put((Object)":random-seed", (Object)pRandomSeed);
            opt.put((Object)":produce-interpolants", (Object)true);
            if (this.checkResults) {
                opt.put((Object)":interpolant-check-mode", (Object)true);
                opt.put((Object)":unsat-core-check-mode", (Object)true);
                opt.put((Object)":model-check-mode", (Object)true);
            }
            for (String option : this.furtherOptions) {
                opt.put((Object)option, (Object)true);
            }
            this.optionsMap = opt.build();
        }
    }
}

