/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;

class SmtInterpolFormulaCreator
extends FormulaCreator<Term, Sort, Script, FunctionSymbol> {
    private static final ImmutableSet<String> UNSUPPORTED_IDENTIFIERS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"select", (Object)"store", (Object)"or", (Object)"and", (Object[])new String[]{"xor", "distinct"});

    SmtInterpolFormulaCreator(Script env) {
        super(env, env.getTheory().getBooleanSort(), env.getTheory().getNumericSort(), env.getTheory().getRealSort());
    }

    @Override
    public FormulaType<?> getFormulaType(Term pFormula) {
        return this.getFormulaTypeOfSort(pFormula.getSort());
    }

    private FormulaType<?> getFormulaTypeOfSort(Sort pSort) {
        if (pSort == this.getIntegerType()) {
            return FormulaType.IntegerType;
        }
        if (pSort == this.getRationalType()) {
            return FormulaType.RationalType;
        }
        if (pSort == this.getBoolType()) {
            return FormulaType.BooleanType;
        }
        if (pSort.isArraySort()) {
            return new FormulaType.ArrayFormulaType(this.getFormulaTypeOfSort(pSort.getArguments()[0]), this.getFormulaTypeOfSort(pSort.getArguments()[1]));
        }
        throw new IllegalArgumentException("Unknown formula type for sort: " + pSort);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return new FormulaType.ArrayFormulaType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public Term makeVariable(Sort type, String varName) {
        this.declareFun(varName, new Sort[0], type);
        return ((Script)this.environment).term(varName, new Term[0]);
    }

    @CanIgnoreReturnValue
    private FunctionSymbol declareFun(String fun, Sort[] paramSorts, Sort resultSort) {
        this.checkSymbol(fun);
        FunctionSymbol fsym = ((Script)this.environment).getTheory().getFunction(fun, paramSorts);
        if (fsym == null) {
            ((Script)this.environment).declareFun(fun, paramSorts, resultSort);
            return ((Script)this.environment).getTheory().getFunction(fun, paramSorts);
        }
        if (!fsym.getReturnSort().equals(resultSort)) {
            throw new IllegalArgumentException("Function " + fun + " is already declared with different definition");
        }
        if (fun.equals("true") || fun.equals("false")) {
            throw new IllegalArgumentException("Cannot declare a variable named " + fun);
        }
        return fsym;
    }

    private void checkSymbol(String symbol) throws SMTLIBException {
        Preconditions.checkArgument((symbol.indexOf(124) == -1 && symbol.indexOf(92) == -1 ? 1 : 0) != 0, (Object)"Symbol must not contain | or \\");
        Preconditions.checkArgument((!UNSUPPORTED_IDENTIFIERS.contains((Object)symbol) ? 1 : 0) != 0, (String)"SMTInterpol does not support %s as identifier.", (Object)symbol);
    }

    @Override
    public Sort getBitvectorType(int pBitwidth) {
        throw new UnsupportedOperationException("Bitvector theory is not supported by SmtInterpol");
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by SmtInterpol");
    }

    @Override
    public Sort getArrayType(Sort pIndexType, Sort pElementType) {
        return ((Script)this.getEnv()).getTheory().getSort("Array", new Sort[]{pIndexType, pElementType});
    }

    @Override
    public Object convertValue(Term value) {
        FormulaType<Term> type = this.getFormulaType((Formula)value);
        if (type.isBooleanType()) {
            return value.getTheory().mTrue == value;
        }
        if (value instanceof ConstantTerm && ((ConstantTerm)value).getValue() instanceof de.uni_freiburg.informatik.ultimate.logic.Rational) {
            de.uni_freiburg.informatik.ultimate.logic.Rational rationalValue = (de.uni_freiburg.informatik.ultimate.logic.Rational)((ConstantTerm)value).getValue();
            Rational out = Rational.of((BigInteger)rationalValue.numerator(), (BigInteger)rationalValue.denominator());
            if (this.getFormulaTypeOfSort(value.getSort()).isIntegerType()) {
                assert (out.isIntegral());
                return out.getNum();
            }
            return out;
        }
        throw new IllegalArgumentException("Unexpected value: " + value);
    }

    private String dequote(String s) {
        int l = s.length();
        if (s.charAt(0) == '|' && s.charAt(l - 1) == '|') {
            return s.substring(1, l - 1);
        }
        return s;
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula f, Term input) {
        Preconditions.checkArgument((boolean)input.getTheory().equals(((Script)this.environment).getTheory()), (String)"Given term belongs to a different instance of SMTInterpol: %s", (Object)input);
        if (input instanceof ConstantTerm) {
            Object outValue;
            Object interpolValue = ((ConstantTerm)input).getValue();
            if (interpolValue instanceof de.uni_freiburg.informatik.ultimate.logic.Rational) {
                de.uni_freiburg.informatik.ultimate.logic.Rational rat = (de.uni_freiburg.informatik.ultimate.logic.Rational)interpolValue;
                outValue = input.getSort().getName().equals("Int") && rat.isIntegral() ? rat.numerator() : Rational.of((BigInteger)rat.numerator(), (BigInteger)rat.denominator());
            } else {
                outValue = ((ConstantTerm)input).getValue();
            }
            return visitor.visitConstant(f, outValue);
        }
        if (input instanceof ApplicationTerm) {
            ImmutableList argTypes;
            ApplicationTerm app = (ApplicationTerm)input;
            int arity = app.getParameters().length;
            FunctionSymbol func = app.getFunction();
            if (arity == 0) {
                if (app.equals(((Script)this.environment).getTheory().mTrue)) {
                    return visitor.visitConstant(f, Boolean.TRUE);
                }
                if (app.equals(((Script)this.environment).getTheory().mFalse)) {
                    return visitor.visitConstant(f, Boolean.FALSE);
                }
                if (func.getDefinition() == null) {
                    return visitor.visitFreeVariable(f, this.dequote(input.toString()));
                }
                throw new UnsupportedOperationException("Unexpected nullary function " + input);
            }
            String name = func.getName();
            ImmutableList args = Collections3.transformedImmutableListCopy((Object[])app.getParameters(), term -> this.encapsulate(this.getFormulaType((Formula)term), term));
            Term definition = func.getDefinition();
            if (definition == null) {
                argTypes = Collections3.transformedImmutableListCopy((Collection)args, this::getFormulaType);
            } else {
                Object[] paramSorts = ((ApplicationTerm)definition).getFunction().getParameterSorts();
                argTypes = Collections3.transformedImmutableListCopy((Object[])paramSorts, this::getFormulaTypeOfSort);
            }
            return visitor.visitFunction(f, (List<Formula>)args, FunctionDeclarationImpl.of(name, this.getDeclarationKind(app), argTypes, this.getFormulaType(f), app.getFunction()));
        }
        throw new UnsupportedOperationException(String.format("Unexpected SMTInterpol formula of type %s: %s", input.getClass().getSimpleName(), input));
    }

    String getName(Term t) {
        if (SmtInterpolFormulaCreator.isUF(t)) {
            assert (t instanceof ApplicationTerm);
            return ((ApplicationTerm)t).getFunction().getName();
        }
        return this.dequote(t.toString());
    }

    private static boolean isVariable(Term t) {
        return t.getTheory().mTrue != t && t.getTheory().mFalse != t && t instanceof ApplicationTerm && ((ApplicationTerm)t).getParameters().length == 0 && ((ApplicationTerm)t).getFunction().getDefinition() == null;
    }

    private static boolean isUF(Term t) {
        if (!(t instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)t;
        FunctionSymbol func = applicationTerm.getFunction();
        return applicationTerm.getParameters().length > 0 && !func.isIntern() && !func.isInterpreted();
    }

    private FunctionDeclarationKind getDeclarationKind(ApplicationTerm input) {
        assert (!SmtInterpolFormulaCreator.isVariable((Term)input)) : "Variables should be handled somewhere else";
        FunctionSymbol symbol = input.getFunction();
        Theory t = input.getTheory();
        if (SmtInterpolFormulaCreator.isUF((Term)input)) {
            return FunctionDeclarationKind.UF;
        }
        if (symbol == t.mAnd) {
            return FunctionDeclarationKind.AND;
        }
        if (symbol == t.mOr) {
            return FunctionDeclarationKind.OR;
        }
        if (symbol == t.mNot) {
            return FunctionDeclarationKind.NOT;
        }
        if (symbol == t.mImplies) {
            return FunctionDeclarationKind.IMPLIES;
        }
        if (symbol == t.mXor) {
            return FunctionDeclarationKind.XOR;
        }
        switch (symbol.getName()) {
            case "=": {
                return FunctionDeclarationKind.EQ;
            }
            case "distinct": {
                return FunctionDeclarationKind.DISTINCT;
            }
            case "ite": {
                return FunctionDeclarationKind.ITE;
            }
            case "select": {
                return FunctionDeclarationKind.SELECT;
            }
            case "store": {
                return FunctionDeclarationKind.STORE;
            }
            case "*": {
                return FunctionDeclarationKind.MUL;
            }
            case "+": {
                return FunctionDeclarationKind.ADD;
            }
            case "-": {
                return FunctionDeclarationKind.SUB;
            }
            case "/": {
                return FunctionDeclarationKind.DIV;
            }
            case "%": {
                return FunctionDeclarationKind.MODULO;
            }
            case "<": {
                return FunctionDeclarationKind.LT;
            }
            case "<=": {
                return FunctionDeclarationKind.LTE;
            }
            case ">": {
                return FunctionDeclarationKind.GT;
            }
            case ">=": {
                return FunctionDeclarationKind.GTE;
            }
            case "to_int": {
                return FunctionDeclarationKind.FLOOR;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    @Override
    public FunctionSymbol declareUFImpl(String pName, Sort returnType, List<Sort> pArgs) {
        Sort[] types = pArgs.toArray(new Sort[0]);
        return this.declareFun(pName, types, returnType);
    }

    @Override
    public Term callFunctionImpl(FunctionSymbol declaration, List<Term> args) {
        return ((Script)this.environment).term(declaration.getName(), args.toArray(new Term[0]));
    }

    @Override
    protected FunctionSymbol getBooleanVarDeclarationImpl(Term pTerm) {
        assert (pTerm instanceof ApplicationTerm);
        return ((ApplicationTerm)pTerm).getFunction();
    }
}

