/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolModel;

abstract class SmtInterpolAbstractProver<T, AF>
extends AbstractProver<T> {
    private boolean closed = false;
    protected final Script env;
    protected final FormulaCreator<Term, Sort, Script, FunctionSymbol> creator;
    protected final SmtInterpolFormulaManager mgr;
    protected final Deque<List<AF>> assertedFormulas = new ArrayDeque<List<AF>>();
    protected final Map<String, Term> annotatedTerms = new HashMap<String, Term>();
    protected final ShutdownNotifier shutdownNotifier;
    private static final String PREFIX = "term_";
    private static final UniqueIdGenerator termIdGenerator = new UniqueIdGenerator();

    SmtInterpolAbstractProver(SmtInterpolFormulaManager pMgr, Script pEnv, Set<SolverContext.ProverOptions> options, ShutdownNotifier pShutdownNotifier) {
        super(options);
        this.mgr = pMgr;
        this.creator = pMgr.getFormulaCreator();
        this.env = pEnv;
        this.shutdownNotifier = pShutdownNotifier;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    int size() {
        return this.assertedFormulas.size();
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.push(new ArrayList());
        this.env.push(1);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.pop();
        this.env.pop(1);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.shutdownNotifier.shutdownIfNecessary();
        Script.LBool result = this.env.checkSat();
        switch (result) {
            case SAT: {
                return false;
            }
            case UNSAT: {
                return true;
            }
            case UNKNOWN: {
                Object reason = this.env.getInfo(":reason-unknown");
                if (!(reason instanceof ReasonUnknown)) {
                    throw new SMTLIBException("checkSat returned UNKNOWN with unknown reason " + reason);
                }
                switch ((ReasonUnknown)reason) {
                    case MEMOUT: {
                        throw new OutOfMemoryError("Out of memory during SMTInterpol operation");
                    }
                    case CANCELLED: {
                        this.shutdownNotifier.shutdownIfNecessary();
                        throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
                    }
                }
                throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
            }
        }
        throw new SMTLIBException("checkSat returned " + result);
    }

    @Override
    public SmtInterpolModel getModel() {
        Model model;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        try {
            model = this.env.getModel();
        }
        catch (SMTLIBException e) {
            if (e.getMessage().contains("Context is inconsistent")) {
                throw new IllegalStateException("Model computation failed. Are the pushed formulae satisfiable?", e);
            }
            throw e;
        }
        return new SmtInterpolModel(model, this.creator);
    }

    protected static String generateTermName() {
        return PREFIX + termIdGenerator.getFreshId();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        return this.getUnsatCore0();
    }

    private List<BooleanFormula> getUnsatCore0() {
        return Collections3.transformedImmutableListCopy((Object[])this.env.getUnsatCore(), input -> this.creator.encapsulateBoolean(this.annotatedTerms.get(input.toString())));
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateUnsatCoresOverAssumptions();
        this.push();
        Preconditions.checkState((boolean)this.annotatedTerms.isEmpty(), (String)"Empty environment required for UNSAT core over assumptions: %s", this.annotatedTerms);
        for (BooleanFormula assumption : assumptions) {
            String termName = SmtInterpolAbstractProver.generateTermName();
            Term t = (Term)this.mgr.extractInfo(assumption);
            Term annotated = this.env.annotate(t, new Annotation[]{new Annotation(":named", (Object)termName)});
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        }
        Optional<List<BooleanFormula>> result = this.isUnsat() ? Optional.of(this.getUnsatCore0()) : Optional.empty();
        this.pop();
        return result;
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.clear();
        this.annotatedTerms.clear();
        this.env.pop(this.assertedFormulas.size());
        this.closed = true;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Assumption-solving is not supported.");
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateAllSat();
        Term[] importantTerms = new Term[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantTerms[i++] = (Term)this.mgr.extractInfo(impF);
        }
        this.shutdownNotifier.shutdownIfNecessary();
        for (Object[] model : this.env.checkAllsat(importantTerms)) {
            callback.apply((List<BooleanFormula>)Collections3.transformedImmutableListCopy((Object[])model, this.creator::encapsulateBoolean));
        }
        return callback.getResult();
    }
}

