/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.ITerm;
import ap.terfor.preds.Predicate;
import ap.theories.ExtArray;
import ap.types.Sort;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessModel
extends AbstractModel.CachingAbstractModel<IExpression, Sort, PrincessEnvironment> {
    private final SimpleAPI.PartialModel model;
    private final SimpleAPI api;

    PrincessModel(SimpleAPI.PartialModel partialModel, FormulaCreator<IExpression, Sort, PrincessEnvironment, ?> creator, SimpleAPI pApi) {
        super(creator);
        this.model = partialModel;
        this.api = pApi;
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        Map interpretation = this.model.interpretation();
        LinkedHashSet<Predicate> abbrevs = new LinkedHashSet<Predicate>();
        for (Map.Entry entry : JavaConverters.asJava((Map)this.api.ap$SimpleAPI$$abbrevPredicates()).entrySet()) {
            abbrevs.add((Predicate)entry.getKey());
            abbrevs.add((Predicate)((Tuple2)entry.getValue())._2());
        }
        Multimap<IFunApp, ITerm> arrays = this.getArrays((Map<IExpression, IExpression>)interpretation);
        ImmutableSet.Builder assignments = ImmutableSet.builder();
        for (Map.Entry entry : JavaConverters.asJava((Map)interpretation).entrySet()) {
            if (this.isAbbrev(abbrevs, (IExpression)entry.getKey())) continue;
            assignments.addAll(this.getAssignments((IExpression)entry.getKey(), (IExpression)entry.getValue(), arrays));
        }
        return assignments.build().asList();
    }

    private boolean isAbbrev(Set<Predicate> abbrevs, IExpression var) {
        return var instanceof IAtom && abbrevs.contains(((IAtom)var).pred());
    }

    private Multimap<IFunApp, ITerm> getArrays(Map<IExpression, IExpression> interpretation) {
        ArrayListMultimap arrays = ArrayListMultimap.create();
        for (Map.Entry entry : JavaConverters.asJava(interpretation).entrySet()) {
            if (!(entry.getKey() instanceof IConstant)) continue;
            IConstant maybeArray = (IConstant)entry.getKey();
            IExpression value = (IExpression)entry.getValue();
            if (!((PrincessEnvironment)this.creator.getEnv()).hasArrayType((IExpression)maybeArray) || !(value instanceof IFunApp) || !ExtArray.Store$.MODULE$.unapply(((IFunApp)value).fun()).isDefined()) continue;
            arrays.put((Object)((IFunApp)value), (Object)maybeArray);
        }
        return arrays;
    }

    private ImmutableList<Model.ValueAssignment> getAssignments(IExpression key, IExpression value, Multimap<IFunApp, ITerm> pArrays) {
        IBinFormula fAssignment;
        String name;
        if (key instanceof IConstant) {
            if (((PrincessEnvironment)this.creator.getEnv()).hasArrayType(key)) {
                return ImmutableList.of();
            }
        } else if (key instanceof IFunApp) {
            IFunApp cKey = (IFunApp)key;
            if (ExtArray.Select$.MODULE$.unapply(cKey.fun()).isDefined()) {
                return this.getAssignmentsFromArraySelect(value, cKey, pArrays);
            }
            if (ExtArray.Store$.MODULE$.unapply(cKey.fun()).isDefined()) {
                return this.getAssignmentsFromArrayStore((IFunApp)value, cKey, pArrays);
            }
        }
        Object argumentInterpretations = ImmutableList.of();
        if (key instanceof IAtom) {
            name = key.toString();
            fAssignment = new IBinFormula(IBinJunctor.Eqv(), (IFormula)((IAtom)key), (IFormula)value);
        } else if (key instanceof IConstant) {
            name = key.toString();
            fAssignment = ((IConstant)key).$eq$eq$eq((ITerm)value);
        } else if (key instanceof IFunApp) {
            IFunApp cKey = (IFunApp)key;
            argumentInterpretations = new ArrayList();
            for (ITerm arg : JavaConverters.asJava((Seq)cKey.args())) {
                argumentInterpretations.add(this.creator.convertValue(arg));
            }
            name = cKey.fun().name();
            fAssignment = ((ITerm)key).$eq$eq$eq((ITerm)value);
        } else {
            throw new AssertionError((Object)String.format("unknown type of key: %s -> %s (%s)", key, value, key.getClass()));
        }
        return ImmutableList.of((Object)new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(fAssignment), name, this.creator.convertValue(value), (Collection<?>)argumentInterpretations));
    }

    private ImmutableList<Model.ValueAssignment> getAssignmentsFromArraySelect(IExpression fValue, IFunApp cKey, Multimap<IFunApp, ITerm> pArrays) {
        IFunApp arrayId = (IFunApp)cKey.args().apply((Object)0);
        ITerm arrayIndex = (ITerm)cKey.args().apply((Object)1);
        ImmutableList.Builder arrayAssignments = ImmutableList.builder();
        for (ITerm arrayF : pArrays.get((Object)arrayId)) {
            ITerm select = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, arrayIndex);
            arrayAssignments.add((Object)new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(fValue), this.creator.encapsulateBoolean(select.$eq$eq$eq((ITerm)fValue)), arrayF.toString(), this.creator.convertValue(fValue), (Collection<?>)ImmutableList.of((Object)this.creator.convertValue(arrayIndex))));
        }
        return arrayAssignments.build();
    }

    private ImmutableList<Model.ValueAssignment> getAssignmentsFromArrayStore(IFunApp value, IFunApp cKey, Multimap<IFunApp, ITerm> pArrays) {
        ITerm arrayIndex = (ITerm)cKey.args().apply((Object)1);
        ITerm arrayContent = (ITerm)cKey.args().apply((Object)2);
        ImmutableList.Builder arrayAssignments = ImmutableList.builder();
        for (ITerm arrayF : pArrays.get((Object)value)) {
            ITerm select = ((PrincessEnvironment)this.creator.getEnv()).makeSelect(arrayF, arrayIndex);
            arrayAssignments.add((Object)new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(select), this.creator.encapsulateWithTypeOf(arrayContent), this.creator.encapsulateBoolean(select.$eq$eq$eq(arrayContent)), arrayF.toString(), this.creator.convertValue(arrayContent), (Collection<?>)ImmutableList.of((Object)this.creator.convertValue(arrayIndex))));
        }
        return arrayAssignments.build();
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    @Override
    public void close() {
    }

    @Override
    protected IExpression evalImpl(IExpression formula) {
        IExpression evaluation = this.evaluate(formula);
        if (evaluation == null) {
            evaluation = this.evaluate(((PrincessEnvironment)this.creator.getEnv()).simplify(formula));
        }
        return evaluation;
    }

    private IExpression evaluate(IExpression formula) {
        if (formula instanceof ITerm) {
            Option out = this.model.evalToTerm((ITerm)formula);
            return out.isEmpty() ? null : (IExpression)out.get();
        }
        if (formula instanceof IFormula) {
            Option out = this.model.evalExpression(formula);
            return out.isEmpty() ? null : (IExpression)out.get();
        }
        throw new AssertionError((Object)("unexpected formula: " + formula));
    }
}

