/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.basicimpl.AbstractModel;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorAbstractProver;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

class BoolectorModel
extends AbstractModel.CachingAbstractModel<Long, Long, Long> {
    private final long btor;
    private final BoolectorAbstractProver<?> prover;
    private final BoolectorFormulaCreator bfCreator;
    private boolean closed = false;
    private final ImmutableList<Long> assertedTerms;

    BoolectorModel(long btor, BoolectorFormulaCreator creator, BoolectorAbstractProver<?> pProver, Collection<Long> assertedTerms) {
        super(creator);
        this.bfCreator = creator;
        this.btor = btor;
        this.prover = pProver;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    @Override
    protected ImmutableList<Model.ValueAssignment> toList() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        ImmutableList.Builder assignments = ImmutableList.builder();
        return assignments.build();
    }

    private ImmutableList<Model.ValueAssignment> toList1() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.prover.isClosed() ? 1 : 0) != 0, (Object)"cannot use model after prover is closed");
        ImmutableList.Builder assignments = ImmutableList.builder();
        for (Long formula : this.assertedTerms) {
            for (Map.Entry<String, Long> entry : this.creator.extractVariablesAndUFs(formula, true).entrySet()) {
                String name = entry.getKey();
                Long var = entry.getValue();
                if (BtorJNI.boolector_is_array(this.btor, var)) {
                    assignments.add((Object)this.getArrayAssignment(formula));
                    continue;
                }
                if (BtorJNI.boolector_is_uf(this.btor, var)) {
                    assignments.add((Object)this.getUFAssignment(formula));
                    continue;
                }
                assignments.add((Object)this.getConstAssignment(formula));
            }
        }
        return assignments.build();
    }

    private Model.ValueAssignment getConstAssignment(long key) {
        long valueNode;
        ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
        Object value = this.creator.convertValue(key, this.evalImpl(key));
        argumentInterpretation.add(value);
        if (value.equals(true)) {
            valueNode = BtorJNI.boolector_true(this.btor);
        } else if (value.equals(false)) {
            valueNode = BtorJNI.boolector_false(this.btor);
        } else {
            long sort = BtorJNI.boolector_bitvec_sort(this.btor, BtorJNI.boolector_get_width(this.btor, key));
            valueNode = BtorJNI.boolector_int(this.btor, (Long)value, sort);
        }
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(valueNode), this.creator.encapsulateBoolean(BtorJNI.boolector_eq(this.btor, key, valueNode)), this.bfCreator.getName(key), value, argumentInterpretation);
    }

    private Model.ValueAssignment getUFAssignment(long key) {
        ArrayList argumentInterpretation = new ArrayList();
        Long value = this.evalImpl(key);
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(value), this.creator.encapsulateBoolean(BtorJNI.boolector_eq(this.btor, key, value)), this.bfCreator.getName(key), this.creator.convertValue(key, value), argumentInterpretation);
    }

    private Model.ValueAssignment getArrayAssignment(long key) {
        ArrayList argumentInterpretation = new ArrayList();
        Long value = this.evalImpl(key);
        Object valueNode = null;
        return new Model.ValueAssignment(this.creator.encapsulateWithTypeOf(key), this.creator.encapsulateWithTypeOf(valueNode), this.creator.encapsulateBoolean(BtorJNI.boolector_eq(this.btor, key, value)), this.bfCreator.getName(key), this.creator.convertValue(key, value), argumentInterpretation);
    }

    @Override
    protected Long evalImpl(Long pFormula) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return pFormula;
    }
}

