/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.primitives.Longs;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

public class BoolectorBooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long btor;

    BoolectorBooleanFormulaManager(BoolectorFormulaCreator pCreator) {
        super(pCreator);
        this.btor = (Long)pCreator.getEnv();
    }

    @Override
    public Long makeVariableImpl(String varName) {
        long boolType = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(boolType, varName);
    }

    @Override
    public Long makeBooleanImpl(boolean pValue) {
        if (pValue) {
            return BtorJNI.boolector_true(this.btor);
        }
        return BtorJNI.boolector_false(this.btor);
    }

    @Override
    public Long not(Long pParam1) {
        return BtorJNI.boolector_not(this.btor, pParam1);
    }

    @Override
    public Long and(Long pParam1, Long pParam2) {
        return BtorJNI.boolector_and(this.btor, pParam1, pParam2);
    }

    @Override
    public Long or(Long pParam1, Long pParam2) {
        return BtorJNI.boolector_or(this.btor, pParam1, pParam2);
    }

    @Override
    public Long xor(Long pParam1, Long pParam2) {
        return BtorJNI.boolector_xor(this.btor, pParam1, pParam2);
    }

    @Override
    public Long equivalence(Long pBits1, Long pBits2) {
        return BtorJNI.boolector_iff(this.btor, pBits1, pBits2);
    }

    @Override
    public boolean isTrue(Long pBits) {
        return this.isConstant(pBits, 1);
    }

    @Override
    public boolean isFalse(Long pBits) {
        return this.isConstant(pBits, 0);
    }

    private boolean isConstant(long pBits, int constant) {
        String assignment;
        Long maybeLong;
        return BtorJNI.boolector_get_width(this.btor, pBits) == 1 && BtorJNI.boolector_is_const(this.btor, pBits) && (maybeLong = Longs.tryParse((String)(assignment = BtorJNI.boolector_get_bits(this.btor, pBits)))) != null && maybeLong == (long)constant;
    }

    @Override
    public Long ifThenElse(Long pCond, Long pF1, Long pF2) {
        return BtorJNI.boolector_cond(this.btor, pCond, pF1, pF2);
    }
}

