/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class Interpolation {
    private Interpolation() {
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.SMTINTERPOL;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             InterpolatingProverEnvironment<?> prover = context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            IntegerFormulaManager imgr = context.getFormulaManager().getIntegerFormulaManager();
            prover.push();
            Interpolation.interpolateExample(prover, imgr, logger);
            prover.pop();
            prover.push();
            Interpolation.interpolateProgramTrace(prover, imgr, logger);
            prover.pop();
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private static <T> void interpolateExample(InterpolatingProverEnvironment<T> prover, IntegerFormulaManager imgr, LogManager logger) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)imgr.makeVariable("y");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        Object ip0 = prover.addConstraint(imgr.greaterThan(x, y));
        Object ip1 = prover.addConstraint(imgr.equal(x, zero));
        Object ip2 = prover.addConstraint(imgr.greaterThan(y, zero));
        boolean unsat = prover.isUnsat();
        Preconditions.checkState((boolean)unsat, (Object)"the example for interpolation should be UNSAT");
        List<BooleanFormula> itps = prover.getSeqInterpolants0((List<T>)ImmutableList.of(ip0, ip1, ip2));
        logger.log(Level.INFO, new Object[]{"1a :: Interpolants for [{ip0},{ip1},{ip2}] are:", itps});
        ImmutableSet partition0 = ImmutableSet.of(ip0);
        ImmutableSet partition1 = ImmutableSet.of(ip1);
        ImmutableSet partition2 = ImmutableSet.of(ip2);
        itps = prover.getSeqInterpolants((List<Collection<T>>)ImmutableList.of((Object)partition0, (Object)partition1, (Object)partition2));
        logger.log(Level.INFO, new Object[]{"1b :: Interpolants for [{ip0},{ip1},{ip2}] are:", itps});
        ImmutableSet partition3 = ImmutableSet.of(ip0);
        ImmutableSet partition4 = ImmutableSet.of(ip1, ip2);
        itps = prover.getSeqInterpolants((List<Collection<T>>)ImmutableList.of((Object)partition3, (Object)partition4));
        logger.log(Level.INFO, new Object[]{"2a :: Interpolants for [{ip0},{ip1,ip2}] are:", itps});
        BooleanFormula itp = prover.getInterpolant((Collection<T>)ImmutableList.of(ip0));
        logger.log(Level.INFO, new Object[]{"2b :: Interpolants for [{ip0},{ip1,ip2}] are:", itp});
    }

    private static <T> void interpolateProgramTrace(InterpolatingProverEnvironment<T> prover, IntegerFormulaManager imgr, LogManager logger) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)imgr.makeVariable("i");
        NumeralFormula.IntegerFormula i1 = (NumeralFormula.IntegerFormula)imgr.makeVariable("i'");
        NumeralFormula.IntegerFormula j = (NumeralFormula.IntegerFormula)imgr.makeVariable("j");
        NumeralFormula.IntegerFormula k = (NumeralFormula.IntegerFormula)imgr.makeVariable("k");
        NumeralFormula.IntegerFormula k1 = (NumeralFormula.IntegerFormula)imgr.makeVariable("k'");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula fifty = (NumeralFormula.IntegerFormula)imgr.makeNumber(50L);
        ImmutableList programTrace = ImmutableList.of((Object)imgr.equal(i, zero), (Object)imgr.equal(k, j), (Object)imgr.lessThan(i, fifty), (Object)imgr.equal(i1, (NumeralFormula.IntegerFormula)imgr.add(i, one)), (Object)imgr.equal(k1, (NumeralFormula.IntegerFormula)imgr.add(k, one)), (Object)imgr.greaterOrEquals(i1, fifty), (Object)imgr.equal(j, zero), (Object)imgr.lessThan(k1, fifty));
        ArrayList handles = new ArrayList();
        for (BooleanFormula step : programTrace) {
            handles.add(prover.addConstraint(step));
        }
        boolean unsat = prover.isUnsat();
        Preconditions.checkState((boolean)unsat, (Object)"the example for interpolation should be UNSAT");
        List<BooleanFormula> itps = prover.getSeqInterpolants0(handles);
        logger.log(Level.INFO, new Object[]{"Interpolants for the program trace are:", itps});
    }
}

