/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;

public abstract class AbstractModel<TFormulaInfo, TType, TEnv>
implements Model {
    protected final FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator;

    protected AbstractModel(FormulaCreator<TFormulaInfo, TType, TEnv, ?> creator) {
        this.creator = creator;
    }

    @Override
    public <T extends Formula> @Nullable T eval(T f) {
        TFormulaInfo evaluation = this.evalImpl(this.creator.extractInfo(f));
        return (T)(evaluation == null ? null : this.creator.encapsulateWithTypeOf(evaluation));
    }

    @Override
    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula f) {
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula f) {
        return (Rational)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public @Nullable Boolean evaluate(BooleanFormula f) {
        return (Boolean)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public @Nullable BigInteger evaluate(BitvectorFormula f) {
        return (BigInteger)this.evaluateImpl(this.creator.extractInfo(f));
    }

    @Override
    public final @Nullable Object evaluate(Formula f) {
        Preconditions.checkArgument((!(f instanceof ArrayFormula) ? 1 : 0) != 0, (Object)"cannot compute a simple constant evaluation for an array-formula");
        return this.evaluateImpl(this.creator.extractInfo(f));
    }

    protected abstract @Nullable TFormulaInfo evalImpl(TFormulaInfo var1);

    protected @Nullable Object evaluateImpl(TFormulaInfo f) {
        TFormulaInfo evaluatedF = this.evalImpl(f);
        return evaluatedF == null ? null : this.creator.convertValue(f, evaluatedF);
    }

    @Override
    public String toString() {
        return Joiner.on((char)'\n').join(this.iterator());
    }

    public static abstract class CachingAbstractModel<TFormulaInfo, TType, TEnv>
    extends AbstractModel<TFormulaInfo, TType, TEnv> {
        private @Nullable ImmutableList<Model.ValueAssignment> modelAssignments = null;

        protected CachingAbstractModel(FormulaCreator<TFormulaInfo, TType, TEnv, ?> pCreator) {
            super(pCreator);
        }

        @Override
        public ImmutableList<Model.ValueAssignment> asList() {
            if (this.modelAssignments == null) {
                this.modelAssignments = this.toList();
            }
            return this.modelAssignments;
        }

        protected abstract ImmutableList<Model.ValueAssignment> toList();
    }
}

