/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.ExtendedRational;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FloatingPointFormulaManagerTest
extends SolverBasedTest0 {
    private static final int NUM_RANDOM_TESTS = 100;
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private FormulaType.FloatingPointType singlePrecType;
    private FormulaType.FloatingPointType doublePrecType;
    private FloatingPointFormula nan;
    private FloatingPointFormula posInf;
    private FloatingPointFormula negInf;
    private FloatingPointFormula zero;
    private FloatingPointFormula one;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.requireFloats();
        this.singlePrecType = FormulaType.getSinglePrecisionFloatingPointType();
        this.doublePrecType = FormulaType.getDoublePrecisionFloatingPointType();
        this.nan = this.fpmgr.makeNaN(this.singlePrecType);
        this.posInf = this.fpmgr.makePlusInfinity(this.singlePrecType);
        this.negInf = this.fpmgr.makeMinusInfinity(this.singlePrecType);
        this.zero = this.fpmgr.makeNumber(0.0, this.singlePrecType);
        this.one = this.fpmgr.makeNumber(1.0, this.singlePrecType);
    }

    @Test
    public void floatingPointType() {
        FormulaType.FloatingPointType type = FormulaType.getFloatingPointType(23, 42);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", type);
        FormulaType.FloatingPointType result = (FormulaType.FloatingPointType)this.mgr.getFormulaType(var);
        Truth.assertWithMessage((String)"exponent size").that(Integer.valueOf(result.getExponentSize())).isEqualTo((Object)type.getExponentSize());
        Truth.assertWithMessage((String)"mantissa size").that(Integer.valueOf(result.getMantissaSize())).isEqualTo((Object)type.getMantissaSize());
    }

    @Test
    public void negative() throws SolverException, InterruptedException {
        FloatingPointFormula formula;
        for (double d : new double[]{-1.0, -2.0, -0.0, Double.NEGATIVE_INFINITY}) {
            formula = this.fpmgr.makeNumber(d, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isTautological();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isUnsatisfiable();
        }
        for (double d : new double[]{1.0, 2.0, 0.0, Double.POSITIVE_INFINITY}) {
            formula = this.fpmgr.makeNumber(d, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isUnsatisfiable();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isTautological();
        }
    }

    @Test
    public void parser() throws SolverException, InterruptedException {
        FloatingPointFormula formula;
        for (String s : new String[]{"-1", "-Infinity", "-0", "-0.0", "-0.000"}) {
            formula = this.fpmgr.makeNumber(s, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isTautological();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isUnsatisfiable();
        }
        for (String s : new String[]{"1", "Infinity", "0", "0.0", "0.000"}) {
            formula = this.fpmgr.makeNumber(s, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isUnsatisfiable();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isTautological();
        }
        for (String s : new String[]{"+1", "+Infinity", "+0", "+0.0", "+0.000"}) {
            formula = this.fpmgr.makeNumber(s, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isUnsatisfiable();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isTautological();
        }
        for (String s : new String[]{"NaN", "-NaN", "+NaN"}) {
            formula = this.fpmgr.makeNumber(s, this.singlePrecType);
            this.assertThatFormula(this.fpmgr.isNegative(formula)).isUnsatisfiable();
            this.assertThatFormula(this.fpmgr.isNegative(this.fpmgr.negate(formula))).isUnsatisfiable();
        }
    }

    @Test
    public void negativeZeroDivision() throws SolverException, InterruptedException {
        BooleanFormula formula = this.fpmgr.equalWithFPSemantics(this.fpmgr.divide(this.one, this.fpmgr.makeNumber(-0.0, this.singlePrecType), FloatingPointRoundingMode.TOWARD_ZERO), this.fpmgr.makeMinusInfinity(this.singlePrecType));
        this.assertThatFormula(formula).isSatisfiable();
        this.assertThatFormula(this.bmgr.not(formula)).isUnsatisfiable();
    }

    @Test
    public void nanEqualNanIsUnsat() throws SolverException, InterruptedException {
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(this.nan, this.nan)).isUnsatisfiable();
    }

    @Test
    public void nanAssignedNanIsTrue() throws SolverException, InterruptedException {
        this.assertThatFormula(this.fpmgr.assignment(this.nan, this.nan)).isTautological();
    }

    @Test
    public void infinityOrdering() throws SolverException, InterruptedException {
        BooleanFormula order1 = this.fpmgr.greaterThan(this.posInf, this.zero);
        BooleanFormula order2 = this.fpmgr.greaterThan(this.zero, this.negInf);
        BooleanFormula order3 = this.fpmgr.greaterThan(this.posInf, this.negInf);
        this.assertThatFormula(this.bmgr.and(order1, order2, order3)).isTautological();
    }

    @Test
    public void infinityVariableOrdering() throws SolverException, InterruptedException {
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        BooleanFormula varIsNan = this.fpmgr.isNaN(var);
        BooleanFormula order1 = this.fpmgr.greaterOrEquals(this.posInf, var);
        BooleanFormula order2 = this.fpmgr.lessOrEquals(this.negInf, var);
        this.assertThatFormula(this.bmgr.or(varIsNan, this.bmgr.and(order1, order2))).isTautological();
    }

    @Test
    public void specialValueFunctions() throws SolverException, InterruptedException {
        this.assertThatFormula(this.fpmgr.isInfinity(this.posInf)).isTautological();
        this.assertThatFormula(this.fpmgr.isNormal(this.posInf)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isSubnormal(this.posInf)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isInfinity(this.negInf)).isTautological();
        this.assertThatFormula(this.fpmgr.isNormal(this.negInf)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isSubnormal(this.negInf)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isNaN(this.nan)).isTautological();
        this.assertThatFormula(this.fpmgr.isNormal(this.nan)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isSubnormal(this.nan)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isZero(this.zero)).isTautological();
        this.assertThatFormula(this.fpmgr.isSubnormal(this.zero)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isSubnormal(this.zero)).isUnsatisfiable();
        FloatingPointFormula negZero = this.fpmgr.makeNumber(-0.0, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.isZero(negZero)).isTautological();
        this.assertThatFormula(this.fpmgr.isSubnormal(negZero)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isSubnormal(negZero)).isUnsatisfiable();
        FloatingPointFormula minPosNormalValue = this.fpmgr.makeNumber(1.1754943508222875E-38, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.isSubnormal(minPosNormalValue)).isUnsatisfiable();
        this.assertThatFormula(this.fpmgr.isNormal(minPosNormalValue)).isSatisfiable();
        this.assertThatFormula(this.fpmgr.isZero(minPosNormalValue)).isUnsatisfiable();
    }

    @Test
    public void specialDoubles() throws SolverException, InterruptedException {
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.NaN, this.singlePrecType), this.nan)).isTautological();
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.POSITIVE_INFINITY, this.singlePrecType), this.posInf)).isTautological();
        this.assertThatFormula(this.fpmgr.assignment(this.fpmgr.makeNumber(Double.NEGATIVE_INFINITY, this.singlePrecType), this.negInf)).isTautological();
    }

    private void checkEqualityOfNumberConstantsFor(double value, FormulaType.FloatingPointType type) throws SolverException, InterruptedException {
        FloatingPointFormula doubleNumber = this.fpmgr.makeNumber(value, type);
        FloatingPointFormula stringNumber = this.fpmgr.makeNumber(Double.toString(value), type);
        FloatingPointFormula bigDecimalNumber = this.fpmgr.makeNumber(BigDecimal.valueOf(value), type);
        FloatingPointFormula rationalNumber = this.fpmgr.makeNumber(Rational.ofBigDecimal((BigDecimal)BigDecimal.valueOf(value)), type);
        BooleanFormula eq1 = this.fpmgr.equalWithFPSemantics(doubleNumber, stringNumber);
        BooleanFormula eq2 = this.fpmgr.equalWithFPSemantics(doubleNumber, bigDecimalNumber);
        BooleanFormula eq3 = this.fpmgr.equalWithFPSemantics(doubleNumber, rationalNumber);
        this.assertThatFormula(this.bmgr.and(eq1, eq2, eq3)).isTautological();
    }

    @Test
    public void numberConstants() throws SolverException, InterruptedException {
        this.checkEqualityOfNumberConstantsFor(1.0, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(-5.877471754111438E-39, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(-5.877471754111438E-39, this.doublePrecType);
        this.checkEqualityOfNumberConstantsFor(3.4028234663852886E38, this.singlePrecType);
        this.checkEqualityOfNumberConstantsFor(3.4028234663852886E38, this.doublePrecType);
        FormulaType.FloatingPointType nearDouble = FormulaType.getFloatingPointType(12, 52);
        FloatingPointFormula h1 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(309).multiply(BigDecimal.valueOf(1.0001)), nearDouble);
        FloatingPointFormula h2 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(309).multiply(BigDecimal.valueOf(1.0002)), nearDouble);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(h1, h2)).isUnsatisfiable();
        FormulaType.FloatingPointType smallType = FormulaType.getFloatingPointType(4, 4);
        FloatingPointFormula i1 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(50).multiply(BigDecimal.valueOf(1.001)), smallType);
        FloatingPointFormula i2 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(50).multiply(BigDecimal.valueOf(1.002)), smallType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(i1, i2)).isTautological();
        FormulaType.FloatingPointType smallType2 = FormulaType.getFloatingPointType(4, 4);
        FloatingPointFormula j1 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(500).multiply(BigDecimal.valueOf(1.001)), smallType2);
        FloatingPointFormula j2 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(500).multiply(BigDecimal.valueOf(1.002)), smallType2);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(j1, j2)).isTautological();
        if (!this.solver.equals((Object)SolverContextFactory.Solvers.Z3)) {
            FormulaType.FloatingPointType largeType = FormulaType.getFloatingPointType(100, 100);
            FloatingPointFormula k1 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(200).multiply(BigDecimal.valueOf(1.001)), largeType);
            FloatingPointFormula k2 = this.fpmgr.makeNumber(BigDecimal.TEN.pow(200).multiply(BigDecimal.valueOf(1.002)), largeType);
            this.assertThatFormula(this.fpmgr.equalWithFPSemantics(k1, k2)).isUnsatisfiable();
        }
    }

    @Test
    public void cast() throws SolverException, InterruptedException {
        FloatingPointFormula doublePrecNumber = this.fpmgr.makeNumber(1.5, this.doublePrecType);
        FloatingPointFormula singlePrecNumber = this.fpmgr.makeNumber(1.5, this.singlePrecType);
        FloatingPointFormula narrowedNumber = this.fpmgr.castTo(doublePrecNumber, this.singlePrecType);
        FloatingPointFormula widenedNumber = this.fpmgr.castTo(singlePrecNumber, this.doublePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(narrowedNumber, singlePrecNumber)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(widenedNumber, doublePrecNumber)).isTautological();
        FloatingPointFormula doublePrecSmallNumber = this.fpmgr.makeNumber(5.877471754111438E-39, this.doublePrecType);
        FloatingPointFormula singlePrecSmallNumber = this.fpmgr.makeNumber(5.877471754111438E-39, this.singlePrecType);
        FloatingPointFormula widenedSmallNumber = this.fpmgr.castTo(singlePrecSmallNumber, this.doublePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(widenedSmallNumber, doublePrecSmallNumber)).isTautological();
    }

    @Test
    public void bvToFpOne() throws SolverException, InterruptedException {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, 1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        FloatingPointFormula signedBvToFpOne = this.fpmgr.castFrom(bvOne, true, this.singlePrecType);
        FloatingPointFormula unsignedBvToFpOne = this.fpmgr.castFrom(bvOne, false, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, signedBvToFpOne)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, unsignedBvToFpOne)).isTautological();
    }

    private void round0(double value, double toZero, double pos, double neg, double tiesEven, double tiesAway) throws SolverException, InterruptedException {
        FloatingPointFormula f = this.fpmgr.makeNumber(value, this.singlePrecType);
        Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_ZERO))).isEqualTo((Object)this.singlePrecType);
        Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_POSITIVE))).isEqualTo((Object)this.singlePrecType);
        Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_NEGATIVE))).isEqualTo((Object)this.singlePrecType);
        Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.round(f, FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN))).isEqualTo((Object)this.singlePrecType);
        if (this.solver != SolverContextFactory.Solvers.MATHSAT5) {
            Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.round(f, FloatingPointRoundingMode.NEAREST_TIES_AWAY))).isEqualTo((Object)this.singlePrecType);
        }
        this.assertEquals(this.fpmgr.makeNumber(toZero, this.singlePrecType), this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_ZERO));
        this.assertEquals(this.fpmgr.makeNumber(pos, this.singlePrecType), this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_POSITIVE));
        this.assertEquals(this.fpmgr.makeNumber(neg, this.singlePrecType), this.fpmgr.round(f, FloatingPointRoundingMode.TOWARD_NEGATIVE));
        this.assertEquals(this.fpmgr.makeNumber(tiesEven, this.singlePrecType), this.fpmgr.round(f, FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN));
        if (this.solver != SolverContextFactory.Solvers.MATHSAT5) {
            this.assertEquals(this.fpmgr.makeNumber(tiesAway, this.singlePrecType), this.fpmgr.round(f, FloatingPointRoundingMode.NEAREST_TIES_AWAY));
        }
    }

    private void assertEquals(FloatingPointFormula f1, FloatingPointFormula f2) throws SolverException, InterruptedException {
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(f1, f2)).isTautological();
    }

    @Test
    public void round() throws SolverException, InterruptedException {
        this.round0(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.round0(1.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        this.round0(-1.0, -1.0, -1.0, -1.0, -1.0, -1.0);
        this.round0(1.1, 1.0, 2.0, 1.0, 1.0, 1.0);
        this.round0(1.5, 1.0, 2.0, 1.0, 2.0, 2.0);
        this.round0(1.9, 1.0, 2.0, 1.0, 2.0, 2.0);
        this.round0(10.1, 10.0, 11.0, 10.0, 10.0, 10.0);
        this.round0(10.5, 10.0, 11.0, 10.0, 10.0, 11.0);
        this.round0(10.9, 10.0, 11.0, 10.0, 11.0, 11.0);
        this.round0(-1.1, -1.0, -1.0, -2.0, -1.0, -1.0);
        this.round0(-1.5, -1.0, -1.0, -2.0, -2.0, -2.0);
        this.round0(-1.9, -1.0, -1.0, -2.0, -2.0, -2.0);
        this.round0(-10.1, -10.0, -10.0, -11.0, -10.0, -10.0);
        this.round0(-10.5, -10.0, -10.0, -11.0, -10.0, -11.0);
        this.round0(-10.9, -10.0, -10.0, -11.0, -11.0, -11.0);
    }

    @Test
    public void bvToFpMinusOne() throws SolverException, InterruptedException {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, -1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        FloatingPointFormula fpMinInt = this.fpmgr.makeNumber(Math.pow(2.0, 32.0) - 1.0, this.singlePrecType);
        FloatingPointFormula unsignedBvToFpOne = this.fpmgr.castFrom(bvOne, false, this.singlePrecType);
        FloatingPointFormula signedBvToFpOne = this.fpmgr.castFrom(bvOne, true, this.singlePrecType);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, signedBvToFpOne)).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpMinInt, unsignedBvToFpOne)).isTautological();
    }

    @Test
    public void fpToBvOne() throws SolverException, InterruptedException {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, 1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        BitvectorFormula fpToBvOne = this.fpmgr.castTo(fpOne, FormulaType.getBitvectorTypeWithSize(32));
        this.assertThatFormula(this.bvmgr.equal(bvOne, fpToBvOne)).isTautological();
    }

    @Test
    public void fpToBvMinusOne() throws SolverException, InterruptedException {
        this.requireBitvectors();
        BitvectorFormula bvOne = this.bvmgr.makeBitvector(32, -1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        BitvectorFormula fpToBvOne = this.fpmgr.castTo(fpOne, FormulaType.getBitvectorTypeWithSize(32));
        this.assertThatFormula(this.bvmgr.equal(bvOne, fpToBvOne)).isTautological();
    }

    @Test
    public void rationalToFpOne() throws SolverException, InterruptedException {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        FloatingPointFormula ratToFpOne = this.fpmgr.castFrom((Formula)ratOne, true, this.singlePrecType);
        FloatingPointFormula unsignedRatToFpOne = this.fpmgr.castFrom((Formula)ratOne, false, this.singlePrecType);
        Truth.assertThat((Object)unsignedRatToFpOne).isEqualTo((Object)ratToFpOne);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, ratToFpOne)).isSatisfiable();
    }

    @Test
    public void rationalToFpMinusOne() throws SolverException, InterruptedException {
        this.requireBitvectors();
        Object ratOne = this.rmgr.makeNumber(-1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        FloatingPointFormula ratToFpOne = this.fpmgr.castFrom((Formula)ratOne, true, this.singlePrecType);
        FloatingPointFormula unsignedRatToFpOne = this.fpmgr.castFrom((Formula)ratOne, false, this.singlePrecType);
        Truth.assertThat((Object)unsignedRatToFpOne).isEqualTo((Object)ratToFpOne);
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(fpOne, ratToFpOne)).isSatisfiable();
    }

    @Test
    public void fpToRationalOne() throws SolverException, InterruptedException {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(1.0, this.singlePrecType);
        NumeralFormula fpToRatOne = this.fpmgr.castTo(fpOne, FormulaType.RationalType);
        this.assertThatFormula(this.rmgr.equal(ratOne, fpToRatOne)).isSatisfiable();
    }

    @Test
    public void fpToRationalMinusOne() throws SolverException, InterruptedException {
        this.requireRationals();
        Object ratOne = this.rmgr.makeNumber(-1L);
        FloatingPointFormula fpOne = this.fpmgr.makeNumber(-1.0, this.singlePrecType);
        NumeralFormula fpToRatOne = this.fpmgr.castTo(fpOne, FormulaType.RationalType);
        this.assertThatFormula(this.rmgr.equal(ratOne, fpToRatOne)).isSatisfiable();
    }

    @Test
    public void fpTraversal() {
        Truth.assertThat(this.mgr.extractVariables(this.zero)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.zero)).isEmpty();
        Truth.assertThat(this.mgr.extractVariables(this.one)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.one)).isEmpty();
        Truth.assertThat(this.mgr.extractVariables(this.posInf)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.posInf)).isEmpty();
        Truth.assertThat(this.mgr.extractVariables(this.nan)).isEmpty();
        Truth.assertThat(this.mgr.extractVariablesAndUFs(this.nan)).isEmpty();
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        Truth.assertThat(this.mgr.extractVariables(var)).containsExactly((Object)"x", (Object)var, new Object[0]);
        Truth.assertThat(this.mgr.extractVariablesAndUFs(var)).containsExactly((Object)"x", (Object)var, new Object[0]);
    }

    @Test
    public void fpTraversalWithRoundingMode() {
        FloatingPointFormula two = this.fpmgr.makeNumber(2.0, this.singlePrecType);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        FloatingPointFormula mult = this.fpmgr.multiply(two, var);
        Truth.assertThat(this.mgr.extractVariables(mult)).containsExactly((Object)"x", (Object)var, new Object[0]);
        Truth.assertThat(this.mgr.extractVariablesAndUFs(mult)).containsExactly((Object)"x", (Object)var, new Object[0]);
    }

    @Test
    public void fpIeeeConversionTypes() {
        TruthJUnit.assume().withMessage("FP-BV conversion of Z3 misses sign bit").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
        FloatingPointFormula var = this.fpmgr.makeVariable("var", this.singlePrecType);
        Truth.assertThat(this.mgr.getFormulaType(this.fpmgr.toIeeeBitvector(var))).isEqualTo((Object)FormulaType.getBitvectorTypeWithSize(32));
    }

    @Test
    public void fpIeeeConversion() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("FP-BV conversion of Z3 misses sign bit").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
        FloatingPointFormula var = this.fpmgr.makeVariable("var", this.singlePrecType);
        this.assertThatFormula(this.fpmgr.assignment(var, this.fpmgr.fromIeeeBitvector(this.fpmgr.toIeeeBitvector(var), this.singlePrecType))).isTautological();
    }

    @Test
    public void ieeeFpConversion() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("FP-BV conversion of Z3 misses sign bit").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
        BitvectorFormula var = this.bvmgr.makeBitvector(32, 123456789L);
        this.assertThatFormula(this.bvmgr.equal(var, this.fpmgr.toIeeeBitvector(this.fpmgr.fromIeeeBitvector(var, this.singlePrecType)))).isTautological();
    }

    @Test
    public void checkIeeeFpConversion32() throws SolverException, InterruptedException {
        for (float f : this.getListOfFloats()) {
            this.checkFP(this.singlePrecType, this.bvmgr.makeBitvector(32, Float.floatToRawIntBits(f)), this.fpmgr.makeNumber(f, this.singlePrecType));
        }
    }

    @Test
    public void checkIeeeFpConversion64() throws SolverException, InterruptedException {
        for (double d : this.getListOfDoubles()) {
            this.checkFP(this.doublePrecType, this.bvmgr.makeBitvector(64, Double.doubleToRawLongBits(d)), this.fpmgr.makeNumber(d, this.doublePrecType));
        }
    }

    private List<Float> getListOfFloats() {
        ArrayList flts = Lists.newArrayList((Object[])new Float[]{Float.valueOf(Float.MIN_NORMAL), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(0.0f)});
        for (int i = 1; i < 20; ++i) {
            for (int j = 1; j < 20; ++j) {
                flts.add(Float.valueOf((float)((double)i * Math.pow(10.0, j))));
            }
        }
        Random rand = new Random(0L);
        for (int i = 0; i < 100; ++i) {
            float flt = Float.intBitsToFloat(rand.nextInt());
            if (Float.isNaN(flt)) continue;
            flts.add(Float.valueOf(flt));
        }
        return flts;
    }

    private List<Double> getListOfDoubles() {
        ArrayList dbls = Lists.newArrayList((Object[])new Double[]{Double.MIN_NORMAL, Double.MIN_VALUE, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0});
        for (int i = 1; i < 20; ++i) {
            for (int j = 1; j < 20; ++j) {
                dbls.add((double)i * Math.pow(10.0, j));
            }
        }
        Random rand = new Random(0L);
        for (int i = 0; i < 100; ++i) {
            double d = Double.longBitsToDouble(rand.nextLong());
            if (Double.isNaN(d)) continue;
            dbls.add(d);
        }
        return dbls;
    }

    private void checkFP(FormulaType.FloatingPointType type, BitvectorFormula bv, FloatingPointFormula flt) throws SolverException, InterruptedException {
        BitvectorFormula var = this.bvmgr.makeVariable(type.getTotalSize(), "x");
        Truth.assertThat(this.mgr.getFormulaType(var)).isEqualTo(this.mgr.getFormulaType(this.fpmgr.toIeeeBitvector(flt)));
        Truth.assertThat(this.mgr.getFormulaType(flt)).isEqualTo(this.mgr.getFormulaType(this.fpmgr.fromIeeeBitvector(bv, type)));
        this.assertThatFormula(this.bmgr.and(this.bvmgr.equal(bv, var), this.bvmgr.equal(var, this.fpmgr.toIeeeBitvector(flt)))).isSatisfiable();
        this.assertThatFormula(this.bvmgr.equal(bv, this.fpmgr.toIeeeBitvector(flt))).isTautological();
        this.assertThatFormula(this.fpmgr.equalWithFPSemantics(flt, this.fpmgr.fromIeeeBitvector(bv, type))).isTautological();
    }

    @Test
    public void fpModelValue() throws SolverException, InterruptedException {
        FloatingPointFormula zeroVar = this.fpmgr.makeVariable("zero", this.singlePrecType);
        BooleanFormula zeroEq = this.fpmgr.assignment(zeroVar, this.zero);
        FloatingPointFormula oneVar = this.fpmgr.makeVariable("one", this.singlePrecType);
        BooleanFormula oneEq = this.fpmgr.assignment(oneVar, this.one);
        FloatingPointFormula nanVar = this.fpmgr.makeVariable("nan", this.singlePrecType);
        BooleanFormula nanEq = this.fpmgr.assignment(nanVar, this.nan);
        FloatingPointFormula posInfVar = this.fpmgr.makeVariable("posInf", this.singlePrecType);
        BooleanFormula posInfEq = this.fpmgr.assignment(posInfVar, this.posInf);
        FloatingPointFormula negInfVar = this.fpmgr.makeVariable("negInf", this.singlePrecType);
        BooleanFormula negInfEq = this.fpmgr.assignment(negInfVar, this.negInf);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(zeroEq);
            prover.push(oneEq);
            prover.push(nanEq);
            prover.push(posInfEq);
            prover.push(negInfEq);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model model = prover.getModel();){
                Object zeroValue = model.evaluate(zeroVar);
                Model.ValueAssignment zeroAssignment = new Model.ValueAssignment(zeroVar, this.zero, zeroEq, "zero", zeroValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)zeroValue).isAnyOf((Object)ExtendedRational.ZERO, (Object)Rational.ZERO, new Object[]{BigDecimal.ZERO, 0.0, Float.valueOf(0.0f)});
                Object oneValue = model.evaluate(oneVar);
                Model.ValueAssignment oneAssignment = new Model.ValueAssignment(oneVar, this.one, oneEq, "one", oneValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)oneValue).isAnyOf((Object)new ExtendedRational(Rational.ONE), (Object)Rational.ONE, new Object[]{BigDecimal.ONE, 1.0, Float.valueOf(1.0f)});
                Object nanValue = model.evaluate(nanVar);
                Model.ValueAssignment nanAssignment = new Model.ValueAssignment(nanVar, this.nan, nanEq, "nan", nanValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)nanValue).isAnyOf((Object)ExtendedRational.NaN, (Object)Double.NaN, new Object[]{Float.valueOf(Float.NaN)});
                Object posInfValue = model.evaluate(posInfVar);
                Model.ValueAssignment posInfAssignment = new Model.ValueAssignment(posInfVar, this.posInf, posInfEq, "posInf", posInfValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)posInfValue).isAnyOf((Object)ExtendedRational.INFTY, (Object)Double.POSITIVE_INFINITY, new Object[]{Float.valueOf(Float.POSITIVE_INFINITY)});
                Object negInfValue = model.evaluate(negInfVar);
                Model.ValueAssignment negInfAssignment = new Model.ValueAssignment(negInfVar, this.negInf, negInfEq, "negInf", negInfValue, (Collection<?>)ImmutableList.of());
                Truth.assertThat((Object)negInfValue).isAnyOf((Object)ExtendedRational.NEG_INFTY, (Object)Double.NEGATIVE_INFINITY, new Object[]{Float.valueOf(Float.NEGATIVE_INFINITY)});
                Truth.assertThat((Iterable)model).containsExactly(new Object[]{zeroAssignment, oneAssignment, nanAssignment, posInfAssignment, negInfAssignment});
            }
        }
    }

    @Test
    public void fpInterpolation() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("MathSAT5 does not support floating-point interpolation").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        FloatingPointFormula var = this.fpmgr.makeVariable("x", this.singlePrecType);
        BooleanFormula f1 = this.fpmgr.equalWithFPSemantics(var, this.zero);
        BooleanFormula f2 = this.bmgr.not(this.fpmgr.isZero(var));
        try (InterpolatingProverEnvironment<?> prover = this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);){
            Object itpGroup1 = prover.push(f1);
            prover.push(f2);
            ProverEnvironmentSubject.assertThat(prover).isUnsatisfiable();
            BooleanFormula itp = prover.getInterpolant((Collection<?>)ImmutableList.of(itpGroup1));
            this.assertThatFormula(f1).implies(itp);
            this.assertThatFormula(this.bmgr.and(itp, f2)).isUnsatisfiable();
        }
    }
}

