/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.SimpleSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class BooleanFormulaSubject
extends Subject {
    private final SolverContext context;
    private final BooleanFormula formulaUnderTest;

    private BooleanFormulaSubject(FailureMetadata pMetadata, BooleanFormula pFormula, SolverContext pMgr) {
        super(pMetadata, (Object)pFormula);
        this.context = (SolverContext)Preconditions.checkNotNull((Object)pMgr);
        this.formulaUnderTest = (BooleanFormula)Preconditions.checkNotNull((Object)pFormula);
    }

    public static Subject.Factory<BooleanFormulaSubject, BooleanFormula> booleanFormulasOf(SolverContext context) {
        return (metadata, formula) -> new BooleanFormulaSubject(metadata, (BooleanFormula)formula, context);
    }

    public static SimpleSubjectBuilder<BooleanFormulaSubject, BooleanFormula> assertUsing(SolverContext context) {
        return Truth.assert_().about(BooleanFormulaSubject.booleanFormulasOf(context));
    }

    private void checkIsUnsat(BooleanFormula subject, Fact expected) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(subject);
            if (prover.isUnsat()) {
                return;
            }
            try (Model model = prover.getModel();){
                ArrayList<Fact> facts = new ArrayList<Fact>();
                facts.add(Fact.fact((String)"but was", (Object)this.formulaUnderTest));
                if (!subject.equals(this.formulaUnderTest)) {
                    facts.add(Fact.fact((String)"checked formula was", (Object)subject));
                }
                facts.add(Fact.fact((String)"which has model", (Object)model));
                this.failWithoutActual(expected, facts.toArray(new Fact[0]));
            }
        }
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isTrue(this.formulaUnderTest)) {
            this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"unsatisfiable"), new Fact[]{Fact.fact((String)"but was", (Object)"trivially satisfiable")});
            return;
        }
        this.checkIsUnsat(this.formulaUnderTest, Fact.simpleFact((String)"expected to be unsatisfiable"));
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        this.isSatisfiable(false);
    }

    public void isSatisfiable(boolean generateModel) throws SolverException, InterruptedException {
        Throwable throwable;
        ProverEnvironment prover;
        BooleanFormulaManager bmgr;
        block27: {
            bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
            if (bmgr.isFalse(this.formulaUnderTest)) {
                this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[]{Fact.fact((String)"but was", (Object)"trivially unsatisfiable")});
                return;
            }
            prover = generateModel ? this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS) : this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);
            throwable = null;
            try {
                prover.push(this.formulaUnderTest);
                if (prover.isUnsat()) break block27;
                if (generateModel) {
                    try (ImmutableList<Model.ValueAssignment> m = prover.getModel();){
                        for (Model.ValueAssignment valueAssignment : m) {
                        }
                    }
                    m = prover.getModelAssignments();
                }
                return;
            }
            catch (Throwable m) {
                throwable = m;
                throw m;
            }
            finally {
                if (prover != null) {
                    BooleanFormulaSubject.$closeResource(throwable, prover);
                }
            }
        }
        try {
            prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);
            throwable = null;
            try {
                for (BooleanFormula part : bmgr.toConjunctionArgs(this.formulaUnderTest, true)) {
                    prover.push(part);
                }
                if (!prover.isUnsat()) {
                    throw new AssertionError((Object)"repated satisfiability check returned different result");
                }
                List<BooleanFormula> unsatCore = prover.getUnsatCore();
                if (unsatCore.isEmpty() || unsatCore.size() == 1 && this.formulaUnderTest.equals(unsatCore.get(0))) {
                    this.failWithActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[0]);
                } else {
                    this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[]{Fact.fact((String)"but was", (Object)this.formulaUnderTest), Fact.fact((String)"which has unsat core", (Object)Joiner.on((char)'\n').join(unsatCore))});
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (prover != null) {
                    BooleanFormulaSubject.$closeResource(throwable, prover);
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            this.failWithActual(Fact.fact((String)"expected to be", (Object)"satisfiable"), new Fact[0]);
        }
    }

    public void isTautological() throws SolverException, InterruptedException {
        if (this.context.getFormulaManager().getBooleanFormulaManager().isFalse(this.formulaUnderTest)) {
            this.failWithoutActual(Fact.fact((String)"expected to be", (Object)"tautological"), new Fact[]{Fact.fact((String)"but was", (Object)"trivially unsatisfiable")});
            return;
        }
        this.checkIsUnsat(this.context.getFormulaManager().getBooleanFormulaManager().not(this.formulaUnderTest), Fact.fact((String)"expected to be", (Object)"tautological"));
    }

    public void isEquivalentTo(BooleanFormula expected) throws SolverException, InterruptedException {
        if (this.formulaUnderTest.equals(expected)) {
            return;
        }
        BooleanFormula f = this.context.getFormulaManager().getBooleanFormulaManager().xor(this.formulaUnderTest, expected);
        this.checkIsUnsat(f, Fact.fact((String)"expected to be equivalent to", (Object)expected));
    }

    public void isEquisatisfiableTo(BooleanFormula other) throws SolverException, InterruptedException {
        BooleanFormulaManager bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.checkIsUnsat(bfmgr.and(this.formulaUnderTest, bfmgr.not(other)), Fact.fact((String)"expected to be equisatisfiable with", (Object)other));
    }

    public void implies(BooleanFormula expected) throws SolverException, InterruptedException {
        if (this.formulaUnderTest.equals(expected)) {
            return;
        }
        BooleanFormulaManager bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        BooleanFormula implication = bmgr.or(bmgr.not(this.formulaUnderTest), expected);
        this.checkIsUnsat(bmgr.not(implication), Fact.fact((String)"expected to imply", (Object)expected));
    }
}

