/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.microsoft.z3.Native;
import com.microsoft.z3.Z3Exception;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;
import org.sosy_lab.java_smt.solvers.z3.Z3IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3UFManager;

final class Z3FormulaManager
extends AbstractFormulaManager<Long, Long, Long, Long> {
    private final Z3FormulaCreator formulaCreator;

    Z3FormulaManager(Z3FormulaCreator pFormulaCreator, Z3UFManager pFunctionManager, Z3BooleanFormulaManager pBooleanManager, Z3IntegerFormulaManager pIntegerManager, Z3RationalFormulaManager pRationalManager, Z3BitvectorFormulaManager pBitpreciseManager, Z3FloatingPointFormulaManager pFloatingPointManager, Z3QuantifiedFormulaManager pQuantifiedManager, Z3ArrayFormulaManager pArrayManager) {
        super(pFormulaCreator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, pFloatingPointManager, pQuantifiedManager, pArrayManager);
        this.formulaCreator = pFormulaCreator;
    }

    @Override
    public BooleanFormula parse(String str) throws IllegalArgumentException {
        long[] sortSymbols = new long[]{};
        long[] sorts = new long[]{};
        long[] declSymbols = new long[]{};
        long[] decls = new long[]{};
        long e = Native.parseSmtlib2String((long)((Long)this.getEnvironment()), (String)str, (int)sorts.length, (long[])sortSymbols, (long[])sorts, (int)declSymbols.length, (long[])declSymbols, (long[])decls);
        return this.getFormulaCreator().encapsulateBoolean(e);
    }

    @Override
    protected BooleanFormula applyQELightImpl(BooleanFormula pF) throws InterruptedException {
        return this.applyTacticImpl(pF, "qe-light");
    }

    @Override
    protected BooleanFormula applyCNFImpl(BooleanFormula pF) throws InterruptedException {
        return this.applyTacticImpl(pF, "tseitin-cnf");
    }

    @Override
    protected BooleanFormula applyNNFImpl(BooleanFormula pF) throws InterruptedException {
        return this.applyTacticImpl(pF, "nnf");
    }

    private BooleanFormula applyTacticImpl(BooleanFormula pF, String tacticName) throws InterruptedException {
        long out = this.formulaCreator.applyTactic((Long)this.getFormulaCreator().getEnv(), (Long)this.extractInfo(pF), tacticName);
        return this.formulaCreator.encapsulateBoolean(out);
    }

    @Override
    public Appender dumpFormula(final Long expr) {
        assert (this.getFormulaCreator().getFormulaType(expr) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return Appenders.fromToStringMethod((Object)new Object(){

            public String toString() {
                long z3solver = Native.mkSolver((long)((Long)Z3FormulaManager.this.getEnvironment()));
                Native.solverIncRef((long)((Long)Z3FormulaManager.this.getEnvironment()), (long)z3solver);
                Native.solverAssert((long)((Long)Z3FormulaManager.this.getEnvironment()), (long)z3solver, (long)expr);
                String serialized = Native.solverToString((long)((Long)Z3FormulaManager.this.getEnvironment()), (long)z3solver);
                Native.solverDecRef((long)((Long)Z3FormulaManager.this.getEnvironment()), (long)z3solver);
                return serialized;
            }
        });
    }

    @Override
    protected Long simplify(Long pF) throws InterruptedException {
        try {
            return Native.simplify((long)((Long)this.getFormulaCreator().getEnv()), (long)pF);
        }
        catch (Z3Exception exp) {
            throw this.formulaCreator.handleZ3Exception(exp);
        }
    }

    @Override
    public <T extends Formula> T substitute(T f, Map<? extends Formula, ? extends Formula> fromToMapping) {
        long[] changeFrom = new long[fromToMapping.size()];
        long[] changeTo = new long[fromToMapping.size()];
        int idx = 0;
        for (Map.Entry<? extends Formula, ? extends Formula> e : fromToMapping.entrySet()) {
            changeFrom[idx] = (Long)this.extractInfo(e.getKey());
            changeTo[idx] = (Long)this.extractInfo(e.getValue());
            ++idx;
        }
        FormulaType<T> type = this.getFormulaType(f);
        return this.getFormulaCreator().encapsulate(type, Native.substitute((long)((Long)this.getFormulaCreator().getEnv()), (long)((Long)this.extractInfo(f)), (int)fromToMapping.size(), (long[])changeFrom, (long[])changeTo));
    }

    @Override
    public BooleanFormula translateFrom(BooleanFormula other, FormulaManager otherManager) {
        if (otherManager instanceof Z3FormulaManager) {
            Z3FormulaManager o = (Z3FormulaManager)otherManager;
            long otherZ3Context = (Long)o.getEnvironment();
            if (otherZ3Context == (Long)this.getEnvironment()) {
                return other;
            }
            long translatedAST = Native.translate((long)otherZ3Context, (long)((Long)this.extractInfo(other)), (long)((Long)this.getEnvironment()));
            return this.getFormulaCreator().encapsulateBoolean(translatedAST);
        }
        return super.translateFrom(other, otherManager);
    }
}

