/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolModel;

abstract class SmtInterpolAbstractProver<T, AF>
extends AbstractProver<T> {
    private boolean closed = false;
    protected final SmtInterpolEnvironment env;
    protected final FormulaCreator<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> creator;
    protected final SmtInterpolFormulaManager mgr;
    protected final Deque<List<AF>> assertedFormulas = new ArrayDeque<List<AF>>();
    protected final Map<String, Term> annotatedTerms = new HashMap<String, Term>();
    private static final String PREFIX = "term_";
    private static final UniqueIdGenerator termIdGenerator = new UniqueIdGenerator();

    SmtInterpolAbstractProver(SmtInterpolFormulaManager pMgr, Set<SolverContext.ProverOptions> options) {
        super(options);
        Preconditions.checkState((((SmtInterpolEnvironment)pMgr.getEnvironment()).getStackDepth() == 0 ? 1 : 0) != 0, (Object)"Not allowed to create a new prover environment while solver stack is still non-empty, parallel stacks are not supported.");
        this.mgr = pMgr;
        this.env = pMgr.createEnvironment();
        this.creator = pMgr.getFormulaCreator();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.push(new ArrayList());
        this.env.push(1);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.pop();
        this.env.pop(1);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !this.env.checkSat();
    }

    @Override
    public SmtInterpolModel getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return new SmtInterpolModel(this.env.getModel(), this.creator);
    }

    protected static String generateTermName() {
        return PREFIX + termIdGenerator.getFreshId();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        return this.getUnsatCore0();
    }

    private List<BooleanFormula> getUnsatCore0() {
        return Collections3.transformedImmutableListCopy((Object[])this.env.getUnsatCore(), input -> this.creator.encapsulateBoolean(this.annotatedTerms.get(input.toString())));
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws InterruptedException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateUnsatCoresOverAssumptions();
        this.push();
        Preconditions.checkState((boolean)this.annotatedTerms.isEmpty(), (String)"Empty environment required for UNSAT core over assumptions: %s", this.annotatedTerms);
        for (BooleanFormula assumption : assumptions) {
            String termName = SmtInterpolAbstractProver.generateTermName();
            Term t = (Term)this.mgr.extractInfo(assumption);
            Term annotated = this.env.annotate(t, new Annotation(":named", (Object)termName));
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        }
        if (!this.isUnsat()) {
            return Optional.empty();
        }
        List<BooleanFormula> out = this.getUnsatCore0();
        this.pop();
        return Optional.of(out);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedFormulas.clear();
        this.annotatedTerms.clear();
        this.env.pop(this.env.getStackDepth());
        this.closed = true;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Assumption-solving is not supported.");
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        this.checkGenerateAllSat();
        Term[] importantTerms = new Term[important.size()];
        int i = 0;
        for (BooleanFormula booleanFormula : important) {
            importantTerms[i++] = (Term)this.mgr.extractInfo(booleanFormula);
        }
        for (Object[] objectArray : this.env.checkAllSat(importantTerms)) {
            callback.apply((List<BooleanFormula>)Collections3.transformedImmutableListCopy((Object[])objectArray, this.creator::encapsulateBoolean));
        }
        return callback.getResult();
    }
}

