/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

abstract class Mathsat5NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Long, Long, Long, ParamFormulaType, ResultFormulaType, Long> {
    final long mathsatEnv;

    Mathsat5NumeralFormulaManager(Mathsat5FormulaCreator pCreator, AbstractNumeralFormulaManager.NonLinearArithmetic pNonLinearArithmetic) {
        super(pCreator, pNonLinearArithmetic);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    @Override
    protected boolean isNumeral(Long val) {
        return Mathsat5NativeApi.msat_term_is_number(this.mathsatEnv, val);
    }

    @Override
    public Long makeNumberImpl(long pNumber) {
        int i = (int)pNumber;
        if ((long)i == pNumber) {
            return Mathsat5NativeApi.msat_make_int_number(this.mathsatEnv, i);
        }
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, Long.toString(pNumber));
    }

    @Override
    public Long makeNumberImpl(BigInteger pI) {
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, pI.toString());
    }

    @Override
    public Long makeNumberImpl(String pI) {
        return Mathsat5NativeApi.msat_make_number(this.mathsatEnv, pI);
    }

    protected abstract long getNumeralType();

    @Override
    public Long makeVariableImpl(String var) {
        return (Long)this.getFormulaCreator().makeVariable(this.getNumeralType(), var);
    }

    @Override
    public Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_times(this.mathsatEnv, pNumber, Mathsat5NativeApi.msat_make_number(this.mathsatEnv, "-1"));
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_plus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_plus(this.mathsatEnv, pNumber1, this.negate(pNumber2));
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_times(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long distinctImpl(List<Long> pNumbers) {
        long r = Mathsat5NativeApi.msat_make_true(this.mathsatEnv);
        for (int i = 0; i < pNumbers.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                r = Mathsat5NativeApi.msat_make_and(this.mathsatEnv, r, this.makeNot(this.equal(pNumbers.get(i), pNumbers.get(j))));
            }
        }
        return r;
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return this.makeNot(this.lessOrEquals(pNumber1, pNumber2));
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return this.lessOrEquals(pNumber2, pNumber1);
    }

    private long makeNot(long n) {
        return Mathsat5NativeApi.msat_make_not(this.mathsatEnv, n);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return this.makeNot(this.lessOrEquals(pNumber2, pNumber1));
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_leq(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    protected Long floor(Long pNumber) {
        return Mathsat5NativeApi.msat_make_floor(this.mathsatEnv, pNumber);
    }
}

