/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class Sudoku {
    private static final int SIZE = 9;
    private static final int BLOCKSIZE = 3;
    private static final Integer[][] UNSOLVABLE_SUDOKU = new Integer[0][0];
    private final SolverContext context;
    private final BooleanFormulaManager bmgr;
    private final IntegerFormulaManager imgr;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException, IOException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.MATHSAT5;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
            Integer[][] grid = Sudoku.readGridFromStdin();
            Sudoku sudoku = new Sudoku(context);
            Integer[][] solution = sudoku.solve(grid);
            if (solution == UNSOLVABLE_SUDOKU) {
                System.out.println("Sudoku has no solution.");
            } else {
                System.out.println("Sudoku has a solution:");
                for (Object[] objectArray : solution) {
                    System.out.println(Joiner.on((String)"").join(objectArray));
                }
            }
        }
    }

    private static Integer[][] readGridFromStdin() {
        Integer[][] grid = new Integer[9][9];
        System.out.println("Insert Sudoku:");
        Scanner s = new Scanner(System.in, Charset.defaultCharset().name());
        for (int row = 0; row < 9; ++row) {
            String line = s.nextLine().trim();
            for (int col = 0; col < Math.min(line.length(), 9); ++col) {
                char nextNumber = line.charAt(col);
                if ('0' > nextNumber || nextNumber > '9') continue;
                grid[row][col] = nextNumber - 48;
            }
        }
        return grid;
    }

    public Sudoku(SolverContext pContext) {
        this.context = pContext;
        this.bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
        this.imgr = this.context.getFormulaManager().getIntegerFormulaManager();
    }

    @Nullable
    private Integer[][] solve(Integer[][] grid) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula[][] symbols = this.getSymbols();
        List<BooleanFormula> rules = this.getRules(symbols);
        List<BooleanFormula> assignments = this.getAssignments(symbols, grid);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.bmgr.and(rules));
            prover.push(this.bmgr.and(assignments));
            boolean isUnsolvable = prover.isUnsat();
            if (isUnsolvable) {
                Integer[][] integerArray = UNSOLVABLE_SUDOKU;
                return integerArray;
            }
            Integer[][] solution = new Integer[9][9];
            try (Model model = prover.getModel();){
                for (int row = 0; row < 9; ++row) {
                    for (int col = 0; col < 9; ++col) {
                        solution[row][col] = model.evaluate(symbols[row][col]).intValue();
                    }
                }
            }
            Integer[][] integerArray = solution;
            return integerArray;
        }
    }

    private NumeralFormula.IntegerFormula[][] getSymbols() {
        NumeralFormula.IntegerFormula[][] symbols = new NumeralFormula.IntegerFormula[9][9];
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                symbols[row][col] = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x_" + row + "_" + col);
            }
        }
        return symbols;
    }

    private List<BooleanFormula> getRules(NumeralFormula.IntegerFormula[][] symbols) {
        int row;
        ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula nine = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(9L);
        for (row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                for (int i = 0; i < 9; ++i) {
                    rules.add(this.imgr.lessOrEquals(one, symbols[row][col]));
                    rules.add(this.imgr.lessOrEquals(symbols[row][col], nine));
                }
            }
        }
        for (row = 0; row < 9; ++row) {
            ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
            for (int col = 0; col < 9; ++col) {
                lst.add(symbols[row][col]);
            }
            rules.add(this.imgr.distinct(lst));
        }
        for (int col = 0; col < 9; ++col) {
            ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
            for (int row2 = 0; row2 < 9; ++row2) {
                lst.add(symbols[row2][col]);
            }
            rules.add(this.imgr.distinct(lst));
        }
        for (int rowB = 0; rowB < 9; rowB += 3) {
            for (int colB = 0; colB < 9; colB += 3) {
                ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int row3 = rowB; row3 < rowB + 3; ++row3) {
                    for (int col = colB; col < colB + 3; ++col) {
                        lst.add(symbols[row3][col]);
                    }
                }
                rules.add(this.imgr.distinct(lst));
            }
        }
        return rules;
    }

    private List<BooleanFormula> getAssignments(NumeralFormula.IntegerFormula[][] symbols, Integer[][] grid) {
        ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                Integer value = grid[row][col];
                if (value == null) continue;
                assignments.add(this.imgr.equal(symbols[row][col], (NumeralFormula.IntegerFormula)this.imgr.makeNumber(value.intValue())));
            }
        }
        return assignments;
    }
}

