/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProver;

public abstract class AbstractProverWithAllSat<T>
extends AbstractProver<T> {
    private final ShutdownNotifier shutdownNotifier;
    private final BooleanFormulaManager bmgr;
    protected boolean closed;

    protected AbstractProverWithAllSat(Set<SolverContext.ProverOptions> pOptions, BooleanFormulaManager pBmgr, ShutdownNotifier pShutdownNotifier) {
        super(pOptions);
        this.bmgr = pBmgr;
        this.shutdownNotifier = pShutdownNotifier;
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateAllSat();
        this.push();
        while (!this.isUnsat()) {
            this.shutdownNotifier.shutdownIfNecessary();
            ArrayList<BooleanFormula> valuesOfModel = new ArrayList<BooleanFormula>(important.size());
            try (Model model = this.getModelWithoutChecks();){
                for (BooleanFormula formula : important) {
                    Boolean value = model.evaluate(formula);
                    if (value == null) continue;
                    if (value.booleanValue()) {
                        valuesOfModel.add(formula);
                        continue;
                    }
                    valuesOfModel.add(this.bmgr.not(formula));
                }
            }
            callback.apply(valuesOfModel);
            this.shutdownNotifier.shutdownIfNecessary();
            BooleanFormula negatedModel = this.bmgr.not(this.bmgr.and(valuesOfModel));
            this.addConstraint(negatedModel);
            this.shutdownNotifier.shutdownIfNecessary();
        }
        this.pop();
        return callback.getResult();
    }

    protected abstract Model getModelWithoutChecks();
}

