/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5Formula;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5UFManager;

final class Mathsat5FormulaManager
extends AbstractFormulaManager<Long, Long, Long, Long> {
    Mathsat5FormulaManager(Mathsat5FormulaCreator creator, Mathsat5UFManager pFunctionManager, Mathsat5BooleanFormulaManager pBooleanManager, Mathsat5IntegerFormulaManager pIntegerManager, Mathsat5RationalFormulaManager pRationalManager, Mathsat5BitvectorFormulaManager pBitpreciseManager, Mathsat5FloatingPointFormulaManager pFloatingPointManager, Mathsat5ArrayFormulaManager pArrayManager) {
        super(creator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, pFloatingPointManager, null, pArrayManager);
    }

    static long getMsatTerm(Formula pT) {
        return ((Mathsat5Formula)pT).getTerm();
    }

    static long[] getMsatTerm(Collection<? extends Formula> pFormulas) {
        return Longs.toArray((Collection)Collections2.transform(pFormulas, Mathsat5FormulaManager::getMsatTerm));
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        long f = Mathsat5NativeApi.msat_from_smtlib2((Long)this.getEnvironment(), pS);
        return this.getFormulaCreator().encapsulateBoolean(f);
    }

    @Override
    public Appender dumpFormula(final Long f) {
        assert (this.getFormulaCreator().getFormulaType(f) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                String msatString = Mathsat5NativeApi.msat_to_smtlib2((Long)Mathsat5FormulaManager.this.getEnvironment(), f);
                boolean needsLinebreak = true;
                for (String part : Splitter.on((char)'\n').split((CharSequence)msatString)) {
                    out.append(part);
                    if (needsLinebreak && part.startsWith("(assert")) {
                        needsLinebreak = false;
                    }
                    if (!needsLinebreak) continue;
                    out.append('\n');
                }
            }
        };
    }

    @Override
    public <T extends Formula> T substitute(T f, Map<? extends Formula, ? extends Formula> fromToMapping) {
        long[] changeFrom = new long[fromToMapping.size()];
        long[] changeTo = new long[fromToMapping.size()];
        int idx = 0;
        for (Map.Entry<? extends Formula, ? extends Formula> e : fromToMapping.entrySet()) {
            changeFrom[idx] = (Long)this.extractInfo(e.getKey());
            changeTo[idx] = (Long)this.extractInfo(e.getValue());
            ++idx;
        }
        FormulaType<T> type = this.getFormulaType(f);
        return this.getFormulaCreator().encapsulate(type, Mathsat5NativeApi.msat_apply_substitution((Long)this.getFormulaCreator().getEnv(), (Long)this.extractInfo(f), fromToMapping.size(), changeFrom, changeTo));
    }
}

