/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.visitors.ExpectedFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class UFManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testDeclareAndCallUF() {
        ImmutableList names = ImmutableList.of((Object)"Func", (Object)"|Func|", (Object)"(Func)");
        for (String name : names) {
            NumeralFormula.IntegerFormula f;
            try {
                f = this.fmgr.declareAndCallUF(name, FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeNumber(1L)));
            }
            catch (RuntimeException e) {
                if (name.equals("|Func|")) {
                    throw new AssumptionViolatedException("unsupported UF name", (Throwable)e);
                }
                throw e;
            }
            FunctionDeclaration<?> declaration = this.getDeclaration(f);
            Truth.assertThat((String)declaration.getName()).isEqualTo((Object)name);
            Object f2 = this.mgr.makeApplication(declaration, new Formula[]{this.imgr.makeNumber(1L)});
            Truth.assertThat(f2).isEqualTo((Object)f);
        }
    }

    private FunctionDeclaration<?> getDeclaration(Formula pFormula) {
        return (FunctionDeclaration)this.mgr.visit(pFormula, new ExpectedFormulaVisitor<FunctionDeclaration<?>>(){

            @Override
            public FunctionDeclaration<?> visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                return functionDeclaration;
            }
        });
    }
}

