/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import java.math.BigInteger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class OptimizationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() {
        return super.createTestConfigBuilder().setOption("solver.mathsat5.loadOptimathsat5", "true");
    }

    @Before
    public void skipUnsupportedSolvers() {
        this.requireOptimization();
    }

    @Test
    public void testUnbounded() throws SolverException, InterruptedException {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("obj");
            prover.addConstraint(this.bmgr.and(this.rmgr.greaterOrEquals(x, this.rmgr.makeNumber("10")), this.rmgr.equal(x, obj)));
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).isEmpty();
        }
    }

    @Test
    public void testUnfeasible() throws SolverException, InterruptedException {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("y");
            prover.addConstraint(this.bmgr.and(this.rmgr.lessThan(x, y), this.rmgr.greaterThan(x, y)));
            prover.maximize(x);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.UNSAT);
        }
    }

    @Test
    public void testOptimal() throws SolverException, InterruptedException {
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula obj = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("obj");
            prover.addConstraint(this.bmgr.and(this.imgr.lessOrEquals(x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), this.imgr.lessOrEquals(y, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(15L)), this.imgr.equal(obj, (NumeralFormula.IntegerFormula)this.imgr.add(x, y)), this.imgr.greaterOrEquals((NumeralFormula.IntegerFormula)this.imgr.subtract(x, y), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))));
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"19"));
            try (Model model = prover.getModel();){
                BigInteger xValue = model.evaluate(x);
                BigInteger objValue = model.evaluate(obj);
                BigInteger yValue = model.evaluate(y);
                Truth.assertThat((Comparable)objValue).isEqualTo((Object)BigInteger.valueOf(19L));
                Truth.assertThat((Comparable)xValue).isEqualTo((Object)BigInteger.valueOf(10L));
                Truth.assertThat((Comparable)yValue).isEqualTo((Object)BigInteger.valueOf(9L));
            }
        }
    }

    @Test
    public void testSwitchingObjectives() throws SolverException, InterruptedException {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            NumeralFormula.RationalFormula y = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("y");
            NumeralFormula.RationalFormula obj = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("obj");
            prover.push();
            prover.addConstraint(this.bmgr.and(this.rmgr.lessOrEquals(x, this.rmgr.makeNumber(10L)), this.rmgr.lessOrEquals(y, this.rmgr.makeNumber(15L)), this.rmgr.equal(obj, this.rmgr.add(x, y)), this.rmgr.greaterOrEquals(this.rmgr.subtract(x, y), this.rmgr.makeNumber(1L))));
            prover.push();
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"19"));
            prover.pop();
            prover.push();
            handle = prover.maximize(x);
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"10"));
            prover.pop();
            prover.push();
            handle = prover.maximize((Formula)this.rmgr.makeVariable("y"));
            response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"9"));
            prover.pop();
        }
    }

    @Test
    public void testStrictConstraint() throws SolverException, InterruptedException {
        this.requireRationals();
        try (OptimizationProverEnvironment prover = this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]);){
            NumeralFormula.RationalFormula x = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("x");
            prover.addConstraint(this.rmgr.lessThan(x, this.rmgr.makeNumber(1L)));
            int handle = prover.maximize(x);
            Truth.assertThat((Comparable)((Object)prover.check())).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.of((long)1L));
            Truth8.assertThat(prover.upper(handle, Rational.of((String)"1/10"))).hasValue((Object)Rational.of((String)"9/10"));
        }
    }
}

