/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ModelEvaluationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    private void evaluateInModel(BooleanFormula constraint, Formula formula, Collection<Object> possibleExpectedValues, Collection<Formula> possibleExpectedFormulas) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(constraint);
            ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
            try (Model m = prover.getModel();){
                Truth.assertThat((Object)m.evaluate(formula)).isIn(possibleExpectedValues);
                Formula eval = m.eval(formula);
                if (eval != null && this.solver == SolverContextFactory.Solvers.SMTINTERPOL) {
                    Truth.assertThat((String)eval.toString()).isIn((Iterable)Collections2.transform(possibleExpectedFormulas, f -> "" + f));
                }
            }
        }
    }

    @Test
    public void testGetSmallIntegersEvaluation1() throws SolverException, InterruptedException {
        this.evaluateInModel(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), (Formula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z")), Lists.newArrayList((Object[])new Object[]{null, BigInteger.ZERO}), Lists.newArrayList((Object[])new Formula[]{null, this.imgr.makeNumber(0L)}));
    }

    @Test
    public void testGetSmallIntegersEvaluation2() throws SolverException, InterruptedException {
        this.evaluateInModel(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)), (Formula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), Lists.newArrayList((Object[])new Object[]{null, BigInteger.ONE}), Lists.newArrayList((Object[])new Formula[]{null, this.imgr.makeNumber(1L)}));
    }

    @Test
    public void testGetNegativeIntegersEvaluation() throws SolverException, InterruptedException {
        this.evaluateInModel(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-10L)), (Formula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), Lists.newArrayList((Object[])new Object[]{null, BigInteger.ONE}), Lists.newArrayList((Object[])new Formula[]{null, this.imgr.makeNumber(1L)}));
    }

    @Test
    public void testGetSmallIntegralRationalsEvaluation1() throws SolverException, InterruptedException {
        this.requireRationals();
        this.evaluateInModel(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(1L)), (Formula)this.rmgr.add(this.rmgr.makeVariable("y"), this.rmgr.makeVariable("y")), Lists.newArrayList((Object[])new Object[]{null, Rational.ZERO}), Lists.newArrayList((Object[])new Formula[]{null, this.rmgr.makeNumber(0L)}));
    }

    @Test
    public void testGetSmallIntegralRationalsEvaluation2() throws SolverException, InterruptedException {
        this.requireRationals();
        this.evaluateInModel(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(1L)), (Formula)this.rmgr.makeVariable("y"), Lists.newArrayList((Object[])new Object[]{null, Rational.ZERO}), Lists.newArrayList((Object[])new Formula[]{null, this.rmgr.makeNumber(0L)}));
    }

    @Test
    public void testGetRationalsEvaluation() throws SolverException, InterruptedException {
        this.requireRationals();
        this.evaluateInModel(this.rmgr.equal(this.rmgr.makeVariable("x"), this.rmgr.makeNumber(Rational.ofString((String)"1/3"))), (Formula)this.rmgr.divide(this.rmgr.makeVariable("y"), this.rmgr.makeNumber(2L)), Lists.newArrayList((Object[])new Object[]{null, Rational.ZERO}), Lists.newArrayList((Object[])new Formula[]{null, this.rmgr.makeNumber(0L)}));
    }

    @Test
    public void testGetBooleansEvaluation() throws SolverException, InterruptedException {
        this.evaluateInModel(this.bmgr.makeVariable("x"), this.bmgr.makeVariable("y"), Lists.newArrayList((Object[])new Object[]{null, false}), Lists.newArrayList((Object[])new Formula[]{null, this.bmgr.makeBoolean(false)}));
    }
}

