/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.Lists;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class BitvectorFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.requireBitvectors();
    }

    @Test
    public void bvType() {
        Iterator iterator = Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 32, 64, 1000}).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            FormulaType.BitvectorType type = FormulaType.getBitvectorTypeWithSize(i);
            ((IntegerSubject)Truth.assertThat((Integer)type.getSize()).named("bitvector type size", new Object[0])).isEqualTo((Object)i);
            BitvectorFormula var = this.bvmgr.makeVariable(type, "x" + i);
            FormulaType.BitvectorType result = (FormulaType.BitvectorType)this.mgr.getFormulaType(var);
            ((IntegerSubject)Truth.assertThat((Integer)result.getSize()).named("bitvector size", new Object[0])).isEqualTo((Object)i);
        }
    }

    @Test
    public void bvOne() throws SolverException, InterruptedException {
        Iterator iterator = Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 32, 64, 1000}).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            BitvectorFormula var = this.bvmgr.makeVariable(i, "x" + i);
            BitvectorFormula num0 = this.bvmgr.makeBitvector(i, 0L);
            BitvectorFormula num1 = this.bvmgr.makeBitvector(i, 1L);
            this.assertThatFormula(this.bvmgr.equal(var, num0)).isSatisfiable();
            this.assertThatFormula(this.bvmgr.equal(var, num1)).isSatisfiable();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void bvTooLargeNum() {
        this.bvmgr.makeBitvector(1, 2L);
    }

    @Test
    public void bvLargeNum() {
        this.bvmgr.makeBitvector(1, 1L);
    }

    @Test
    public void bvSmallNum() {
        this.bvmgr.makeBitvector(1, -1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void bvTooSmallNum() {
        this.bvmgr.makeBitvector(1, -2L);
    }

    @Test
    public void bvModelValue32bit() throws SolverException, InterruptedException {
        BitvectorFormula var = this.bvmgr.makeVariable(32, "var");
        LinkedHashMap<Long, Long> values = new LinkedHashMap<Long, Long>();
        long int32 = 0x100000000L;
        values.put(0L, 0L);
        values.put(1L, 1L);
        values.put(2L, 2L);
        values.put(123L, 123L);
        values.put((Long)Integer.MAX_VALUE, (Long)Integer.MAX_VALUE);
        values.put(0x80000000L, 0x80000000L);
        values.put(0x80000001L, 0x80000001L);
        values.put(2147483770L, 2147483770L);
        values.put(int32 - 1L, int32 - 1L);
        values.put(int32 - 2L, int32 - 2L);
        values.put(int32 - 123L, int32 - 123L);
        values.put(-1L, int32 - 1L);
        values.put(-2L, int32 - 2L);
        values.put(-123L, int32 - 123L);
        values.put((Long)Integer.MIN_VALUE, 0x80000000L);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            for (Map.Entry entry : values.entrySet()) {
                prover.push(this.bvmgr.equal(var, this.bvmgr.makeBitvector(32, (Long)entry.getKey())));
                ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
                try (Model model = prover.getModel();){
                    BigInteger value = model.evaluate(var);
                    Truth.assertThat((Object)value).isEqualTo((Object)BigInteger.valueOf((Long)entry.getValue()));
                }
                prover.pop();
            }
        }
    }
}

