/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolInterpolatingProver;

class LoggingSmtInterpolInterpolatingProver
extends SmtInterpolInterpolatingProver {
    private final PrintWriter out;

    LoggingSmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions, PrintWriter pOut) {
        super(pMgr, pOptions);
        this.out = (PrintWriter)Preconditions.checkNotNull((Object)pOut);
    }

    @Override
    public void push() {
        this.out.println("(push 1)");
        super.push();
    }

    @Override
    public void pop() {
        this.out.println("(pop 1)");
        super.pop();
    }

    @Override
    public String addConstraint(BooleanFormula f) {
        this.out.print("(assert (" + f + "))");
        String result = super.addConstraint(f);
        this.out.println(" ; annotated term: " + result);
        return result;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        this.out.println("(get-unsat-core)");
        return super.getUnsatCore();
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> predicates) throws InterruptedException, SolverException {
        this.out.println("(all-sat (" + Joiner.on((String)", ").join(predicates) + "))");
        return super.allSat(callback, predicates);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        this.out.print("(check-sat)");
        boolean isUnsat = super.isUnsat();
        this.out.println(" ; " + (isUnsat ? "UNSAT" : "SAT"));
        return isUnsat;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        this.out.println("(get-interpolants " + partitionedTermNames + " " + Arrays.toString(startOfSubTree) + ")");
        return super.getTreeInterpolants(partitionedTermNames, startOfSubTree);
    }

    @Override
    public void close() {
        this.out.close();
        super.close();
    }
}

