/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.primitives.Longs;
import com.microsoft.z3.Native;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3BooleanFormulaManager
extends AbstractBooleanFormulaManager<Long, Long, Long, Long> {
    private final long z3context;
    private final long z3true;
    private final long z3false;

    Z3BooleanFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
        this.z3true = Native.mkTrue((long)this.z3context);
        Native.incRef((long)this.z3context, (long)this.z3true);
        this.z3false = Native.mkFalse((long)this.z3context);
        Native.incRef((long)this.z3context, (long)this.z3false);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = (Long)this.getFormulaCreator().getBoolType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Long makeBooleanImpl(boolean pValue) {
        if (pValue) {
            return Native.mkTrue((long)this.z3context);
        }
        return Native.mkFalse((long)this.z3context);
    }

    @Override
    protected Long not(Long pParam) {
        return Native.mkNot((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long and(Long pParam1, Long pParam2) {
        if (this.isTrue(pParam1)) {
            return pParam2;
        }
        if (this.isTrue(pParam2)) {
            return pParam1;
        }
        if (this.isFalse(pParam1)) {
            return this.z3false;
        }
        if (this.isFalse(pParam2)) {
            return this.z3false;
        }
        if (Native.isEqAst((long)this.z3context, (long)pParam1, (long)pParam2)) {
            return pParam1;
        }
        return Native.mkAnd((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long or(Long pParam1, Long pParam2) {
        if (this.isTrue(pParam1)) {
            return this.z3true;
        }
        if (this.isTrue(pParam2)) {
            return this.z3true;
        }
        if (this.isFalse(pParam1)) {
            return pParam2;
        }
        if (this.isFalse(pParam2)) {
            return pParam1;
        }
        if (Native.isEqAst((long)this.z3context, (long)pParam1, (long)pParam2)) {
            return pParam1;
        }
        return Native.mkOr((long)this.z3context, (int)2, (long[])new long[]{pParam1, pParam2});
    }

    @Override
    protected Long orImpl(Collection<Long> params) {
        if (params.size() == 2) {
            Iterator<Long> it = params.iterator();
            return this.or(it.next(), it.next());
        }
        return Native.mkOr((long)this.z3context, (int)params.size(), (long[])Longs.toArray(params));
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toDisjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::or);
    }

    @Override
    protected Long andImpl(Collection<Long> params) {
        if (params.size() == 2) {
            Iterator<Long> it = params.iterator();
            return this.and(it.next(), it.next());
        }
        return Native.mkAnd((long)this.z3context, (int)params.size(), (long[])Longs.toArray(params));
    }

    @Override
    public Collector<BooleanFormula, ?, BooleanFormula> toConjunction() {
        return Collectors.collectingAndThen(Collectors.toList(), this::and);
    }

    @Override
    protected Long xor(Long pParam1, Long pParam2) {
        return Native.mkXor((long)this.z3context, (long)pParam1, (long)pParam2);
    }

    @Override
    protected Long equivalence(Long pBits1, Long pBits2) {
        return Native.mkEq((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected Long implication(Long pBits1, Long pBits2) {
        return Native.mkImplies((long)this.z3context, (long)pBits1, (long)pBits2);
    }

    @Override
    protected boolean isTrue(Long pParam) {
        return Native.isEqAst((long)this.z3context, (long)pParam, (long)this.z3true);
    }

    @Override
    protected boolean isFalse(Long pParam) {
        return Native.isEqAst((long)this.z3context, (long)pParam, (long)this.z3false);
    }

    @Override
    protected Long ifThenElse(Long pCond, Long pF1, Long pF2) {
        return Native.mkIte((long)this.z3context, (long)pCond, (long)pF1, (long)pF2);
    }
}

